/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelEnvironment;
import weblogic.kernel.KernelLogger;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.collections.PropertiesHelper;

public abstract class MBeanStub {
    private static final Class[] STRING_PARAM = new Class[]{String.class};
    private static final Map primitivePromotionMap = new HashMap();
    private boolean isPersisted = true;
    private boolean isDefaulted = false;

    private static Class promote(Class clazz) {
        Class clazz2 = (Class)primitivePromotionMap.get(clazz);
        return clazz2 == null ? clazz : clazz2;
    }

    protected final void initializeFromSystemProperties(String string) {
        if (!KernelEnvironment.getKernelEnvironment().isInitializeFromSystemPropertiesAllowed(string)) {
            throw new UnsupportedOperationException("Initialize WebLogic system properties with prefix " + string + " is not allowed");
        }
        Class<?> clazz = this.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            String string2;
            Method method = methodArray[i];
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1 || !(string2 = method.getName()).startsWith("set") || string2.length() == 3) continue;
            String string3 = string2.substring(3);
            String string4 = string + string3;
            String string5 = null;
            try {
                string5 = System.getProperty(string4);
                if (string5 == null) {
                    continue;
                }
            }
            catch (SecurityException securityException) {
                if (Kernel.isApplet()) {
                    return;
                }
                KernelLogger.logErrorInitialingFromSystemProperties((String)clazz.getName(), (String)string3, (String)"", (String)StackTraceUtils.throwable2StackTrace((Throwable)securityException));
            }
            if (classArray[0] == Properties.class) {
                object = PropertiesHelper.parse((String)string5);
                try {
                    method.invoke((Object)this, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    KernelLogger.logErrorInitialingFromSystemProperties((String)clazz.getName(), (String)string3, (String)string5, (String)StackTraceUtils.throwable2StackTrace((Throwable)invocationTargetException.getTargetException()));
                }
                catch (Exception exception) {
                    KernelLogger.logErrorInitialingFromSystemProperties((String)clazz.getName(), (String)string3, (String)string5, (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                continue;
            }
            object = null;
            try {
                object = MBeanStub.promote(classArray[0]).getConstructor(STRING_PARAM);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                KernelLogger.logNoConstructorWithStringParam((String)clazz.getName(), (String)method.getName(), (String)string3, (String)string5);
            }
            catch (Exception exception) {
                KernelLogger.logErrorInitialingFromSystemProperties((String)clazz.getName(), (String)string3, (String)string5, (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            if (object == null) continue;
            try {
                method.invoke((Object)this, ((Constructor)object).newInstance(string5));
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                KernelLogger.logErrorInitialingFromSystemProperties((String)clazz.getName(), (String)string3, (String)string5, (String)StackTraceUtils.throwable2StackTrace((Throwable)invocationTargetException.getTargetException()));
                continue;
            }
            catch (Exception exception) {
                KernelLogger.logErrorInitialingFromSystemProperties((String)clazz.getName(), (String)string3, (String)string5, (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }
    }

    public final Object getKey() {
        return this.getName();
    }

    public final String getAttributeStringValue(String string) {
        return null;
    }

    public final Set getSetFields() {
        return null;
    }

    public final String getNotes() {
        return null;
    }

    public final void setNotes(String string) {
    }

    public final Element getXml(Document document) {
        return null;
    }

    public final Element getXmlConverter(Document document) {
        return null;
    }

    public void freezeCurrentValue(String string) {
    }

    public void restoreDefaultValue(String string) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    public boolean isPersistenceEnabled() {
        return this.isPersisted;
    }

    public void setPersistenceEnabled(boolean bl) {
        this.isPersisted = bl;
    }

    public boolean isDefaultedMBean() {
        return this.isDefaulted;
    }

    public void setDefaultedMBean(boolean bl) {
        this.isDefaulted = bl;
    }

    public String getComments() {
        return null;
    }

    public void setComments(String string) {
    }

    public void addLinkMbeanAttribute(String string, ObjectName objectName) {
    }

    public final void registerConfigMBean(String string, MBeanServer mBeanServer) {
    }

    public final void unRegisterConfigMBean(String string) {
    }

    public final void touch() {
    }

    public void linkToRepository(Object object) {
    }

    public String getName() {
        return null;
    }

    public final void setName(String string) {
    }

    public final String getType() {
        return null;
    }

    public final WebLogicObjectName getObjectName() {
        return null;
    }

    public final boolean isCachingDisabled() {
        return false;
    }

    public final WebLogicMBean getParent() {
        return null;
    }

    public final void setParent(WebLogicMBean webLogicMBean) {
    }

    public final boolean isRegistered() {
        return true;
    }

    public final void postDeregister() {
    }

    public final void preDeregister() {
    }

    public final void postRegister(Boolean bl) {
    }

    public final ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        return null;
    }

    public final void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
    }

    public final void removeNotificationListener(NotificationListener notificationListener) {
    }

    public final MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public final Object getAttribute(String string) {
        return null;
    }

    public final void setAttribute(Attribute attribute) {
    }

    public final AttributeList getAttributes(String[] stringArray) {
        return null;
    }

    public final AttributeList setAttributes(AttributeList attributeList) {
        return null;
    }

    public final MBeanInfo getMBeanInfo() {
        return null;
    }

    public final Object invoke(String string, Object[] objectArray, String[] stringArray) {
        return null;
    }

    public Descriptor getDescriptor() {
        return null;
    }

    public DescriptorBean getParentBean() {
        return null;
    }

    public boolean isSet(String string) {
        return false;
    }

    public void unSet(String string) {
    }

    public void addBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public void removeBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public boolean isEditable() {
        return false;
    }

    public Object clone() {
        return null;
    }

    public DescriptorBean createChildCopy(String string, DescriptorBean descriptorBean) {
        throw new UnsupportedOperationException();
    }

    public DescriptorBean createChildCopyIncludingObsolete(String string, DescriptorBean descriptorBean) {
        throw new UnsupportedOperationException();
    }

    static {
        primitivePromotionMap.put(Boolean.TYPE, Boolean.class);
        primitivePromotionMap.put(Character.TYPE, Character.class);
        primitivePromotionMap.put(Byte.TYPE, Byte.class);
        primitivePromotionMap.put(Short.TYPE, Short.class);
        primitivePromotionMap.put(Integer.TYPE, Integer.class);
        primitivePromotionMap.put(Long.TYPE, Long.class);
        primitivePromotionMap.put(Float.TYPE, Float.class);
        primitivePromotionMap.put(Double.TYPE, Double.class);
    }
}

