/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelMBeanStub;
import weblogic.kernel.MBeanStub;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;

public class NetworkAccessPointMBeanStub
extends MBeanStub
implements NetworkAccessPointMBean {
    private String protocol;
    private String address;
    private String name;
    private boolean timeoutConnectionWithPendingResponses = false;
    private boolean sdpEnabled;
    private boolean t3SenderQueueEnabled;
    protected KernelMBean config;
    private int port = -1;
    private boolean httpEnabledForThisProtocol = false;
    private boolean outboundEnabled = false;
    private boolean fastSerialization = false;

    NetworkAccessPointMBeanStub() {
        this.initializeFromSystemProperties("weblogic.channels.");
    }

    public NetworkAccessPointMBeanStub(String string) {
        this(string, NetworkAccessPointMBeanStub.getKernelConfig());
    }

    private static KernelMBean getKernelConfig() {
        Kernel.ensureInitialized();
        return Kernel.getConfig();
    }

    public NetworkAccessPointMBeanStub(String string, KernelMBean kernelMBean) {
        this.initializeFromSystemProperties("weblogic." + string + ".");
        this.protocol = string;
        this.config = kernelMBean;
        this.name = "Default";
    }

    public static NetworkAccessPointMBean createBootstrapStub() {
        NetworkAccessPointMBeanStub networkAccessPointMBeanStub = new NetworkAccessPointMBeanStub("ADMIN".toLowerCase(), new KernelMBeanStub());
        networkAccessPointMBeanStub.httpEnabledForThisProtocol = true;
        networkAccessPointMBeanStub.outboundEnabled = true;
        networkAccessPointMBeanStub.name = " Bootstrap";
        return networkAccessPointMBeanStub;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) throws InvalidAttributeValueException {
        this.protocol = string;
    }

    public String getListenAddress() {
        return this.address;
    }

    public void setListenAddress(String string) throws InvalidAttributeValueException {
        this.address = string;
    }

    public String getPublicAddress() {
        return this.getListenAddress();
    }

    public void setPublicAddress(String string) throws InvalidAttributeValueException {
    }

    public int getListenPort() {
        return this.port;
    }

    public void setListenPort(int n) {
        this.port = n;
    }

    public int getPublicPort() {
        return this.getListenPort();
    }

    public void setPublicPort(int n) {
    }

    public String getProxyAddress() {
        return null;
    }

    public void setProxyAddress(String string) {
    }

    public int getProxyPort() {
        return -1;
    }

    public void setProxyPort(int n) {
    }

    public boolean isHttpEnabledForThisProtocol() {
        return this.httpEnabledForThisProtocol;
    }

    public void setHttpEnabledForThisProtocol(boolean bl) throws InvalidAttributeValueException {
    }

    public int getAcceptBacklog() {
        return 50;
    }

    public void setAcceptBacklog(int n) {
    }

    public int getMaxBackoffBetweenFailures() {
        return 10000;
    }

    public void setMaxBackoffBetweenFailures(int n) {
    }

    public int getLoginTimeoutMillis() {
        return 5000;
    }

    public void setLoginTimeoutMillis(int n) {
    }

    public int getConnectTimeout() {
        return this.config.getConnectTimeout();
    }

    public void setConnectTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setConnectTimeout(n);
    }

    public int getTunnelingClientPingSecs() {
        return 0;
    }

    public void setTunnelingClientPingSecs(int n) throws InvalidAttributeValueException {
    }

    public int getTunnelingClientTimeoutSecs() {
        return 0;
    }

    public void setTunnelingClientTimeoutSecs(int n) throws InvalidAttributeValueException {
    }

    public boolean isTunnelingEnabled() {
        return false;
    }

    public void setTunnelingEnabled(boolean bl) throws InvalidAttributeValueException {
    }

    public int getCompleteMessageTimeout() {
        return this.config.getCompleteMessageTimeout();
    }

    public void setCompleteMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setCompleteMessageTimeout(n);
    }

    public int getIdleConnectionTimeout() {
        return this.config.getIdleConnectionTimeout();
    }

    public void setIdleConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setIdleConnectionTimeout(n);
    }

    public int getMaxMessageSize() {
        int n = this.config.getMaxMessageSize();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public void setMaxMessageSize(int n) throws InvalidAttributeValueException, DistributedManagementException {
        this.config.setMaxMessageSize(n);
    }

    public boolean isOutboundEnabled() {
        return this.outboundEnabled;
    }

    public void setOutboundEnabled(boolean bl) throws InvalidAttributeValueException {
    }

    public int getChannelWeight() {
        return 0;
    }

    public void setChannelWeight(int n) throws InvalidAttributeValueException {
    }

    public String getClusterAddress() {
        return null;
    }

    public void setClusterAddress(String string) throws InvalidAttributeValueException {
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean bl) throws InvalidAttributeValueException {
    }

    public int getMaxConnectedClients() {
        return Integer.MAX_VALUE;
    }

    public void setMaxConnectedClients(int n) throws InvalidAttributeValueException {
    }

    public boolean isTwoWaySSLEnabled() {
        return false;
    }

    public void setTwoWaySSLEnabled(boolean bl) {
    }

    public boolean isChannelIdentityCustomized() {
        return false;
    }

    public void setChannelIdentityCustomized(boolean bl) {
    }

    public String getCustomPrivateKeyAlias() {
        return null;
    }

    public void setCustomPrivateKeyAlias(String string) {
    }

    public String getPrivateKeyAlias() {
        return this.getCustomPrivateKeyAlias();
    }

    public boolean isOutboundPrivateKeyEnabled() {
        return false;
    }

    public void setOutboundPrivateKeyEnabled(boolean bl) {
    }

    public boolean getUseFastSerialization() {
        if ("iiop".equals(this.protocol)) {
            return Kernel.getConfig().getIIOP().getUseJavaSerialization();
        }
        return this.fastSerialization;
    }

    public void setUseFastSerialization(boolean bl) throws InvalidAttributeValueException {
        this.fastSerialization = bl;
    }

    public String getCustomPrivateKeyPassPhrase() {
        return null;
    }

    public void setCustomPrivateKeyPassPhrase(String string) {
    }

    public String getPrivateKeyPassPhrase() {
        return this.getCustomPrivateKeyPassPhrase();
    }

    public byte[] getCustomPrivateKeyPassPhraseEncrypted() {
        return null;
    }

    public void setCustomPrivateKeyPassPhraseEncrypted(byte[] byArray) {
    }

    public boolean isClientCertificateEnforced() {
        return false;
    }

    public void setClientCertificateEnforced(boolean bl) {
    }

    public boolean getTimeoutConnectionWithPendingResponses() {
        return this.timeoutConnectionWithPendingResponses;
    }

    public void setTimeoutConnectionWithPendingResponses(boolean bl) throws InvalidAttributeValueException, DistributedManagementException {
        this.timeoutConnectionWithPendingResponses = bl;
    }

    public int getIdleIIOPConnectionTimeout() {
        return 0;
    }

    public void setIdleIIOPConnectionTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
    }

    public int getSSLListenPort() {
        return -1;
    }

    public void setSSLListenPort(int n) throws InvalidAttributeValueException {
    }

    public String getExternalDNSName() {
        return null;
    }

    public void setExternalDNSName(String string) throws InvalidAttributeValueException {
    }

    public int getLoginTimeoutMillisSSL() {
        return 0;
    }

    public void setLoginTimeoutMillisSSL(int n) throws InvalidAttributeValueException {
    }

    public int getCompleteT3MessageTimeout() {
        return 0;
    }

    public void setCompleteT3MessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
    }

    public int getCompleteHTTPMessageTimeout() {
        return 0;
    }

    public void setCompleteHTTPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
    }

    public int getCompleteCOMMessageTimeout() {
        return 0;
    }

    public void setCompleteCOMMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
    }

    public int getCompleteIIOPMessageTimeout() {
        return 0;
    }

    public void setCompleteIIOPMessageTimeout(int n) throws InvalidAttributeValueException, DistributedManagementException {
    }

    public void setCustomProperties(Properties properties) {
    }

    public Properties getCustomProperties() {
        return null;
    }

    public boolean isSDPEnabled() {
        return this.sdpEnabled;
    }

    public void setSDPEnabled(boolean bl) {
        this.sdpEnabled = bl;
    }

    public String getOutboundPrivateKeyAlias() {
        return null;
    }

    public String getOutboundPrivateKeyPassPhrase() {
        return null;
    }
}

