/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kodo.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.event.AbstractRemoteCommitProvider;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashSet;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.cluster.GroupMessage;
import weblogic.cluster.MulticastSession;
import weblogic.cluster.RecoverListener;
import weblogic.rmi.spi.HostID;

public final class ClusterRemoteCommitProvider
extends AbstractRemoteCommitProvider
implements RecoverListener,
Configurable {
    private static final String RECOVERY_DO_NOTHING = "none";
    private static final String RECOVERY_CLEAR_ALL = "clear";
    private static Localizer _loc = Localizer.forPackage(ClusterRemoteCommitProvider.class);
    protected Configuration conf;
    private int bufferSize = 10;
    private String recoverAction = "none";
    private String topics = null;
    private MulticastSession multicastSession;
    private static Set registry = new ConcurrentReferenceHashSet(0);

    public void broadcast(RemoteCommitEvent remoteCommitEvent) {
        ClusterRemoteCommitEvent clusterRemoteCommitEvent = new ClusterRemoteCommitEvent(this.getCacheTopics(), remoteCommitEvent);
        try {
            this.multicastSession.send(clusterRemoteCommitEvent);
        }
        catch (IOException iOException) {
            throw new InternalException(_loc.get("transmission-error"), (Throwable)iOException);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.conf = configuration;
    }

    public void endConfiguration() {
        ClusterServices clusterServices = ClusterService.getServices();
        if (clusterServices == null) {
            throw new InternalException(_loc.get("no-transport"));
        }
        this.multicastSession = clusterServices.createMulticastSession(this, this.bufferSize);
        if (this.multicastSession == null) {
            throw new InternalException(_loc.get("no-multicast-session"));
        }
        registry.add(this.conf);
    }

    public void close() {
        registry.remove(this.conf);
    }

    public GroupMessage createRecoverMessage() {
        String string = RECOVERY_DO_NOTHING.equalsIgnoreCase(this.recoverAction) ? null : this.getCacheTopics();
        return new ClusterRemoteCommitEvent(string, null);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setRecoverAction(String string) {
        if (RECOVERY_DO_NOTHING.equalsIgnoreCase(string)) {
            this.recoverAction = string;
        } else if (RECOVERY_CLEAR_ALL.equalsIgnoreCase(string)) {
            this.recoverAction = string;
        } else {
            throw new UserException(_loc.get("bad-recover-action", (Object)string));
        }
    }

    public String getRecoverAction() {
        return this.recoverAction;
    }

    public void setCacheTopics(String string) {
        this.topics = string;
    }

    public String getCacheTopics() {
        if (this.topics == null) {
            this.topics = this.conf == null ? null : this.conf.getId();
        }
        return this.topics;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClusterRemoteCommitEvent
    implements GroupMessage {
        protected final Collection<String> topics;
        protected final RemoteCommitEvent event;

        public ClusterRemoteCommitEvent(String string, RemoteCommitEvent remoteCommitEvent) {
            this.topics = this.split(string);
            this.event = remoteCommitEvent;
        }

        @Override
        public void execute(HostID hostID) {
            if (this.topics == null || this.topics.isEmpty()) {
                return;
            }
            if (this.isEcho(hostID)) {
                return;
            }
            for (Object e : registry) {
                RemoteCommitProvider remoteCommitProvider;
                RemoteCommitEventManager remoteCommitEventManager;
                if (!(e instanceof OpenJPAConfiguration) || (remoteCommitEventManager = ((OpenJPAConfiguration)e).getRemoteCommitEventManager()) == null || !((remoteCommitProvider = remoteCommitEventManager.getRemoteCommitProvider()) instanceof ClusterRemoteCommitProvider) || !this.intersects(this.topics, this.split(((ClusterRemoteCommitProvider)remoteCommitProvider).getCacheTopics()))) continue;
                if (this.isClearAll()) {
                    this.clearAll(remoteCommitEventManager.getListeners());
                    continue;
                }
                remoteCommitEventManager.fireEvent((Object)this.event);
            }
        }

        private boolean isClearAll() {
            return this.event == null;
        }

        private void clearAll(Collection collection) {
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (Object e : collection) {
                if (!(e instanceof DataCache)) continue;
                ((DataCache)e).clear();
            }
        }

        boolean isEcho(HostID hostID) {
            return false;
        }

        Collection<String> split(String string) {
            if (string == null) {
                return null;
            }
            String[] stringArray = string.split(",");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                arrayList.add(string2.trim());
            }
            return arrayList;
        }

        boolean intersects(Collection<String> collection, Collection<String> collection2) {
            if (collection == null && collection2 == null) {
                return true;
            }
            if (collection == null || collection2 == null) {
                return false;
            }
            for (String string : collection) {
                if (!collection2.contains(string)) continue;
                return true;
            }
            return false;
        }
    }
}

