/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kodo.monitoring;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import kodo.datacache.KodoDataCacheManager;
import kodo.datacache.MonitoringDataCache;
import kodo.datacache.MonitoringQueryCache;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import weblogic.kodo.monitoring.KodoDataCacheRuntimeMBeanImpl;
import weblogic.kodo.monitoring.KodoPersistenceUnitRuntimeMBeanImpl;
import weblogic.kodo.monitoring.KodoQueryCacheRuntimeMBeanImpl;
import weblogic.kodo.monitoring.KodoQueryCompilationCacheRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.KodoDataCacheRuntimeMBean;
import weblogic.management.runtime.KodoPersistenceUnitRuntimeMBean;
import weblogic.management.runtime.KodoQueryCacheRuntimeMBean;
import weblogic.management.runtime.KodoQueryCompilationCacheRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;

public class KodoPersistenceUnitRuntimeMBeanFactory {
    private static KodoPersistenceUnitRuntimeMBeanFactory factory = new KodoPersistenceUnitRuntimeMBeanFactory();

    public static KodoPersistenceUnitRuntimeMBeanFactory getInstance() {
        return factory;
    }

    public KodoPersistenceUnitRuntimeMBean createKodoPersistenceUnitRuntimeMBean(String string, RuntimeMBean runtimeMBean, EntityManagerFactory entityManagerFactory) throws ManagementException {
        if (!(entityManagerFactory instanceof OpenJPAEntityManagerFactorySPI)) {
            return null;
        }
        OpenJPAConfiguration openJPAConfiguration = ((OpenJPAEntityManagerFactorySPI)entityManagerFactory).getConfiguration();
        Map map = openJPAConfiguration.getQueryCompilationCacheInstance();
        DataCacheManager dataCacheManager = openJPAConfiguration.getDataCacheManagerInstance();
        if (dataCacheManager == null || !(dataCacheManager instanceof KodoDataCacheManager)) {
            return null;
        }
        KodoPersistenceUnitRuntimeMBeanImpl kodoPersistenceUnitRuntimeMBeanImpl = new KodoPersistenceUnitRuntimeMBeanImpl(string, runtimeMBean);
        KodoDataCacheManager kodoDataCacheManager = (KodoDataCacheManager)dataCacheManager;
        KodoDataCacheRuntimeMBean[] kodoDataCacheRuntimeMBeanArray = this.getDataCacheRuntimeMBean(kodoPersistenceUnitRuntimeMBeanImpl, kodoDataCacheManager);
        KodoQueryCacheRuntimeMBean[] kodoQueryCacheRuntimeMBeanArray = this.getQueryCacheRuntimeMBean(kodoPersistenceUnitRuntimeMBeanImpl, kodoDataCacheManager);
        KodoQueryCompilationCacheRuntimeMBean kodoQueryCompilationCacheRuntimeMBean = this.getQueryCompilationCacheRuntimeMBean(kodoPersistenceUnitRuntimeMBeanImpl, map);
        kodoPersistenceUnitRuntimeMBeanImpl.setDataCacheRuntimes(kodoDataCacheRuntimeMBeanArray);
        kodoPersistenceUnitRuntimeMBeanImpl.setQueryCacheRuntimes(kodoQueryCacheRuntimeMBeanArray);
        kodoPersistenceUnitRuntimeMBeanImpl.setQueryCompilationCacheRuntime(kodoQueryCompilationCacheRuntimeMBean);
        return kodoPersistenceUnitRuntimeMBeanImpl;
    }

    private KodoDataCacheRuntimeMBean[] getDataCacheRuntimeMBean(RuntimeMBean runtimeMBean, KodoDataCacheManager kodoDataCacheManager) throws ManagementException {
        String[] stringArray = kodoDataCacheManager.getDataCacheNames();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        KodoDataCacheRuntimeMBean[] kodoDataCacheRuntimeMBeanArray = new KodoDataCacheRuntimeMBean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            MonitoringDataCache monitoringDataCache = (MonitoringDataCache)kodoDataCacheManager.getDataCache(stringArray[i]);
            kodoDataCacheRuntimeMBeanArray[i] = new KodoDataCacheRuntimeMBeanImpl(monitoringDataCache.getName(), runtimeMBean, kodoDataCacheManager, monitoringDataCache);
        }
        return kodoDataCacheRuntimeMBeanArray;
    }

    private KodoQueryCacheRuntimeMBean[] getQueryCacheRuntimeMBean(RuntimeMBean runtimeMBean, KodoDataCacheManager kodoDataCacheManager) throws ManagementException {
        MonitoringQueryCache monitoringQueryCache = (MonitoringQueryCache)kodoDataCacheManager.getSystemQueryCache();
        if (monitoringQueryCache != null) {
            return new KodoQueryCacheRuntimeMBean[]{new KodoQueryCacheRuntimeMBeanImpl(runtimeMBean.getName(), runtimeMBean, monitoringQueryCache)};
        }
        return null;
    }

    private KodoQueryCompilationCacheRuntimeMBean getQueryCompilationCacheRuntimeMBean(RuntimeMBean runtimeMBean, Map map) throws ManagementException {
        if (map != null) {
            return new KodoQueryCompilationCacheRuntimeMBeanImpl(runtimeMBean.getName(), runtimeMBean, map);
        }
        return null;
    }
}

