/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ldap;

import com.octetstring.vde.ExternalExecutor;
import com.octetstring.vde.LDAPServer;
import com.octetstring.vde.WorkQueueItem;
import com.octetstring.vde.acl.ACLChecker;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.backend.standard.BackendStandard;
import com.octetstring.vde.replication.Consumer;
import com.octetstring.vde.replication.Replication;
import com.octetstring.vde.schema.InitSchema;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.util.EncryptionHelper;
import com.octetstring.vde.util.ExternalLogger;
import com.octetstring.vde.util.LDIF;
import com.octetstring.vde.util.Logger;
import com.octetstring.vde.util.ServerConfig;
import com.octetstring.vde.util.TimedActivityThread;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.internet.MimeUtility;
import weblogic.ldap.EmbeddedLDAPChangeListener;
import weblogic.ldap.EmbeddedLDAPException;
import weblogic.ldap.EmbeddedLDAPLogger;
import weblogic.ldap.EntryChangesListenerImpl;
import weblogic.ldap.LDAPExecuteRequest;
import weblogic.ldap.MuxableSocketLDAP;
import weblogic.ldap.MuxableSocketLDAPS;
import weblogic.ldap.ProtocolHandlerLDAP;
import weblogic.ldap.ProtocolHandlerLDAPS;
import weblogic.logging.LogOutputStream;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.EmbeddedLDAPMBean;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.security.RDBMSSecurityStoreMBean;
import weblogic.management.security.authentication.AuthenticationProviderMBean;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.management.servlet.FileDistributionServlet;
import weblogic.protocol.AdminServerIdentity;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.protocol.URLManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.providers.authentication.DefaultAuthenticatorMBean;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.FileUtils;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.net.InetAddressHelper;
import weblogic.work.WorkManagerFactory;

public final class EmbeddedLDAP
extends AbstractServerService
implements ExternalLogger,
ExternalExecutor {
    private static final String EMBEDDED_LDAP_DIR_NAME = "ldap";
    public static final String ROOT_USER_NAME = "cn=Admin";
    private static final String VDE_BACKUP_DIR = "backup";
    private static final String VDE_CONF_DIR = "conf";
    private static final String VDE_LOG_DIR = "log";
    private static final String VDE_DATA_DIR = "ldapfiles";
    private static final String VDE_REPLICADATA_DIR = "replicadata";
    private static final String VDE_PROP_NAME = "vde.prop";
    private static final String VDE_MAPPING_NAME = "mapping.cfg";
    private static final String VDE_REPLICAS_NAME = "replicas.prop";
    private static final String VDE_INVALID_REPLICA_NAME = "replica.invalid";
    private static final String DOMAIN_SCHEMA_NAME = "dc=";
    private static final String VDE_SCHEMA_FILENAME = "schema.core.xml";
    private static final String VDE_BACKENDTYPES_FILENAME = "adaptertypes.prop";
    private static final String VDE_BACKEND_FILENAME = "adapters.prop";
    private static final String VDE_ACL_FILENAME = "acls.prop";
    private static final String VDE_DATA_DIR_LOCK = "EmbeddedLDAP.lok";
    public static final String VDE_PROPS_REPLICA = "replica.";
    public static final String EMBEDDED_LDAP = "EmbeddedLDAP";
    private static final int timerInterval = 60000;
    private static EmbeddedLDAP singleton = null;
    private static final LogOutputStream log = new LogOutputStream("EmbeddedLDAP");
    private static boolean masterLDAPUseSSL = false;
    private static String masterLDAPHost = null;
    private static int masterLDAPPort = 0;
    private static String masterLDAPURL;
    private static boolean isDBMSOnly;
    private int state = 1;
    private LDAPServer ldapServer;
    private Logger logger;
    private ServerMBean serverMBean;
    private EmbeddedLDAPMBean embeddedLDAPMBean;
    private ServerDebugMBean debugMBean;
    private int numReplicas = 0;
    private Properties replicaProps = null;
    private Replication replication;
    private EmbeddedLDAPTimedActivity timedActivity = null;
    private boolean invalidReplica = false;
    private boolean debugEnabled = false;
    private boolean masterFirst = false;
    private int timeout = 0;
    private BackendHandler handler;
    private BackendStandard backend = null;
    private static File lockFile;
    private FileLock lockFileLock = null;
    private String configDirPath = null;
    private Timer pollerTimer = null;
    private static final AuthenticatedSubject KERNELID;
    private static String[] confFiles;

    public EmbeddedLDAP() {
        singleton = this;
    }

    public static EmbeddedLDAP getEmbeddedLDAP() {
        return singleton;
    }

    private static boolean isDBMSStoreOnly(RuntimeAccess runtimeAccess) {
        AuthenticationProviderMBean[] authenticationProviderMBeanArray = runtimeAccess.getDomain().getSecurityConfiguration().getDefaultRealm().getAuthenticationProviders();
        RDBMSSecurityStoreMBean rDBMSSecurityStoreMBean = runtimeAccess.getDomain().getSecurityConfiguration().getDefaultRealm().getRDBMSSecurityStore();
        if (rDBMSSecurityStoreMBean == null) {
            return false;
        }
        for (int i = 0; i < authenticationProviderMBeanArray.length; ++i) {
            if (!(authenticationProviderMBeanArray[i] instanceof DefaultAuthenticatorMBean)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws ServiceFailureException {
        URI uRI;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        this.serverMBean = runtimeAccess.getServer();
        isDBMSOnly = EmbeddedLDAP.isDBMSStoreOnly(runtimeAccess);
        this.debugMBean = this.serverMBean.getServerDebug();
        boolean bl = this.debugEnabled = this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAP();
        if (this.debugEnabled) {
            log.debug("Initialize service for EmbeddedLDAP");
        }
        this.embeddedLDAPMBean = runtimeAccess.getDomain().getEmbeddedLDAP();
        if (this.embeddedLDAPMBean == null) {
            return;
        }
        String string = this.embeddedLDAPMBean.getCredential();
        if (string == null) throw new ServiceFailureException(EmbeddedLDAPLogger.getCredUnavailable());
        if (string.length() == 0) {
            throw new ServiceFailureException(EmbeddedLDAPLogger.getCredUnavailable());
        }
        String string2 = EmbeddedLDAP.getEmbeddedLDAPDir();
        boolean bl2 = this.validateVDEDirectories(string2);
        String string3 = null;
        if (!runtimeAccess.isAdminServer() && runtimeAccess.isAdminServerAvailable()) {
            boolean bl3 = bl2 || this.invalidReplica || this.embeddedLDAPMBean.isRefreshReplicaAtStartup();
            string3 = this.getInitialReplicaFromAdminServer(bl3, !bl2);
        }
        this.validateVDEConfigFiles(string2);
        this.ensureExclusiveAccess(string2);
        this.initServerConfig(string2);
        this.logger = Logger.getInstance();
        this.logger.setExternalLogger(this);
        this.ldapServer = new LDAPServer();
        MuxableSocketLDAP.initialize(this.ldapServer);
        MuxableSocketLDAPS.initialize(this.ldapServer);
        this.logger.log(5, this.ldapServer, "VDE Engine Starting");
        new InitSchema().init();
        ACLChecker.getInstance().initialize();
        Properties properties = new Properties();
        String string4 = DOMAIN_SCHEMA_NAME + runtimeAccess.getDomain().getName();
        properties.setProperty("backend.0.root", string4);
        properties.setProperty("backend.0.config.backup-hour", Integer.toString(this.embeddedLDAPMBean.getBackupHour()));
        properties.setProperty("backend.0.config.backup-minute", Integer.toString(this.embeddedLDAPMBean.getBackupMinute()));
        properties.setProperty("backend.0.config.backup-max", Integer.toString(this.embeddedLDAPMBean.getBackupCopies()));
        if (this.debugEnabled) {
            EmbeddedLDAP.debugLogProperties("VDE Backend properties: ", properties);
        }
        if (this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAPWriteOverrideProps()) {
            EmbeddedLDAP.debugWriteProperties("./lib/adaptertypes.prop", properties);
        }
        this.handler = BackendHandler.getInstance(properties);
        try {
            this.backend = (BackendStandard)this.handler.getBackend(new DirectoryString(string4));
        }
        catch (Exception exception) {
            if (!runtimeAccess.isAdminServer()) {
                this.setReplicaInvalid();
                EmbeddedLDAPLogger.logErrorInitializingLDAPReplica((Throwable)exception);
                throw new ServiceFailureException("Error initializing Embedded LDAP Server", (Throwable)exception);
            }
            EmbeddedLDAPLogger.logErrorInitializingLDAPMaster((String)(string2 + File.separator + VDE_BACKUP_DIR), (Throwable)exception);
            throw new ServiceFailureException("Error initializing Embedded LDAP Server", (Throwable)exception);
        }
        try {
            this.timedActivity = new EmbeddedLDAPTimedActivity(this.backend);
            this.pollerTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this.timedActivity, 60000L);
        }
        catch (Exception exception) {
            EmbeddedLDAPLogger.logCouldNotScheduleTrigger((String)exception.toString());
        }
        if (string3 != null) {
            this.loadInitialReplicaFile(string3);
        }
        if ((uRI = this.getMasterEmbeddedLDAPURI()) != null) {
            masterLDAPUseSSL = uRI.getScheme().equalsIgnoreCase("ldaps");
            masterLDAPHost = uRI.getHost();
            masterLDAPPort = uRI.getPort();
            masterLDAPURL = uRI.toString();
        }
        this.masterFirst = this.embeddedLDAPMBean.isMasterFirst();
        this.timeout = this.embeddedLDAPMBean.getTimeout();
        this.updateReplicaProperties();
        if (!runtimeAccess.isAdminServer() || this.numReplicas > 0) {
            this.initReplication();
        }
        if (this.debugEnabled) {
            log.debug("Start service for EmbeddedLDAP");
        }
        this.ldapServer.start();
        this.state = 2;
        if (!isDBMSOnly) return;
        if (!bl2) return;
        if (!runtimeAccess.isAdminServer()) return;
        String string5 = string4.substring(3);
        String string6 = "dn: " + string4 + "\n" + "objectclass: top" + "\n" + "objectclass: domain" + "\n" + "dc: " + string5 + "\n\n";
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            try {
                byteArrayInputStream = new ByteArrayInputStream(string6.getBytes());
                new LDIF().importLDIF(null, byteArrayInputStream, true);
            }
            catch (Exception exception) {
                throw new ServiceFailureException("Error loading the min LDAP content forEmbeddedLDAP", (Throwable)exception);
            }
            Object var14_15 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            try {
                ((InputStream)byteArrayInputStream).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        ((InputStream)byteArrayInputStream).close();
        if (!this.debugEnabled) return;
        log.debug("Populated minimum domain content for EmbeddedLDAP");
    }

    public void stop() {
        LDAPExecuteRequest.waitForRequestsToComplete();
        this.shutdown();
    }

    public void halt() {
        this.shutdown();
    }

    private void shutdown() {
        block9: {
            this.state = 0;
            LDAPExecuteRequest.waitForRequestsToComplete();
            boolean bl = this.debugEnabled = this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAP();
            if (this.debugEnabled) {
                log.debug("Shutdown server for EmbeddedLDAP");
            }
            try {
                block8: {
                    if (this.replication != null) {
                        this.replication.shutdown();
                    }
                    if (this.backend != null) {
                        this.backend.shutdown();
                    }
                    try {
                        if (this.lockFileLock != null) {
                            this.lockFileLock.release();
                            this.lockFileLock.channel().close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.debugEnabled) break block8;
                        log.debug("Exception releasing lock " + iOException);
                    }
                }
                lockFile.delete();
                FileUtils.unregisterLockFile((File)lockFile);
                lockFile = null;
                this.lockFileLock = null;
            }
            catch (Exception exception) {
                if (!this.debugEnabled) break block9;
                log.debug("Exception shutting down " + exception);
            }
        }
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public synchronized String initReplicaForNewServer(String string, String string2) {
        Object object;
        URI uRI;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        if (!runtimeAccess.isAdminServer()) {
            return null;
        }
        boolean bl = this.debugEnabled = this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAP();
        if (this.debugEnabled) {
            log.debug("init Replica for new server " + string + ", url " + string2);
        }
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new EmbeddedLDAPException("Invalid replica url: " + string2);
        }
        ServerMBean serverMBean = runtimeAccess.getDomain().lookupServer(string);
        if (serverMBean == null) {
            throw new EmbeddedLDAPException("Could not find server for Initial Replica: " + string);
        }
        int n = this.getReplicaIndex(string);
        if (n < 0) {
            n = this.numReplicas++;
        }
        boolean bl2 = uRI.getScheme().equalsIgnoreCase("ldaps");
        String string3 = VDE_PROPS_REPLICA + n;
        this.replicaProps.setProperty(string3 + ".name", string);
        this.replicaProps.setProperty(string3 + ".consumerid", string);
        this.replicaProps.setProperty(string3 + ".base", DOMAIN_SCHEMA_NAME + runtimeAccess.getDomainName());
        this.replicaProps.setProperty(string3 + ".masterid", runtimeAccess.getAdminServerName());
        this.replicaProps.setProperty(string3 + ".masterurl", masterLDAPURL + "/");
        this.replicaProps.setProperty(string3 + ".hostname", uRI.getHost());
        this.replicaProps.setProperty(string3 + ".port", Integer.toString(uRI.getPort()));
        this.replicaProps.setProperty(string3 + ".secure", bl2 ? "1" : "0");
        this.replicaProps.setProperty(string3 + ".binddn", ROOT_USER_NAME);
        this.replicaProps.setProperty("replica.num", Integer.toString(this.numReplicas));
        this.writeReplicaProps();
        if (this.replication == null) {
            this.initReplication();
        } else {
            object = this.replication.getReplicaByName(string);
            if (object != null) {
                ((Consumer)object).setHostname(uRI.getHost());
                ((Consumer)object).setPort(uRI.getPort());
                ((Consumer)object).setSecure(bl2);
            } else {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("name", string);
                hashtable.put("consumerid", string);
                hashtable.put("base", DOMAIN_SCHEMA_NAME + runtimeAccess.getDomainName());
                hashtable.put("masterid", runtimeAccess.getAdminServerName());
                hashtable.put("masterurl", masterLDAPURL + "/");
                hashtable.put("hostname", uRI.getHost());
                hashtable.put("port", Integer.toString(uRI.getPort()));
                hashtable.put("secure", bl2 ? "1" : "0");
                hashtable.put("binddn", ROOT_USER_NAME);
                hashtable.put("bindpw", this.embeddedLDAPMBean.getCredential());
                if (this.debugEnabled) {
                    log.debug("Adding replica for " + string);
                }
                this.replication.addReplica(hashtable);
            }
        }
        if (this.debugEnabled) {
            log.debug("Initializing VDE Replica for " + string);
        }
        object = EmbeddedLDAP.getEmbeddedLDAPDir() + File.separator + string + ".ldif";
        this.replication.setupAgreement(string, (String)object);
        return object;
    }

    public synchronized boolean isValidReplica(String string, String string2) {
        boolean bl = this.debugEnabled = this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAP();
        if (this.debugEnabled) {
            log.debug("validate replica status for server " + string + " url " + string2);
        }
        if (this.replication == null || this.replication.getReplicaByName(string) == null) {
            return false;
        }
        int n = this.getReplicaIndex(string);
        if (n < 0) {
            return false;
        }
        String string3 = VDE_PROPS_REPLICA + n;
        String string4 = this.replicaProps.getProperty(string3 + ".hostname");
        String string5 = this.replicaProps.getProperty(string3 + ".port");
        try {
            URI uRI = new URI(string2);
            return uRI.getHost().equals(string4) && Integer.toString(uRI.getPort()).equals(string5);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private int getReplicaIndex(String string) {
        for (int i = 0; i < this.numReplicas; ++i) {
            if (!string.equals(this.replicaProps.getProperty(VDE_PROPS_REPLICA + i + ".name"))) continue;
            return i;
        }
        return -1;
    }

    public EmbeddedLDAPMBean getEmbeddedLDAPMBean() {
        return this.embeddedLDAPMBean;
    }

    public static boolean importLDIF(String string, String string2, String string3, String string4) {
        System.setProperty("vde.home", string);
        ServerConfig serverConfig = ServerConfig.getInstance();
        try {
            serverConfig.init();
        }
        catch (IOException iOException) {
            return false;
        }
        serverConfig.setProperty("vde.server.name", "myserver");
        serverConfig.setProperty("vde.hostname", "localhost");
        serverConfig.setProperty("vde.server.port", "7003");
        serverConfig.setProperty("vde.rootuser", ROOT_USER_NAME);
        serverConfig.setProperty("vde.rootpw", "manager");
        serverConfig.setProperty("vde.logconsole", "0");
        serverConfig.setProperty("vde.tls", "0");
        serverConfig.setProperty("vde.changelog", "0");
        serverConfig.setProperty("vde.debug", "0");
        String string5 = BootStrap.getWebLogicHome() + "/lib/";
        serverConfig.setProperty("vde.schema.std", string5 + VDE_SCHEMA_FILENAME);
        serverConfig.setProperty("vde.backendtypes", string5 + VDE_BACKENDTYPES_FILENAME);
        serverConfig.setProperty("vde.server.backends", string5 + VDE_BACKEND_FILENAME);
        serverConfig.setProperty("vde.aclfile", string5 + VDE_ACL_FILENAME);
        new InitSchema().init();
        ACLChecker.getInstance().initialize();
        Properties properties = new Properties();
        properties.setProperty("backend.0.root", DOMAIN_SCHEMA_NAME + string3);
        properties.setProperty("backend.0.config.backup-hour", "23");
        properties.setProperty("backend.0.config.backup-minute", "59");
        properties.setProperty("backend.0.config.backup-max", "7");
        BackendHandler.getInstance(properties);
        return new LDIF().importLDIF(string4, null, true);
    }

    public void log(int n, String string, String string2) {
        switch (n) {
            case 7: 
            case 9: 
            case 11: {
                log.debug(string2);
                break;
            }
            case 0: {
                log.error(string2);
                break;
            }
            case 3: {
                log.warning(string2);
                break;
            }
            default: {
                log.info(string2);
            }
        }
    }

    public void printStackTrace(Throwable throwable) {
        log.critical(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
    }

    public void printStackTraceLog(Throwable throwable) {
        log.critical(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
    }

    public void printStackTraceConsole(Throwable throwable) {
        log.critical(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
    }

    public void execute(WorkQueueItem workQueueItem) {
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new LDAPExecuteRequest(workQueueItem));
    }

    private static String getEmbeddedLDAPDir() {
        return DomainDir.getLDAPDataDirForServer((String)ManagementService.getRuntimeAccess(KERNELID).getServerName());
    }

    public static String getEmbeddedLDAPDataDir() {
        return EmbeddedLDAP.getEmbeddedLDAPDir();
    }

    public static String getEmbeddedLDAPHost() {
        return masterLDAPHost;
    }

    private URI getMasterEmbeddedLDAPURI() {
        String string = null;
        if (ManagementService.getRuntimeAccess(KERNELID).isAdminServerAvailable()) {
            string = EmbeddedLDAP.findLdapURL(AdminServerIdentity.getBootstrapIdentity());
        } else {
            String string2 = ManagementService.getPropertyService(KERNELID).getAdminHost();
            string2 = InetAddressHelper.convertIfIPV6URL((String)string2);
            string = URLManager.normalizeToLDAPProtocol(string2);
        }
        if (string == null) {
            EmbeddedLDAPLogger.logCouldNotGetAdminListenAddress();
        } else {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                EmbeddedLDAPLogger.logInvalidAdminListenAddress((String)string);
            }
        }
        return null;
    }

    public static int getEmbeddedLDAPPort() {
        return masterLDAPPort;
    }

    public static String getEmbeddedLDAPDomain() {
        return ManagementService.getRuntimeAccess(KERNELID).getDomainName();
    }

    public static String getEmbeddedLDAPCredential() {
        SecurityServiceManager.checkKernelPermission();
        EmbeddedLDAPMBean embeddedLDAPMBean = EmbeddedLDAP.getEmbeddedLDAP().getEmbeddedLDAPMBean();
        return embeddedLDAPMBean.getCredential();
    }

    public static String getEmbeddedLDAPCredential(AuthenticatedSubject authenticatedSubject) {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        EmbeddedLDAPMBean embeddedLDAPMBean = EmbeddedLDAP.getEmbeddedLDAP().getEmbeddedLDAPMBean();
        return embeddedLDAPMBean.getCredential();
    }

    public static boolean getEmbeddedLDAPUseSSL() {
        return masterLDAPUseSSL;
    }

    public void setReplicaInvalid() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(EmbeddedLDAP.getEmbeddedLDAPDir() + File.separator + VDE_DATA_DIR + File.separator + VDE_INVALID_REPLICA_NAME, false));
            printWriter.println("# Replica set invalid");
            printWriter.close();
        }
        catch (IOException iOException) {
            log.debug("Got I/O error writing invalid replica file", iOException);
        }
    }

    public void setPasswords2WayEncrypted() {
        this.backend.setPasswordExternalEncryptionHelper(new EncryptionHelperImpl(new ClearOrEncryptedService(SerializedSystemIni.getEncryptionService())));
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isMasterFirst() {
        return this.masterFirst;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void registerChangeListener(String string, EmbeddedLDAPChangeListener embeddedLDAPChangeListener) {
        if (this.handler == null) {
            throw new IllegalStateException("EmbeddedLDAP has not been initialized yet");
        }
        EntryChangesListenerImpl entryChangesListenerImpl = new EntryChangesListenerImpl(string, embeddedLDAPChangeListener);
        this.handler.registerEntryChangesListener(entryChangesListenerImpl);
    }

    public static String getDateFormat(long l) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date(l));
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        String string = (n2 < 10 ? "0" : "") + n2;
        String string2 = (n3 < 10 ? "0" : "") + n3;
        String string3 = (n4 < 10 ? "0" : "") + n4;
        String string4 = (n5 < 10 ? "0" : "") + n5;
        return n + string + string2 + string3 + string4 + "Z";
    }

    private void validateVDEConfigFiles(String string) {
        String string2 = BootStrap.getWebLogicHome();
        if (string2 == null) {
            throw new EmbeddedLDAPException("weblogic.home must be set");
        }
        File file = new File(string2, "lib");
        this.configDirPath = file.getAbsolutePath() + File.separator;
        if (this.debugEnabled) {
            log.debug("Using configuration directory of " + this.configDirPath);
        }
        boolean bl = true;
        for (int i = 0; i < confFiles.length; ++i) {
            String string3;
            File file2 = new File(file, confFiles[i]);
            if (file2.exists()) continue;
            bl = false;
            try {
                string3 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                if (this.debugEnabled) {
                    log.debug("Error checking file " + confFiles[i], iOException);
                }
                string3 = file2.getAbsolutePath();
            }
            EmbeddedLDAPLogger.logConfigFileNotFound((String)string3);
        }
        if (!bl) {
            throw new EmbeddedLDAPException("Could not find configuration files - see log file for more information");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureExclusiveAccess(String string) throws ServiceFailureException {
        if (Boolean.getBoolean("weblogic.ldap.skipExclusiveAccessCheck")) {
            return;
        }
        String string2 = string + File.separator + VDE_DATA_DIR;
        try {
            try {
                lockFile = new File(string2, VDE_DATA_DIR_LOCK);
                FileOutputStream fileOutputStream = new FileOutputStream(lockFile);
                FileChannel fileChannel = fileOutputStream.getChannel();
                this.lockFileLock = fileChannel.tryLock();
                if (this.lockFileLock == null) {
                    int n = 4;
                    int n2 = 10;
                    for (int i = 0; i < n; ++i) {
                        EmbeddedLDAPLogger.logEmbeddedLDAPServerRunningRetry((String)string2, (String)Integer.toString(n2));
                        try {
                            Thread.sleep(n2 * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.lockFileLock = fileChannel.tryLock();
                        if (this.lockFileLock != null) break;
                    }
                    if (this.lockFileLock == null) {
                        Loggable loggable = EmbeddedLDAPLogger.logEmbeddedLDAPServerAlreadyRunningLoggable((String)string2);
                        loggable.log();
                        throw new ServiceFailureException(loggable.getMessageText());
                    }
                }
                Object var10_11 = null;
                if (this.lockFileLock == null) {
                    lockFile = null;
                    return;
                }
            }
            catch (IOException iOException) {
                EmbeddedLDAPLogger.logErrorGettingExclusiveAccess((String)string2, (Throwable)iOException);
                Object var10_12 = null;
                if (this.lockFileLock == null) {
                    lockFile = null;
                    return;
                }
                FileUtils.registerLockFile((File)lockFile);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (this.lockFileLock == null) {
                lockFile = null;
                throw throwable;
            }
            FileUtils.registerLockFile((File)lockFile);
            throw throwable;
        }
        FileUtils.registerLockFile((File)lockFile);
    }

    private boolean validateVDEDirectories(String string) throws ServiceFailureException {
        File file;
        File file2;
        File file3;
        File file4;
        boolean bl = false;
        File file5 = new File(string, VDE_DATA_DIR);
        if (!file5.exists()) {
            file5.mkdirs();
            bl = true;
        }
        if (!(file4 = new File(string, VDE_REPLICADATA_DIR)).exists()) {
            file4.mkdirs();
        }
        if (!(file3 = new File(string, VDE_LOG_DIR)).exists()) {
            file3.mkdirs();
        }
        if (!(file2 = new File(string, VDE_BACKUP_DIR)).exists()) {
            file2.mkdirs();
        }
        if (!(file = new File(string, VDE_CONF_DIR)).exists()) {
            file.mkdirs();
        }
        if (this.debugEnabled) {
            log.debug("Creating directories and initial files");
        }
        try {
            Object object;
            Object object2;
            File file6 = new File(file, VDE_PROP_NAME);
            if (!file6.exists()) {
                object2 = new PrintWriter(new FileWriter(file6));
                ((PrintWriter)object2).println("vde.server.threads=5");
                ((PrintWriter)object2).println("vde.schemacheck=1");
                ((PrintWriter)object2).println("vde.aclcheck=1");
                ((PrintWriter)object2).println("vde.logfile=log/EmbeddedLDAP.log");
                ((PrintWriter)object2).println("vde.logrotate.hour=0");
                ((PrintWriter)object2).println("vde.logrotate.minute=10");
                ((PrintWriter)object2).println("vde.logrotate.maxlogs=7");
                ((PrintWriter)object2).println("vde.accesslogfile=log/EmbeddedLDAPAccess.log");
                ((PrintWriter)object2).println("vde.logconsole=0");
                ((PrintWriter)object2).println("vde.changelog.suffix=cn=changelog");
                ((PrintWriter)object2).println("vde.changelog.file=ldapfiles/changelog");
                ((PrintWriter)object2).println("vde.replicas=conf/replicas.prop");
                ((PrintWriter)object2).println("vde.tls.keystore=notused");
                ((PrintWriter)object2).println("vde.tls.pass=notused");
                ((PrintWriter)object2).println("vde.quota.max.connections=1800");
                ((PrintWriter)object2).println("vde.quota.max.opspercon=0");
                int n = 100;
                try {
                    object = System.getProperty("weblogic.security.providers.authentication.LDAPDelegatePoolSize");
                    if (object != null && ((String)object).length() > 0) {
                        n = new Integer((String)object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((PrintWriter)object2).println("vde.quota.max.conpersubject=" + n);
                ((PrintWriter)object2).println("vde.quota.max.conperip=0");
                ((PrintWriter)object2).println("vde.quota.period=30000");
                ((PrintWriter)object2).println("vde.quota.exemptips=");
                ((PrintWriter)object2).println("vde.quota.exemptusers=");
                ((PrintWriter)object2).println("vde.quota.check=1");
                ((PrintWriter)object2).close();
            }
            if (!((File)(object2 = new File(file, VDE_MAPPING_NAME))).exists()) {
                ((File)object2).createNewFile();
            }
            this.replicaProps = new Properties();
            File file7 = new File(file, VDE_REPLICAS_NAME);
            if (!file7.exists()) {
                object = new PrintWriter(new FileWriter(file7));
                ((PrintWriter)object).println("replica.num=0");
                ((PrintWriter)object).close();
                this.replicaProps.setProperty("replica.num", Integer.toString(this.numReplicas));
            } else if (ManagementService.getRuntimeAccess(KERNELID).isAdminServer()) {
                object = new FileInputStream(file7);
                this.replicaProps.load((InputStream)object);
                ((FileInputStream)object).close();
                String string2 = this.replicaProps.getProperty("replica.num");
                this.numReplicas = Integer.parseInt(string2);
            }
            object = new File(file5, VDE_INVALID_REPLICA_NAME);
            if (((File)object).exists()) {
                this.invalidReplica = true;
            }
        }
        catch (IOException iOException) {
            throw new ServiceFailureException("Error creating configuration files", (Throwable)iOException);
        }
        return bl;
    }

    private ServerConfig initServerConfig(String string) throws ServiceFailureException {
        String string2;
        System.setProperty("vde.home", string);
        if (this.debugEnabled) {
            log.debug("Setting vde.home to " + string);
        }
        ServerConfig serverConfig = ServerConfig.getInstance();
        try {
            serverConfig.init();
        }
        catch (IOException iOException) {
            throw new ServiceFailureException("Error initializing VDE ", (Throwable)iOException);
        }
        serverConfig.setProperty("vde.server.name", this.serverMBean.getName());
        try {
            string2 = EmbeddedLDAP.findLocalLdapURL();
            if (string2 == null) {
                throw new ServiceFailureException("Null VDE URL");
            }
            URI uRI = new URI(string2);
            serverConfig.setProperty("vde.server.listenaddr", uRI.getHost());
            serverConfig.setProperty("vde.server.port", Integer.toString(uRI.getPort()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServiceFailureException((Throwable)uRISyntaxException);
        }
        serverConfig.setProperty("vde.rootuser", ROOT_USER_NAME);
        string2 = this.embeddedLDAPMBean.getCredential();
        serverConfig.setProperty("vde.rootpw", string2);
        serverConfig.setProperty("vde.allow.anonymous", this.embeddedLDAPMBean.isAnonymousBindAllowed() ? "true" : "false");
        boolean bl = this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAPLogToConsole();
        serverConfig.setProperty("vde.logconsole", bl ? "1" : "0");
        int n = this.debugMBean != null ? this.debugMBean.getDebugEmbeddedLDAPLogLevel() : 0;
        serverConfig.setProperty("vde.debug", Integer.toString(n));
        serverConfig.setProperty("vde.tls", "0");
        boolean bl2 = ManagementService.getRuntimeAccess(KERNELID).isAdminServer();
        serverConfig.setProperty("vde.changelog", bl2 ? "1" : "0");
        serverConfig.setProperty("vde.schema.std", this.configDirPath + VDE_SCHEMA_FILENAME);
        serverConfig.setProperty("vde.backendtypes", this.configDirPath + VDE_BACKENDTYPES_FILENAME);
        serverConfig.setProperty("vde.server.backends", this.configDirPath + VDE_BACKEND_FILENAME);
        serverConfig.setProperty("vde.aclfile", this.configDirPath + VDE_ACL_FILENAME);
        if (this.debugEnabled) {
            EmbeddedLDAP.debugLogProperties("VDE configuration properties", serverConfig);
        }
        if (this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAPWriteOverrideProps()) {
            EmbeddedLDAP.debugWriteProperties(EmbeddedLDAP.getEmbeddedLDAPDir() + File.separator + VDE_CONF_DIR + File.separator + VDE_PROP_NAME, serverConfig);
        }
        return serverConfig;
    }

    private void updateReplicaProperties() {
        String string;
        int n;
        if (this.numReplicas == 0) {
            return;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        String string2 = runtimeAccess.getAdminServerName();
        String string3 = masterLDAPURL + "/";
        String string4 = DOMAIN_SCHEMA_NAME + runtimeAccess.getDomainName();
        int n2 = 0;
        for (n = 0; n < this.numReplicas; ++n) {
            string = VDE_PROPS_REPLICA + n;
            String string5 = this.replicaProps.getProperty(string + ".name");
            if (runtimeAccess.getDomain().lookupServer(string5) == null) continue;
            String string6 = string;
            if (n != n2) {
                string6 = VDE_PROPS_REPLICA + n2;
                this.replicaProps.setProperty(string6 + ".name", string5);
                this.replicaProps.setProperty(string6 + ".consumerid", this.replicaProps.getProperty(string + ".consumerid"));
                this.replicaProps.setProperty(string6 + ".hostname", this.replicaProps.getProperty(string + ".hostname"));
                this.replicaProps.setProperty(string6 + ".port", this.replicaProps.getProperty(string + ".port"));
                this.replicaProps.setProperty(string6 + ".secure", this.replicaProps.getProperty(string + ".secure"));
            }
            this.replicaProps.setProperty(string6 + ".masterid", string2);
            this.replicaProps.setProperty(string6 + ".masterurl", string3);
            this.replicaProps.setProperty(string6 + ".base", string4);
            this.replicaProps.setProperty(string6 + ".binddn", ROOT_USER_NAME);
            ++n2;
        }
        for (n = n2; n < this.numReplicas; ++n) {
            string = VDE_PROPS_REPLICA + n;
            this.replicaProps.remove(string + ".name");
            this.replicaProps.remove(string + ".consumerid");
            this.replicaProps.remove(string + ".hostname");
            this.replicaProps.remove(string + ".port");
            this.replicaProps.remove(string + ".secure");
            this.replicaProps.remove(string + ".masterid");
            this.replicaProps.remove(string + ".masterurl");
            this.replicaProps.remove(string + ".base");
            this.replicaProps.remove(string + ".binddn");
        }
        this.numReplicas = n2;
        this.replicaProps.setProperty("replica.num", Integer.toString(this.numReplicas));
        this.writeReplicaProps();
    }

    private void initReplication() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        Properties properties = new Properties();
        String string = this.embeddedLDAPMBean.getCredential();
        if (runtimeAccess.isAdminServer()) {
            for (int i = 0; i < this.numReplicas; ++i) {
                properties.setProperty(VDE_PROPS_REPLICA + i + ".bindpw", string);
            }
        } else {
            String string2 = "replica.0";
            properties.setProperty(string2 + ".name", this.serverMBean.getName());
            properties.setProperty(string2 + ".consumerid", this.serverMBean.getName());
            properties.setProperty(string2 + ".base", DOMAIN_SCHEMA_NAME + runtimeAccess.getDomainName());
            properties.setProperty(string2 + ".masterid", runtimeAccess.getAdminServerName());
            properties.setProperty(string2 + ".masterurl", masterLDAPURL + "/");
            try {
                URI uRI = this.findLdapURI(this.serverMBean);
                properties.setProperty(string2 + ".hostname", uRI.getHost());
                properties.setProperty(string2 + ".port", Integer.toString(uRI.getPort()));
                boolean bl = uRI.getScheme().equalsIgnoreCase("ldaps");
                properties.setProperty(string2 + ".secure", bl ? "1" : "0");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalStateException("No master embedded LDAP server.");
            }
            properties.setProperty(string2 + ".binddn", ROOT_USER_NAME);
            properties.setProperty(string2 + ".bindpw", string);
            properties.setProperty("replica.num", "1");
        }
        if (this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAP()) {
            EmbeddedLDAP.debugLogProperties("VDE Replica properties: ", this.replicaProps);
            EmbeddedLDAP.debugLogProperties("VDE Override Replica properties: ", properties);
        }
        if (this.debugMBean != null && this.debugMBean.getDebugEmbeddedLDAPWriteOverrideProps()) {
            EmbeddedLDAP.debugWriteProperties(EmbeddedLDAP.getEmbeddedLDAPDir() + File.separator + VDE_CONF_DIR + File.separator + VDE_REPLICAS_NAME, properties);
        }
        this.replication = new Replication();
        this.replication.init(properties, KERNELID.getSubject());
    }

    /*
     * Unable to fully structure code
     */
    private String getInitialReplicaFromAdminServer(boolean var1_1, boolean var2_2) {
        block32: {
            block30: {
                var3_3 = null;
                var4_4 = null;
                var5_5 = null;
                try {
                    var3_3 = FileDistributionServlet.getURL();
                }
                catch (MalformedURLException var6_6) {
                    this.setReplicaInvalid();
                    throw new EmbeddedLDAPException("Unable to build initial replica url", var6_6);
                }
                var6_7 = EmbeddedLDAP.findLocalLdapURL();
                if (var6_7 == null) {
                    this.setReplicaInvalid();
                    throw new EmbeddedLDAPException("Unable to get local addressing information");
                }
                var7_8 = null;
                var7_8 = URLManager.createAdminHttpConnection(var3_3);
                ConnectionSigner.signConnection(var7_8, EmbeddedLDAP.KERNELID);
                var7_8.setRequestProperty("wl_request_type", "wl_init_replica_request");
                var7_8.setRequestProperty("init-replica_server-name", EmbeddedLDAP.mimeEncode(ManagementService.getRuntimeAccess(EmbeddedLDAP.KERNELID).getServerName()));
                var7_8.setRequestProperty("init-replica_server-url", var6_7);
                if (!var1_1) {
                    var7_8.setRequestProperty("init-replica-validate", String.valueOf(var1_1));
                }
                var7_8.setRequestProperty("Connection", "Close");
                var8_9 = null;
                var4_4 = var7_8.getInputStream();
                var9_11 = new byte[4096];
                var10_12 = var4_4.read(var9_11, 0, 4096);
                if (var10_12 != -1) ** GOTO lbl68
                if (var1_1) break block30;
                var11_13 = null;
                var13_16 = null;
                try {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var7_8 != null) {
                        var7_8.disconnect();
                    }
                }
                catch (Exception var14_20) {
                    // empty catch block
                }
                return var11_13;
            }
            if (!EmbeddedLDAP.isDBMSOnly) break block32;
            if (this.debugEnabled) {
                this.logger.log(7, this.ldapServer, "Received empty replica file for EmbeddedLDAP");
            }
            var11_14 = null;
            var13_17 = null;
            try {
                if (var4_4 != null) {
                    var4_4.close();
                }
                if (var5_5 != null) {
                    var5_5.close();
                }
                if (var7_8 != null) {
                    var7_8.disconnect();
                }
            }
            catch (Exception var14_21) {
                // empty catch block
            }
            return var11_14;
        }
        throw new EmbeddedLDAPException("Empty initial replica");
lbl68:
        // 1 sources

        var8_9 = EmbeddedLDAP.getEmbeddedLDAPDir() + File.separator + ManagementService.getRuntimeAccess(EmbeddedLDAP.KERNELID).getServerName() + ".ldif";
        var5_5 = new FileOutputStream(var8_9);
        do {
            var5_5.write(var9_11, 0, var10_12);
        } while ((var10_12 = var4_4.read(var9_11, 0, 4096)) != -1);
        if (var2_2) {
            this.cleanupDataDirectory(false);
        }
        var11_15 = var8_9;
        var13_18 = null;
        try {
            if (var4_4 != null) {
                var4_4.close();
            }
            if (var5_5 != null) {
                var5_5.close();
            }
            if (var7_8 != null) {
                var7_8.disconnect();
            }
        }
        catch (Exception var14_22) {
            // empty catch block
        }
        return var11_15;
        catch (IOException var8_10) {
            try {
                this.setReplicaInvalid();
                throw new EmbeddedLDAPException("Unable to open initial replica url: " + var3_3, var8_10);
            }
            catch (Throwable var12_24) {
                var13_19 = null;
                try {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var7_8 != null) {
                        var7_8.disconnect();
                    }
                }
                catch (Exception var14_23) {}
                throw var12_24;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialReplicaFile(String string) {
        boolean bl = false;
        try {
            boolean bl2;
            if (this.debugEnabled) {
                log.debug("Loading initial replica file " + string);
            }
            if (!(bl2 = new LDIF().importLDIF(string, null, true))) {
                EmbeddedLDAPLogger.logReloadInitReplicaFile();
                boolean bl3 = new LDIF().importLDIF(string, null, true);
                if (!bl3) {
                    throw new EmbeddedLDAPException(EmbeddedLDAPLogger.getErrLoadInitReplicaFile());
                }
                EmbeddedLDAPLogger.logSuccessReloadInitReplicaFile();
            }
            bl = true;
            Object var6_5 = null;
            if (!bl) {
                this.setReplicaInvalid();
                this.cleanupDataDirectory(true);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!bl) {
                this.setReplicaInvalid();
                this.cleanupDataDirectory(true);
            }
            throw throwable;
        }
    }

    private void cleanupDataDirectory(boolean bl) {
        File file = new File(EmbeddedLDAP.getEmbeddedLDAPDir(), VDE_DATA_DIR);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.delete()) continue;
            file2.deleteOnExit();
            EmbeddedLDAPLogger.logCouldNotDeleteOnCleanup((String)file2.getAbsolutePath(), (String)file.getAbsolutePath());
        }
        if (bl && !file.delete()) {
            file.deleteOnExit();
            EmbeddedLDAPLogger.logCouldNotDeleteOnCleanup((String)file.getAbsolutePath(), (String)file.getAbsolutePath());
        }
    }

    private URI findLdapURI(ServerMBean serverMBean) throws URISyntaxException {
        if (serverMBean.getName().equals(this.serverMBean.getName())) {
            return new URI(EmbeddedLDAP.findLocalLdapURL());
        }
        ServerIdentity serverIdentity = ServerIdentityManager.findServerIdentity((String)EmbeddedLDAP.getEmbeddedLDAPDomain(), (String)serverMBean.getName());
        if (serverIdentity == null) {
            throw new URISyntaxException("<null>", "Unknown host");
        }
        String string = EmbeddedLDAP.findLdapURL(serverIdentity);
        if (string == null) {
            throw new URISyntaxException("<null>", "Null url");
        }
        return new URI(string);
    }

    private static String findLocalLdapURL() {
        return EmbeddedLDAP.findLdapURL(LocalServerIdentity.getIdentity());
    }

    public static String findLdapURL(ServerIdentity serverIdentity) {
        ServerChannel serverChannel = ServerChannelManager.findServerChannel((HostID)serverIdentity, (Protocol)ProtocolHandlerAdmin.PROTOCOL_ADMIN);
        String string = null;
        if (serverChannel == null || !serverChannel.supportsTLS()) {
            string = URLManager.findURL(serverIdentity, ProtocolHandlerLDAP.PROTOCOL_LDAP);
        }
        if (string == null) {
            string = URLManager.findURL(serverIdentity, ProtocolHandlerLDAPS.PROTOCOL_LDAPS);
        }
        return string;
    }

    private void writeReplicaProps() {
        File file = new File(EmbeddedLDAP.getEmbeddedLDAPDir() + File.separator + VDE_CONF_DIR + File.separator + VDE_REPLICAS_NAME);
        try {
            this.replicaProps.save(new FileOutputStream(file), "Generated property file");
        }
        catch (Exception exception) {
            EmbeddedLDAPLogger.logErrorWritingReplicasFile((String)file.getAbsolutePath(), (String)exception.toString());
        }
    }

    private static void debugLogProperties(String string, Properties properties) {
        log.debug("Logging properties for " + string);
        for (String string2 : properties.keySet()) {
            log.debug("Property " + string2 + "=" + properties.getProperty(string2));
        }
    }

    private static void debugWriteProperties(String string, Properties properties) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string, true));
            printWriter.println("# Adding properties set at runtime");
            for (String string2 : properties.keySet()) {
                printWriter.println(string2 + "=" + properties.getProperty(string2));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            log.debug("Got I/O error writing override props", iOException);
        }
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    static {
        isDBMSOnly = false;
        lockFile = null;
        KERNELID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        confFiles = new String[]{VDE_SCHEMA_FILENAME, VDE_BACKENDTYPES_FILENAME, VDE_BACKEND_FILENAME, VDE_ACL_FILENAME};
    }

    private static final class EncryptionHelperImpl
    implements EncryptionHelper {
        private ClearOrEncryptedService encrypter;

        public EncryptionHelperImpl(ClearOrEncryptedService clearOrEncryptedService) {
            this.encrypter = clearOrEncryptedService;
        }

        public String encrypt(String string) {
            return this.encrypter.encrypt(string);
        }

        public String decrypt(String string) {
            return this.encrypter.decrypt(string);
        }

        public boolean isEncrypted(String string) {
            return this.encrypter.isEncrypted(string);
        }
    }

    private static class EmbeddedLDAPTimedActivity
    implements TimerListener {
        BackendStandard backend;

        EmbeddedLDAPTimedActivity(BackendStandard backendStandard) {
            this.backend = backendStandard;
        }

        public void timerExpired(Timer timer) {
            TimedActivityThread.getInstance().runOnDemand();
            Logger.getInstance().flush();
            if (this.backend != null) {
                this.backend.cleanupPools();
            }
            TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, 60000L);
        }
    }
}

