/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ldap;

import com.asn1c.core.Int8;
import com.octetstring.ldapv3.Filter;
import com.octetstring.vde.Attribute;
import com.octetstring.vde.Credentials;
import com.octetstring.vde.Entry;
import com.octetstring.vde.EntryChange;
import com.octetstring.vde.EntrySet;
import com.octetstring.vde.backend.BackendHandler;
import com.octetstring.vde.operation.LDAPResult;
import com.octetstring.vde.schema.AttributeType;
import com.octetstring.vde.schema.SchemaChecker;
import com.octetstring.vde.syntax.BinarySyntax;
import com.octetstring.vde.syntax.DirectoryString;
import com.octetstring.vde.syntax.Syntax;
import com.octetstring.vde.util.DNUtility;
import com.octetstring.vde.util.DirectoryException;
import com.octetstring.vde.util.DirectorySchemaViolation;
import com.octetstring.vde.util.InvalidDNException;
import com.octetstring.vde.util.ParseFilter;
import com.octetstring.vde.util.PasswordEncryptor;
import com.octetstring.vde.util.ServerConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;
import weblogic.ldap.EmbeddedLDAP;
import weblogic.ldap.EmbeddedLDAPLogger;
import weblogic.ldap.EmbeddedLDAPSearchResult;
import weblogic.ldap.EmbeddedLDAPSearchResults;
import weblogic.logging.LogOutputStream;
import weblogic.management.provider.ManagementService;
import weblogic.security.SSL.CertPathTrustManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.SSLContextManager;

public class EmbeddedLDAPConnection
extends LDAPConnection {
    private static final long serialVersionUID = -932303772832631138L;
    Credentials creds = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static LDAPSocketFactory embeddedLDAPSocketFactoryUseCertPathValidators = new EmbeddedLDAPSocketFactory(false);
    private static LDAPSocketFactory embeddedLDAPSocketFactoryIgnoreCertPathValidators = new EmbeddedLDAPSocketFactory(true);
    private boolean inMasterServer = false;
    private boolean useMasterFirst = false;
    private boolean writeFailover = true;
    private LDAPCache cache = null;
    private LDAPSearchConstraints defaultConstraints = new LDAPSearchConstraints();
    private LDAPConnection delegate = null;
    private String savedHost = null;
    private int savedPort = -1;
    private String savedDN = null;
    private String savedPasswd = null;
    private int protocolVersion = 2;
    private boolean useSSL = false;
    private boolean ignoreCertPathValidators = false;
    private String masterHost = null;
    private int masterPort = -1;
    private static final LogOutputStream log = new LogOutputStream("EmbeddedLDAP");
    private boolean debugEnabled;
    private static final DirectoryString EMPTY_DIRSTRING = new DirectoryString("");
    private static final DirectoryString USERPASSWORD = new DirectoryString("userPassword");
    private boolean msiMode = false;
    private final String MSI_NO_WRITE_FAILOVER = "Admin server unavailable and write failover is not enabled.";
    private final boolean MSI_LOCAL_LDAP_ONLY = Boolean.valueOf(System.getProperty("weblogic.security.MSILocalLDAPOnly", "false"));

    public EmbeddedLDAPConnection(boolean bl) {
        this(bl, true);
    }

    public EmbeddedLDAPConnection(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public EmbeddedLDAPConnection(boolean bl, boolean bl2, boolean bl3) {
        this.debugEnabled = EmbeddedLDAP.getEmbeddedLDAP().isDebugEnabled();
        this.useSSL = EmbeddedLDAP.getEmbeddedLDAPUseSSL();
        this.useMasterFirst = bl;
        this.writeFailover = bl2;
        this.ignoreCertPathValidators = bl3;
        this.inMasterServer = ManagementService.getRuntimeAccess(kernelId).isAdminServer();
        if (this.debugEnabled) {
            log.debug("Initialize local ldap connection ");
        }
        if (EmbeddedLDAP.getEmbeddedLDAP().isMasterFirst()) {
            this.useMasterFirst = true;
        }
        if (!this.inMasterServer) {
            this.masterHost = EmbeddedLDAP.getEmbeddedLDAPHost();
            this.masterPort = EmbeddedLDAP.getEmbeddedLDAPPort();
        }
        if (this.MSI_LOCAL_LDAP_ONLY) {
            boolean bl4 = this.msiMode = !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable();
            if (this.useMasterFirst && !this.inMasterServer && !this.msiMode) {
                this.delegate = this.getDelegate();
            }
        } else if (this.useMasterFirst && !this.inMasterServer) {
            this.delegate = this.getDelegate();
        }
        this.creds = new Credentials();
        this.creds.setUser(EMPTY_DIRSTRING);
    }

    public void finalize() throws LDAPException {
    }

    public void setCache(LDAPCache lDAPCache) {
        if (this.delegate != null) {
            this.delegate.setCache(lDAPCache);
            return;
        }
        this.cache = lDAPCache;
    }

    public LDAPCache getCache() {
        if (this.delegate != null) {
            return this.delegate.getCache();
        }
        return this.cache;
    }

    public Object getProperty(String string) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public void setProperty(String string, Object object) throws LDAPException {
        if (this.delegate != null) {
            try {
                this.delegate.setProperty(string, object);
                return;
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        if (this.debugEnabled) {
            log.debug("Setting property " + string + " to " + object);
        }
    }

    public String getHost() {
        return this.savedHost;
    }

    public int getPort() {
        return this.savedPort;
    }

    public String getAuthenticationDN() {
        return null;
    }

    public String getAuthenticationPassword() {
        return null;
    }

    public int getConnectTimeout() {
        return 0;
    }

    public void setConnectTimeout(int n) {
    }

    public int getConnSetupDelay() {
        return 0;
    }

    public void setConnSetupDelay(int n) {
    }

    public LDAPSocketFactory getSocketFactory() {
        return null;
    }

    public void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
    }

    public boolean isConnected() {
        if (this.delegate != null) {
            return this.delegate.isConnected();
        }
        return true;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void connect(String string, int n) throws LDAPException {
        this.savedHost = string;
        this.savedPort = n;
        if (this.delegate != null) {
            try {
                this.connect(this.delegate, string, n);
                return;
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
    }

    public void connect(String string, int n, String string2, String string3) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void connect(String string, int n, String string2, String string3, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void connect(String string, int n, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void connect(int n, String string, int n2, String string2, String string3) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        if (this.delegate != null) {
            try {
                this.delegate.abandon(lDAPSearchResults);
                return;
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        if (lDAPSearchResults == null) {
            return;
        }
    }

    public void authenticate(String string, String string2) throws LDAPException {
        this.bind(this.protocolVersion, string, string2);
    }

    public void authenticate(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(int n, String string, String string2) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(int n, String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(String string, Hashtable hashtable, Object object) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(String string, String[] stringArray, Hashtable hashtable, Object object) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(String string, String string2, String string3, Hashtable hashtable, Object object) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void authenticate(String string, String[] stringArray, String string2, Hashtable hashtable, Object object) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public LDAPResponseListener authenticate(int n, String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener authenticate(int n, String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public void bind(String string, String string2) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void bind(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void bind(int n, String string, String string2) throws LDAPException {
        this.savedDN = string;
        this.savedPasswd = string2;
        if (this.delegate != null) {
            try {
                this.delegate.bind(n, string, string2);
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        if (this.debugEnabled) {
            log.debug("bind (version = " + n + ", dn = " + string + ")");
        }
        DirectoryString directoryString = null;
        directoryString = string != null ? new DirectoryString(string) : EMPTY_DIRSTRING;
        if (directoryString.equals(EMPTY_DIRSTRING)) {
            if (EmbeddedLDAP.getEmbeddedLDAP().getEmbeddedLDAPMBean().isAnonymousBindAllowed()) {
                return;
            }
            if (this.debugEnabled) {
                log.debug("Anonymous user, but anonymous bind is not allowed");
            }
            throw new LDAPException("error result", LDAPResult.INVALID_CREDENTIALS.intValue());
        }
        if (string2 == null || string2.equals("")) {
            this.creds.setUser(EMPTY_DIRSTRING);
            if (EmbeddedLDAP.getEmbeddedLDAP().getEmbeddedLDAPMBean().isAnonymousBindAllowed()) {
                if (this.debugEnabled) {
                    log.debug("binding as anonymous user");
                }
                return;
            }
            if (this.debugEnabled) {
                log.debug("binding as anonymous user is not allowed");
            }
            throw new LDAPException("error result", LDAPResult.INVALID_CREDENTIALS.intValue());
        }
        if (new DirectoryString((String)ServerConfig.getInstance().get("vde.rootuser")).equals(directoryString)) {
            if (PasswordEncryptor.compare(string2, (String)ServerConfig.getInstance().get("vde.rootpw"))) {
                this.creds.setUser(directoryString);
                this.creds.setRoot(true);
                if (this.debugEnabled) {
                    log.debug("binding as root user: " + directoryString);
                }
                return;
            }
            if (this.debugEnabled) {
                log.debug("Invalid password for root user: " + directoryString);
            }
            throw new LDAPException("error result", LDAPResult.INVALID_CREDENTIALS.intValue());
        }
        if (BackendHandler.getInstance().doBind(directoryString)) {
            boolean bl = BackendHandler.getInstance().bind(directoryString, new BinarySyntax(string2.getBytes()));
            if (bl) {
                this.creds = new Credentials();
                this.creds.setUser(directoryString);
                if (this.debugEnabled) {
                    log.debug("binding as user: " + directoryString);
                }
            } else {
                if (this.debugEnabled) {
                    log.debug("Invalid password for user " + directoryString);
                }
                throw new LDAPException("error result", LDAPResult.INVALID_CREDENTIALS.intValue());
            }
            return;
        }
        Entry entry = null;
        try {
            entry = BackendHandler.getInstance().getByDN(null, directoryString);
            entry = BackendHandler.getInstance().map(entry);
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        if (entry == null || !entry.containsKey(USERPASSWORD)) {
            if (this.debugEnabled) {
                log.debug("Invalid password for user: " + directoryString);
            }
            throw new LDAPException("error result", LDAPResult.INVALID_CREDENTIALS.intValue());
        }
        String string3 = new String(((Syntax)entry.get(USERPASSWORD).elementAt(0)).getValue());
        if (PasswordEncryptor.compare(string2, string3)) {
            if (this.debugEnabled) {
                log.debug("Binding as user: " + directoryString);
            }
        } else {
            if (this.debugEnabled) {
                log.debug("Invalid password for user: " + directoryString);
            }
            throw new LDAPException("error result", LDAPResult.INVALID_CREDENTIALS.intValue());
        }
        this.creds.setUser(directoryString);
    }

    public void bind(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void bind(String string, Hashtable hashtable, Object object) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void bind(String string, String[] stringArray, Hashtable hashtable, Object object) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public String getAuthenticationMethod() {
        return null;
    }

    public void reconnect() throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public synchronized void disconnect() throws LDAPException {
        if (this.delegate != null) {
            try {
                this.delegate.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
    }

    public LDAPEntry read(String string) throws LDAPException {
        if (this.useMasterFirst && this.delegate != null) {
            try {
                return this.delegate.read(string);
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        if (this.debugEnabled) {
            log.debug("read (" + string + ")");
        }
        return this.read(string, null, this.defaultConstraints);
    }

    public LDAPEntry read(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        if (this.useMasterFirst && this.delegate != null) {
            try {
                return this.delegate.read(string, stringArray);
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        if (this.debugEnabled) {
            log.debug("read (" + string + "," + stringArray + ")");
        }
        return this.read(string, stringArray, this.defaultConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults;
        if (this.useMasterFirst && this.delegate != null) {
            try {
                return this.delegate.read(string, stringArray, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        if (this.debugEnabled) {
            log.debug("read (" + string + "," + stringArray + "," + lDAPSearchConstraints + ")");
        }
        if ((lDAPSearchResults = this.search(string, 0, "(|(objectclass=*)(objectclass=ldapsubentry))", stringArray, false, lDAPSearchConstraints)) == null) {
            return null;
        }
        return lDAPSearchResults.next();
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        this.defaultConstraints.setMaxResults(0);
        return this.search(string, n, string2, stringArray, bl, this.defaultConstraints);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        Serializable serializable;
        if (this.useMasterFirst && this.delegate != null) {
            try {
                return this.delegate.search(string, n, string2, stringArray, bl, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                this.determineFailover(lDAPException);
            }
        }
        int n2 = 0;
        int n3 = 0;
        DirectoryString directoryString = null;
        Vector vector = null;
        EntrySet entrySet = null;
        if (this.debugEnabled) {
            log.debug("search (base=" + string + ", scope=" + n + ", searchFilter=" + ", attrs=" + stringArray + ", attrsOnly=" + bl + ", cons=" + lDAPSearchConstraints);
        }
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.defaultConstraints;
        }
        EmbeddedLDAPSearchResults embeddedLDAPSearchResults = new EmbeddedLDAPSearchResults();
        Filter filter = null;
        try {
            directoryString = DNUtility.getInstance().normalize(new DirectoryString(string));
            if (this.debugEnabled) {
                log.debug("search normalized base = " + directoryString);
            }
            filter = ParseFilter.parse(string2);
        }
        catch (InvalidDNException invalidDNException) {
            throw new LDAPException("error result", invalidDNException.getLDAPErrorCode(), invalidDNException.getMessage());
        }
        catch (DirectoryException directoryException) {
            throw new LDAPException("error result", directoryException.getLDAPErrorCode(), directoryException.getMessage());
        }
        boolean bl2 = bl;
        Vector<DirectoryString> vector2 = new Vector<DirectoryString>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (this.debugEnabled) {
                log.debug("search attr " + i + " = " + stringArray[i]);
            }
            serializable = new DirectoryString(stringArray[i]);
            vector2.addElement((DirectoryString)serializable);
        }
        n3 = lDAPSearchConstraints.getMaxResults();
        if (this.debugEnabled) {
            log.debug("search search limit = " + n3);
        }
        try {
            if (this.creds == null) {
                this.creds = new Credentials();
            }
            vector = BackendHandler.getInstance().get(this.creds.getUser(), directoryString, n, filter, bl2, vector2);
        }
        catch (DirectoryException directoryException) {
            throw new LDAPException("error result", directoryException.getLDAPErrorCode(), directoryException.getMessage());
        }
        Enumeration enumeration = vector.elements();
        if (enumeration.hasMoreElements()) {
            entrySet = (EntrySet)enumeration.nextElement();
        }
        while (true) {
            if (entrySet == null || !entrySet.hasMore() && !enumeration.hasMoreElements()) {
                if (this.debugEnabled) {
                    log.debug("search returning " + (Object)((Object)embeddedLDAPSearchResults));
                }
                return embeddedLDAPSearchResults;
            }
            if (n3 != 0 && n2 >= n3) {
                if (this.debugEnabled) {
                    log.debug("search exceeded limit of " + n3 + ", num entries = " + n2);
                }
                return embeddedLDAPSearchResults;
            }
            if (!entrySet.hasMore()) {
                entrySet = (EntrySet)enumeration.nextElement();
            }
            serializable = null;
            try {
                serializable = entrySet.getNext();
            }
            catch (DirectoryException directoryException) {
                throw new LDAPException("error result", directoryException.getLDAPErrorCode());
            }
            if (serializable == null || (serializable = BackendHandler.getInstance().postSearch(this.creds, (Entry)serializable, vector2, filter, n, directoryString)) == null) continue;
            ++n2;
            LDAPAttributeSet lDAPAttributeSet = this.attributeSetFromEntry((Entry)serializable, bl2, vector2);
            LDAPEntry lDAPEntry = new LDAPEntry(((Entry)serializable).getName().getDirectoryString(), lDAPAttributeSet);
            if (this.debugEnabled) {
                log.debug("search adding entry " + ((Entry)serializable).getName());
            }
            embeddedLDAPSearchResults.add(new EmbeddedLDAPSearchResult(lDAPEntry));
        }
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return false;
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return false;
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return false;
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        LDAPException lDAPException = null;
        if (this.MSI_LOCAL_LDAP_ONLY) {
            if (this.msiMode) {
                boolean bl = this.msiMode = !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable();
            }
            if (this.msiMode && !this.writeFailover) {
                throw new LDAPException("Admin server unavailable and write failover is not enabled.");
            }
            if (!this.inMasterServer && this.delegate == null && !this.msiMode) {
                try {
                    this.delegate = this.getAndInitDelegate();
                }
                catch (LDAPException lDAPException2) {
                    this.determineWriteFailover(lDAPException2);
                }
            }
        } else if (!this.inMasterServer && this.delegate == null) {
            try {
                this.delegate = this.getAndInitDelegate();
            }
            catch (LDAPException lDAPException3) {
                this.determineWriteFailover(lDAPException3);
            }
        }
        Credentials credentials = this.creds;
        boolean bl = false;
        if (this.delegate != null) {
            try {
                this.delegate.add(lDAPEntry);
                bl = true;
            }
            catch (LDAPException lDAPException4) {
                if (lDAPException4.getLDAPResultCode() == 68) {
                    lDAPException = lDAPException4;
                }
                this.determineWriteFailover(lDAPException4);
            }
            credentials = new Credentials();
            credentials.setUser(new DirectoryString(this.savedDN));
            if (((String)ServerConfig.getInstance().get("vde.rootuser")).equalsIgnoreCase(this.savedDN)) {
                credentials.setRoot(true);
            }
        }
        Int8 int8 = LDAPResult.SUCCESS;
        try {
            if (this.debugEnabled) {
                log.debug("add entry " + lDAPEntry);
            }
            Entry entry = this.LDAPEntryToEntry(lDAPEntry);
            int8 = BackendHandler.getInstance().add(credentials, entry);
        }
        catch (DirectorySchemaViolation directorySchemaViolation) {
            int8 = LDAPResult.OBJECT_CLASS_VIOLATION;
            if (directorySchemaViolation.getMessage() != null) {
                throw new LDAPException("error result", int8.intValue(), directorySchemaViolation.getMessage());
            }
            throw new LDAPException("error result", int8.intValue());
        }
        catch (InvalidDNException invalidDNException) {
            int8 = LDAPResult.INVALID_DN_SYNTAX;
            if (invalidDNException.getMessage() != null) {
                throw new LDAPException("error result", int8.intValue(), invalidDNException.getMessage());
            }
            throw new LDAPException("error result", int8.intValue());
        }
        finally {
            credentials = null;
        }
        if (int8 != LDAPResult.SUCCESS) {
            if (bl && int8 == LDAPResult.ENTRY_ALREADY_EXISTS) {
                if (this.debugEnabled) {
                    log.debug("delegate success and local already exists");
                }
            } else {
                throw new LDAPException("error result", int8.intValue());
            }
        }
        if (lDAPException != null) {
            throw lDAPException;
        }
        if (this.debugEnabled) {
            log.debug("added entry successfully");
        }
    }

    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void add(LDAPEntry lDAPEntry, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, new LDAPModification[]{lDAPModification});
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet) throws LDAPException {
        if (this.MSI_LOCAL_LDAP_ONLY) {
            if (this.msiMode) {
                boolean bl = this.msiMode = !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable();
            }
            if (this.msiMode && !this.writeFailover) {
                throw new LDAPException("Admin server unavailable and write failover is not enabled.");
            }
            if (!this.inMasterServer && this.delegate == null && !this.msiMode) {
                try {
                    this.delegate = this.getAndInitDelegate();
                }
                catch (LDAPException lDAPException) {
                    this.determineWriteFailover(lDAPException);
                }
            }
        } else if (!this.inMasterServer && this.delegate == null) {
            try {
                this.delegate = this.getAndInitDelegate();
            }
            catch (LDAPException lDAPException) {
                this.determineWriteFailover(lDAPException);
            }
        }
        if (this.delegate != null) {
            try {
                this.delegate.modify(string, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                this.determineWriteFailover(lDAPException);
            }
        }
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        for (int i = 0; i < lDAPModificationSet.size(); ++i) {
            lDAPModificationArray[i] = lDAPModificationSet.elementAt(i);
        }
        this.modify(string, lDAPModificationArray);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        if (this.MSI_LOCAL_LDAP_ONLY) {
            if (this.msiMode) {
                boolean bl = this.msiMode = !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable();
            }
            if (this.msiMode && !this.writeFailover) {
                throw new LDAPException("Admin server unavailable and write failover is not enabled.");
            }
            if (!this.inMasterServer && this.delegate == null && !this.msiMode) {
                try {
                    this.delegate = this.getAndInitDelegate();
                }
                catch (LDAPException lDAPException) {
                    this.determineWriteFailover(lDAPException);
                }
            }
        } else if (!this.inMasterServer && this.delegate == null) {
            try {
                this.delegate = this.getAndInitDelegate();
            }
            catch (LDAPException lDAPException) {
                this.determineWriteFailover(lDAPException);
            }
        }
        if (this.delegate != null) {
            try {
                this.delegate.modify(string, lDAPModificationArray);
            }
            catch (LDAPException lDAPException) {
                this.determineWriteFailover(lDAPException);
            }
        }
        if (this.debugEnabled) {
            log.debug("modify entry " + string + " mods" + lDAPModificationArray);
        }
        Vector<byte[]> vector = new Vector<byte[]>();
        for (int i = 0; i < lDAPModificationArray.length; ++i) {
            Object object;
            int n = lDAPModificationArray[i].getOp();
            LDAPAttribute lDAPAttribute = lDAPModificationArray[i].getAttribute();
            DirectoryString directoryString = new DirectoryString(lDAPAttribute.getName());
            AttributeType attributeType = SchemaChecker.getInstance().getAttributeType(directoryString);
            Class clazz = null;
            clazz = attributeType != null ? attributeType.getSyntaxClass() : DirectoryString.class;
            if (this.debugEnabled) {
                log.debug("modify attribute " + lDAPAttribute.getName() + " class " + clazz);
            }
            Vector<Syntax> vector2 = new Vector<Syntax>();
            Enumeration enumeration = lDAPModificationArray[i].getAttribute().getByteValues();
            while (enumeration.hasMoreElements()) {
                object = (byte[])enumeration.nextElement();
                if (((byte[])object).length <= 0) continue;
                try {
                    Syntax syntax = (Syntax)clazz.newInstance();
                    syntax.setValue((byte[])object);
                    vector2.addElement(syntax);
                    if (!this.debugEnabled) continue;
                    log.debug("modify value " + syntax);
                }
                catch (InstantiationException instantiationException) {
                    throw new LDAPException("conversion error", LDAPResult.OTHER.intValue(), instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LDAPException("conversion error", LDAPResult.OTHER.intValue(), illegalAccessException.getMessage());
                }
            }
            object = new EntryChange(n, directoryString, vector2);
            vector.addElement((byte[])object);
        }
        DirectoryString directoryString = new DirectoryString(string);
        Credentials credentials = new Credentials();
        credentials.setUser(new DirectoryString(this.savedDN));
        if (((String)ServerConfig.getInstance().get("vde.rootuser")).equalsIgnoreCase(this.savedDN)) {
            credentials.setRoot(true);
        }
        try {
            BackendHandler.getInstance().modify(credentials, directoryString, vector);
        }
        catch (DirectoryException directoryException) {
            if (directoryException.getMessage() != null) {
                throw new LDAPException("error result", directoryException.getLDAPErrorCode(), directoryException.getMessage());
            }
            throw new LDAPException("error result", directoryException.getLDAPErrorCode());
        }
        finally {
            credentials = null;
        }
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void delete(String string) throws LDAPException {
        LDAPException lDAPException = null;
        if (this.MSI_LOCAL_LDAP_ONLY) {
            if (this.msiMode) {
                boolean bl = this.msiMode = !ManagementService.getRuntimeAccess(kernelId).isAdminServerAvailable();
            }
            if (this.msiMode && !this.writeFailover) {
                throw new LDAPException("Admin server unavailable and write failover is not enabled.");
            }
            if (!this.inMasterServer && this.delegate == null && !this.msiMode) {
                try {
                    this.delegate = this.getAndInitDelegate();
                }
                catch (LDAPException lDAPException2) {
                    this.determineWriteFailover(lDAPException2);
                }
            }
        } else if (!this.inMasterServer && this.delegate == null) {
            try {
                this.delegate = this.getAndInitDelegate();
            }
            catch (LDAPException lDAPException3) {
                this.determineWriteFailover(lDAPException3);
            }
        }
        boolean bl = false;
        if (this.delegate != null) {
            try {
                this.delegate.delete(string);
                bl = true;
            }
            catch (LDAPException lDAPException4) {
                if (lDAPException4.getLDAPResultCode() == 32) {
                    lDAPException = lDAPException4;
                }
                this.determineWriteFailover(lDAPException4);
            }
        }
        if (this.debugEnabled) {
            log.debug("delete entry " + string);
        }
        DirectoryString directoryString = new DirectoryString(string);
        Credentials credentials = new Credentials();
        credentials.setUser(new DirectoryString(this.savedDN));
        if (((String)ServerConfig.getInstance().get("vde.rootuser")).equalsIgnoreCase(this.savedDN)) {
            credentials.setRoot(true);
        }
        Int8 int8 = BackendHandler.getInstance().delete(credentials, directoryString);
        credentials = null;
        if (int8 != LDAPResult.SUCCESS) {
            if (bl && int8 == LDAPResult.NO_SUCH_OBJECT) {
                if (this.debugEnabled) {
                    log.debug("delegate success and local no such object");
                }
            } else {
                throw new LDAPException("error result", int8.intValue());
            }
        }
        if (lDAPException != null) {
            throw lDAPException;
        }
    }

    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void delete(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void rename(String string, String string2, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public LDAPResponseListener add(LDAPEntry lDAPEntry, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener add(LDAPEntry lDAPEntry, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener bind(int n, String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener bind(String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener bind(String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener bind(int n, String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener delete(String string, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener delete(String string, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener modify(String string, LDAPModification lDAPModification, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener modify(String string, LDAPModification lDAPModification, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener modify(String string, LDAPModificationSet lDAPModificationSet, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener modify(String string, LDAPModificationSet lDAPModificationSet, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener rename(String string, String string2, boolean bl, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener rename(String string, String string2, boolean bl, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPSearchListener search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchListener lDAPSearchListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPSearchListener search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchListener lDAPSearchListener, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public LDAPResponseListener compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public void abandon(int n) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public void abandon(LDAPSearchListener lDAPSearchListener) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
    }

    public Object getOption(int n) throws LDAPException {
        EmbeddedLDAPConnection.throwUnsupported();
        return null;
    }

    public void setOption(int n, Object object) throws LDAPException {
    }

    public LDAPControl[] getResponseControls() {
        return null;
    }

    public LDAPConstraints getConstraints() {
        return null;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return null;
    }

    public void setConstraints(LDAPConstraints lDAPConstraints) {
    }

    public void setSearchConstraints(LDAPSearchConstraints lDAPSearchConstraints) {
    }

    public InputStream getInputStream() {
        return null;
    }

    public void setInputStream(InputStream inputStream) {
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public void setOutputStream(OutputStream outputStream) {
    }

    public synchronized Object clone() {
        return null;
    }

    public static boolean isNetscape() {
        return false;
    }

    private LDAPAttributeSet attributeSetFromEntry(Entry entry, boolean bl, Vector vector) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        Attribute attribute = null;
        Object var6_6 = null;
        Syntax syntax = null;
        Vector vector2 = entry.getAttributes();
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            attribute = (Attribute)vector2.elementAt(i);
            LDAPAttribute lDAPAttribute = null;
            if (!bl) {
                lDAPAttribute = new LDAPAttribute(attribute.type.getDirectoryString());
                int n2 = attribute.values.size();
                for (int j = 0; j < n2; ++j) {
                    syntax = (Syntax)attribute.values.elementAt(j);
                    if (syntax == null) continue;
                    lDAPAttribute.addValue(syntax.getValue());
                }
            } else {
                lDAPAttribute = new LDAPAttribute(attribute.type.getDirectoryString());
            }
            lDAPAttributeSet.add(lDAPAttribute);
        }
        return lDAPAttributeSet;
    }

    private Entry LDAPEntryToEntry(LDAPEntry lDAPEntry) throws InvalidDNException {
        Entry entry = new Entry(new DirectoryString(lDAPEntry.getDN()));
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            if (lDAPAttribute.getName() == null) continue;
            DirectoryString directoryString = new DirectoryString(lDAPAttribute.getName());
            AttributeType attributeType = SchemaChecker.getInstance().getAttributeType(directoryString);
            Class clazz = null;
            clazz = attributeType != null ? attributeType.getSyntaxClass() : DirectoryString.class;
            Vector<Syntax> vector = new Vector<Syntax>();
            Enumeration enumeration2 = lDAPAttribute.getByteValues();
            while (enumeration2.hasMoreElements()) {
                byte[] byArray = (byte[])enumeration2.nextElement();
                if (byArray.length <= 0) continue;
                try {
                    Syntax syntax = (Syntax)clazz.newInstance();
                    syntax.setValue(byArray);
                    vector.addElement(syntax);
                }
                catch (InstantiationException instantiationException) {
                    EmbeddedLDAPLogger.logStackTrace((Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    EmbeddedLDAPLogger.logStackTrace((Throwable)illegalAccessException);
                }
            }
            if (vector.size() <= 0) continue;
            entry.put(directoryString, vector, false);
        }
        return entry;
    }

    private LDAPConnection getDelegate() {
        LDAPConnection lDAPConnection;
        block7: {
            int n;
            Object object;
            lDAPConnection = null;
            if (this.debugEnabled) {
                log.debug("Creating LDAP Connection delegate, useSSL is " + this.useSSL);
            }
            if (this.useSSL) {
                object = this.ignoreCertPathValidators ? embeddedLDAPSocketFactoryIgnoreCertPathValidators : embeddedLDAPSocketFactoryUseCertPathValidators;
                lDAPConnection = new LDAPConnection((LDAPSocketFactory)object);
            } else {
                lDAPConnection = new LDAPConnection();
            }
            object = Integer.getInteger("weblogic.security.embeddedLDAPConnectTimeout");
            if (null != object) {
                lDAPConnection.setConnectTimeout(((Integer)object).intValue());
            }
            if ((n = EmbeddedLDAP.getEmbeddedLDAP().getTimeout()) > 0) {
                Integer n2 = new Integer(n * 1000);
                try {
                    lDAPConnection.setOption(4, (Object)n2);
                }
                catch (LDAPException lDAPException) {
                    if (!this.debugEnabled) break block7;
                    log.debug("Error setting timeout " + (Object)((Object)lDAPException));
                }
            }
        }
        return lDAPConnection;
    }

    private LDAPConnection getAndInitDelegate() throws LDAPException {
        LDAPConnection lDAPConnection = this.getDelegate();
        if (this.debugEnabled) {
            log.debug("Initializing LDAP Connection delegate");
        }
        if (this.masterHost != null) {
            if (this.debugEnabled) {
                log.debug("Connecting write delegate to " + this.masterHost + ":" + this.masterPort);
            }
            this.connect(lDAPConnection, this.masterHost, this.masterPort);
        }
        if (this.savedDN != null) {
            if (this.debugEnabled) {
                log.debug("Binding delegate to " + this.savedDN);
            }
            lDAPConnection.bind(this.protocolVersion, this.savedDN, this.savedPasswd);
        }
        return lDAPConnection;
    }

    private static void throwUnsupported() throws LDAPException {
        Thread.dumpStack();
        throw new LDAPException("EmbeddedLDAPConnection does not support this method", 92);
    }

    private void determineFailover(LDAPException lDAPException) throws LDAPException {
        boolean bl = true;
        switch (lDAPException.getLDAPResultCode()) {
            case 3: 
            case 11: 
            case 51: 
            case 52: 
            case 80: 
            case 81: 
            case 85: 
            case 91: {
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            if (this.debugEnabled) {
                log.debug("Failing over to local replicated server");
            }
            try {
                this.delegate.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            throw lDAPException;
        }
        this.delegate = null;
        this.bind(this.protocolVersion, this.savedDN, this.savedPasswd);
    }

    private void determineWriteFailover(LDAPException lDAPException) throws LDAPException {
        if (!this.writeFailover) {
            throw lDAPException;
        }
        this.determineFailover(lDAPException);
        EmbeddedLDAP.getEmbeddedLDAP().setReplicaInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(LDAPConnection lDAPConnection, String string, int n) throws LDAPException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(EmbeddedLDAPConnection.class.getClassLoader());
        try {
            lDAPConnection.connect(string, n);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static class EmbeddedLDAPSocketFactory
    implements LDAPSocketFactory {
        private boolean ignoreCertPathValidators = false;
        private SSLSocketFactory socketFactory = null;

        private EmbeddedLDAPSocketFactory(boolean bl) {
            this.ignoreCertPathValidators = bl;
        }

        public Socket makeSocket(String string, int n) throws LDAPException {
            try {
                SSLSocket sSLSocket = (SSLSocket)this.getFactory().createSocket(string, n);
                sSLSocket.startHandshake();
                return sSLSocket;
            }
            catch (Exception exception) {
                LDAPException lDAPException = new LDAPException(exception.getMessage(), 91);
                lDAPException.initCause((Throwable)exception);
                throw lDAPException;
            }
        }

        private synchronized SSLSocketFactory getFactory() throws Exception {
            if (this.socketFactory == null) {
                if (this.ignoreCertPathValidators) {
                    CertPathTrustManager certPathTrustManager = new CertPathTrustManager();
                    certPathTrustManager.setBuiltinSSLValidationOnly();
                    this.socketFactory = SSLContextManager.getSSLSocketFactory(kernelId, certPathTrustManager);
                } else {
                    this.socketFactory = SSLContextManager.getDefaultSSLSocketFactory(kernelId);
                }
            }
            return this.socketFactory;
        }
    }
}

