/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ldap;

import javax.management.InvalidAttributeValueException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.EmbeddedLDAPMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;
import weblogic.security.Salt;
import weblogic.utils.Hex;

public class EmbeddedLDAPPersistentCompletionProcessor
implements ConfigurationProcessor {
    private static final int CRED_LEN = 13;
    private static String credential = null;

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        EmbeddedLDAPMBean embeddedLDAPMBean = domainMBean.getEmbeddedLDAP();
        if (embeddedLDAPMBean == null) {
            throw new AssertionError((Object)"null embedded ldap mbean");
        }
        if (embeddedLDAPMBean.getCredential() != null) {
            return;
        }
        if (credential == null) {
            byte[] byArray = Salt.getRandomBytes(13);
            credential = Hex.asHex((byte[])byArray);
        }
        try {
            embeddedLDAPMBean.setCredential(credential);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UpdateException(invalidAttributeValueException);
        }
    }
}

