/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ldap;

import com.octetstring.vde.ConnectionHandler;
import com.octetstring.vde.LDAPServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import weblogic.ldap.EmbeddedLDAP;
import weblogic.ldap.ProtocolHandlerLDAP;
import weblogic.protocol.ServerChannel;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.SocketMuxer;
import weblogic.socket.WeblogicSocket;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;

class MuxableSocketLDAP
extends AbstractMuxableSocket {
    private static LDAPServer ldapServer;
    private final ConnectionHandler connectionHandler;

    MuxableSocketLDAP(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
        LDAPSocket lDAPSocket = new LDAPSocket(this.getSocket(), this);
        this.connectionHandler = ldapServer.createConnectionHandler(lDAPSocket);
        this.connectionHandler.setExternalExecutor(EmbeddedLDAP.getEmbeddedLDAP());
    }

    static void initialize(LDAPServer lDAPServer) {
        ProtocolHandlerLDAP.getProtocolHandler();
        ldapServer = lDAPServer;
    }

    protected int getHeaderLength() {
        return 2;
    }

    protected int getMessageLength() {
        byte by = this.getHeaderByte(1);
        if ((by & 0x80) == 0) {
            return 2 + (by & 0x7F);
        }
        int n = 2 + (by & 0x7F);
        if (this.availBytes < n) {
            return -1;
        }
        int n2 = 0;
        for (int i = 2; i < n; ++i) {
            n2 <<= 8;
            n2 += this.getHeaderByte(i) & 0xFF;
        }
        return n2 + n;
    }

    public void dispatch(Chunk chunk) {
        try {
            ChunkedInputStream chunkedInputStream = new ChunkedInputStream(chunk, 0);
            if (!this.connectionHandler.dispatch((InputStream)chunkedInputStream)) {
                this.close();
                return;
            }
        }
        catch (Throwable throwable) {
            SocketMuxer.getMuxer().deliverHasException(this.getSocketFilter(), throwable);
            this.close();
        }
    }

    public int getIdleTimeoutMillis() {
        return 0;
    }

    public class LDAPSocket
    extends WeblogicSocket {
        private MuxableSocketLDAP muxableSocketLDAP;

        LDAPSocket(Socket socket, MuxableSocketLDAP muxableSocketLDAP2) {
            super(socket);
            this.muxableSocketLDAP = muxableSocketLDAP2;
        }

        public final void close() throws IOException {
            if (this.muxableSocketLDAP.getSocketInfo() == null && this.muxableSocketLDAP.getSocketFilter().getSocketInfo() == null) {
                super.close();
                this.muxableSocketLDAP.endOfStream();
            } else {
                SocketMuxer.getMuxer().deliverEndOfStream(this.muxableSocketLDAP);
            }
        }
    }
}

