/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ldap;

import java.io.IOException;
import java.net.Socket;
import weblogic.ldap.MuxableSocketLDAP;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.socket.MuxableSocket;
import weblogic.utils.io.Chunk;

class ProtocolHandlerLDAP
implements ProtocolHandler {
    private static ProtocolHandler theOne = new ProtocolHandlerLDAP();
    private static final String PROTOCOL_NAME = "LDAP";
    public static final Protocol PROTOCOL_LDAP = ProtocolManager.createProtocol((byte)10, (String)"ldap", (String)"ldap", (boolean)false, (ProtocolHandler)ProtocolHandlerLDAP.getProtocolHandler());
    private static final byte ASN1_SEQUENCE_DEFINITE_LENGTH = 48;
    private static final byte BER_ENCODED_INTEGER = 2;
    private static final byte BER_ENCODED_APPLICATION_0 = 96;
    private static final int DISCRIMINATION_LENGTH = 11;

    ProtocolHandlerLDAP() {
    }

    public static ProtocolHandler getProtocolHandler() {
        return theOne;
    }

    public ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.CHANNEL;
    }

    public int getHeaderLength() {
        return 11;
    }

    public int getPriority() {
        return 2;
    }

    public Protocol getProtocol() {
        return PROTOCOL_LDAP;
    }

    public boolean claimSocket(Chunk chunk) {
        int n;
        if (chunk.end < 11) {
            return false;
        }
        byte[] byArray = chunk.buf;
        int n2 = 0;
        if (byArray[n2++] != 48) {
            return false;
        }
        int n3 = 0;
        if ((byArray[n2] & 0x80) == 0) {
            n3 = byArray[n2++] & 0x7F;
        } else {
            if ((n = byArray[n2++] & 0x7F) > 2) {
                return false;
            }
            n3 = byArray[n2++];
            if (n == 2) {
                n3 = (n3 << 8) + byArray[n2++];
            }
        }
        if (byArray[n2++] != 2) {
            return false;
        }
        if ((byArray[n2] & 0x80) == 128) {
            return false;
        }
        if ((n = byArray[n2++]) > 4) {
            return false;
        }
        return byArray[n2 += n] == 96;
    }

    public MuxableSocket createSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        return new MuxableSocketLDAP(chunk, socket, serverChannel);
    }

    private static final class ChannelInitializer {
        private static final ServerChannel CHANNEL = ServerChannelImpl.createDefaultServerChannel(PROTOCOL_LDAP);

        private ChannelInitializer() {
        }
    }
}

