/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.DateFormatter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import weblogic.logging.LogEntry;
import weblogic.logging.LogEntryFormatter;
import weblogic.logging.Severities;
import weblogic.logging.SeverityI18N;
import weblogic.logging.WLLogRecord;
import weblogic.logging.WLLogger;
import weblogic.management.configuration.CommonLogMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.utils.PlatformConstants;

public class ConsoleFormatter
extends Formatter
implements LogEntryFormatter {
    public static final String FIELD_PREFIX = "<";
    public static final String FIELD_SUFFIX = "> ";
    private static Pattern FIELD_PREFIX_PATTERN = Pattern.compile("<");
    private static Pattern FIELD_SUFFIX_PATTERN = Pattern.compile(">");
    private static final boolean LOG_ANALYZER = Boolean.getBoolean("logAnalyzer");
    private CommonLogMBean logMBean;
    private DateFormatter dateFormatter = DateFormatter.getDefaultInstance();

    public static String formatForConsole(CommonLogMBean commonLogMBean, LogEntry logEntry, DateFormatter dateFormatter) {
        StringBuilder stringBuilder = new StringBuilder();
        long l = logEntry.getTimestamp();
        if (LOG_ANALYZER) {
            ConsoleFormatter.appendToBuffer(stringBuilder, Long.toString(l));
        }
        logEntry.ensureFormattedDateInitialized(dateFormatter);
        String string = logEntry.getFormattedDate();
        ConsoleFormatter.appendToBuffer(stringBuilder, string);
        ConsoleFormatter.appendToBuffer(stringBuilder, SeverityI18N.severityNumToString((int)logEntry.getSeverity()));
        ConsoleFormatter.appendToBuffer(stringBuilder, logEntry.getSubsystem());
        if (commonLogMBean == null || commonLogMBean.getStdoutFormat().equals("standard")) {
            ConsoleFormatter.appendToBuffer(stringBuilder, logEntry.getId());
        }
        stringBuilder.append(FIELD_PREFIX);
        stringBuilder.append(logEntry.getLogMessage());
        if ((commonLogMBean == null || commonLogMBean.isStdoutLogStack()) && logEntry.getThrowableWrapper() != null) {
            stringBuilder.append(PlatformConstants.EOL);
            if (commonLogMBean == null || Severities.severityStringToNum((String)commonLogMBean.getStdoutSeverity()) >= 64) {
                stringBuilder.append(logEntry.getThrowableWrapper());
            } else {
                stringBuilder.append(logEntry.getThrowableWrapper().toString(commonLogMBean.getStacktraceDepth()));
            }
        }
        stringBuilder.append(FIELD_SUFFIX);
        stringBuilder.append(PlatformConstants.EOL);
        return stringBuilder.toString();
    }

    public ConsoleFormatter() {
    }

    public ConsoleFormatter(KernelMBean kernelMBean) {
        this(kernelMBean.getLog());
    }

    public ConsoleFormatter(LogMBean logMBean) {
        this((CommonLogMBean)logMBean);
    }

    public ConsoleFormatter(CommonLogMBean commonLogMBean) {
        this.logMBean = commonLogMBean;
        this.dateFormatter = new DateFormatter(commonLogMBean.getDateFormatPattern());
    }

    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String format(LogRecord logRecord) {
        WLLogRecord wLLogRecord = WLLogger.normalizeLogRecord(logRecord);
        return this.toString(wLLogRecord);
    }

    public String toString(LogEntry logEntry) {
        return ConsoleFormatter.formatForConsole(this.logMBean, logEntry, this.dateFormatter);
    }

    public static final String formatDateObject(Date date) {
        return DateFormatter.getDefaultInstance().formatDate(date);
    }

    protected static final void appendToBufferEscaped(StringBuffer stringBuffer, String string) {
        if (string != null) {
            string = FIELD_PREFIX_PATTERN.matcher(string).replaceAll("&lt;");
            string = FIELD_SUFFIX_PATTERN.matcher(string).replaceAll("&gt;");
        } else {
            string = "";
        }
        ConsoleFormatter.appendToBuffer(stringBuffer, string);
    }

    protected static final void appendToBuffer(StringBuffer stringBuffer, String string) {
        stringBuffer.append(FIELD_PREFIX);
        stringBuffer.append(string != null ? string : "");
        stringBuffer.append(FIELD_SUFFIX);
    }

    protected String formatDate(Date date) {
        return this.dateFormatter.formatDate(date);
    }

    protected void appendBuf(StringBuffer stringBuffer, String string) {
        ConsoleFormatter.appendToBuffer(stringBuffer, string);
    }

    protected static final void appendToBuffer(StringBuilder stringBuilder, String string) {
        stringBuilder.append(FIELD_PREFIX);
        stringBuilder.append(string != null ? string : "");
        stringBuilder.append(FIELD_SUFFIX);
    }

    protected static final void appendToBufferEscaped(StringBuilder stringBuilder, String string) {
        if (string != null) {
            string = FIELD_PREFIX_PATTERN.matcher(string).replaceAll("&lt;");
            string = FIELD_SUFFIX_PATTERN.matcher(string).replaceAll("&gt;");
        } else {
            string = "";
        }
        ConsoleFormatter.appendToBuffer(stringBuilder, string);
    }
}

