/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.OutputStream;
import java.util.logging.ErrorManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import weblogic.kernel.Kernel;
import weblogic.logging.Severities;
import weblogic.logging.WLErrorManager;
import weblogic.logging.WLLevel;
import weblogic.management.configuration.CommonLogMBean;
import weblogic.management.configuration.KernelMBean;
import weblogic.management.configuration.LogMBean;

public final class ConsoleHandler
extends StreamHandler {
    public ConsoleHandler(KernelMBean kernelMBean) {
        this((OutputStream)System.out, kernelMBean.getLog());
    }

    public ConsoleHandler(LogMBean logMBean) {
        this((OutputStream)System.out, logMBean);
    }

    public ConsoleHandler(CommonLogMBean commonLogMBean) {
        this((OutputStream)System.out, commonLogMBean);
    }

    ConsoleHandler(OutputStream outputStream, CommonLogMBean commonLogMBean) {
        super(outputStream, new SimpleFormatter());
        ErrorManager errorManager = this.getErrorManager();
        if (Kernel.isApplet()) {
            this.setErrorManager(errorManager);
        } else {
            this.setErrorManager(new WLErrorManager(this));
        }
        this.setLevel(WLLevel.getLevel((int)Severities.severityStringToNum((String)commonLogMBean.getStdoutSeverity())));
    }

    public synchronized void publish(LogRecord logRecord) {
        super.publish(logRecord);
        super.flush();
    }

    public void close() {
        super.flush();
    }
}

