/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jndi.Environment;
import weblogic.logging.LogEntry;
import weblogic.logging.LogMgmtLogger;
import weblogic.logging.Loggable;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.logging.DomainLogHandler;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainLogBroadcasterClient {
    private static final int MAX_BUFFER_SIZE = 100;
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDomainLogHandler");
    private static DomainLogBroadcasterClient singleton = null;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private static final int MIN_RETRY_COUNT = 1;
    private static final int MAX_RETRY_COUNT = 10;
    private static final long RETRY_SLEEP_INTERVAL = 5000L;
    private ArrayList logBuffer;
    private LogMBean logConfig;
    private DomainLogHandler domainLogHandler = null;
    private long messagesBroadcastedToDomain = 0L;
    boolean closed = false;
    private WorkManager workManager;
    private Object logBufferLock = new Object();

    public static synchronized DomainLogBroadcasterClient getInstance() {
        if (singleton == null) {
            singleton = new DomainLogBroadcasterClient();
        }
        return singleton;
    }

    private DomainLogBroadcasterClient() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer();
        this.logConfig = serverMBean.getLog();
        this.logBuffer = new ArrayList(100);
        this.workManager = WorkManagerFactory.getInstance().findOrCreate("weblogic.logging.DomainLogBroadcasterClient", 1, -1);
    }

    public void initDomainLogHandler(final boolean bl) {
        this.workManager.schedule(new Runnable(){

            public void run() {
                DomainLogBroadcasterClient.this.initDomainLogHandlerAsync(bl);
            }
        });
    }

    public DomainLogHandler getDomainLogHandler() {
        return this.domainLogHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void initDomainLogHandlerAsync(boolean bl) {
        int n = 1;
        if (bl) {
            n = 10;
        }
        if (this.domainLogHandler != null && bl) {
            try {
                this.domainLogHandler.ping();
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Ping worked, no need to lookup again");
                }
                return;
            }
            catch (RemoteException remoteException) {
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("Remote reference is bad");
                }
                this.domainLogHandler = null;
            }
        }
        Exception exception = null;
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Entering loop with retryCount=" + n);
        }
        for (int i = 0; i < n; ++i) {
            Context context = null;
            Environment environment = new Environment();
            environment.setProviderUrl(URLManager.findAdministrationURL(ManagementService.getRuntimeAccess(KERNEL_ID).getAdminServerName()));
            context = environment.getInitialContext();
            this.domainLogHandler = (DomainLogHandler)context.lookup("weblogic.logging.DomainLogHandler");
            LogMgmtLogger.logDomainLogHandlerInitialized();
            Object var9_10 = null;
            if (context == null) break;
            try {
                context.close();
            }
            catch (NamingException namingException) {}
            break;
            {
                catch (Exception exception2) {
                    block22: {
                        exception = exception2;
                        if (DEBUG.isDebugEnabled()) {
                            DEBUG.debug("Got exception while ctx lookup, retryCount=" + i, (Throwable)exception2);
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!DEBUG.isDebugEnabled()) break block22;
                            DEBUG.debug("Got exception while sleeping", (Throwable)interruptedException);
                        }
                    }
                    var9_10 = null;
                    if (context == null) continue;
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_10 = null;
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (this.domainLogHandler == null) {
            LogMgmtLogger.logCannotGetDomainLogHandler(exception);
        } else {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(LogEntry logEntry) {
        ArrayList arrayList;
        Object object = this.logBufferLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.logBuffer.add(logEntry);
            int n = this.logConfig.getDomainLogBroadcasterBufferSize();
            if (this.domainLogHandler == null) {
                n = 100;
            }
            if (this.logBuffer.size() >= n) {
                if (this.domainLogHandler != null) {
                    arrayList = this.logBuffer;
                    this.logBuffer = new ArrayList(this.logConfig.getDomainLogBroadcasterBufferSize());
                } else {
                    if (this.logBuffer.size() > n) {
                        this.logBuffer.remove(0);
                    }
                    arrayList = null;
                }
            } else {
                arrayList = null;
            }
        }
        if (arrayList != null) {
            this.scheduleLogBroadcast(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList arrayList;
        Object object = this.logBufferLock;
        synchronized (object) {
            int n = this.logBuffer.size();
            if (n == 0) {
                return;
            }
            arrayList = this.logBuffer;
            this.logBuffer = new ArrayList(this.logConfig.getDomainLogBroadcasterBufferSize());
        }
        this.scheduleLogBroadcast(arrayList);
    }

    private void scheduleLogBroadcast(final ArrayList arrayList) {
        this.workManager.schedule(new Runnable(){

            public void run() {
                block7: {
                    DomainLogHandler domainLogHandler = DomainLogBroadcasterClient.this.domainLogHandler;
                    LogEntry[] logEntryArray = new LogEntry[arrayList.size()];
                    arrayList.toArray(logEntryArray);
                    try {
                        if (domainLogHandler != null) {
                            domainLogHandler.publishLogEntries(logEntryArray);
                        }
                    }
                    catch (RemoteException remoteException) {
                        try {
                            if (domainLogHandler != null) {
                                domainLogHandler.publishLogEntries(logEntryArray);
                            }
                        }
                        catch (RemoteException remoteException2) {
                            DomainLogBroadcasterClient.this.domainLogHandler = null;
                            LogMgmtLogger.logCannotGetDomainLogHandler((Throwable)remoteException);
                            if (!DEBUG.isDebugEnabled()) break block7;
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 0; i < logEntryArray.length; ++i) {
                                stringBuilder.append('[');
                                stringBuilder.append(logEntryArray[i].getLogMessage());
                                stringBuilder.append(']');
                            }
                            DEBUG.debug("Failed to send messages to the domain: " + stringBuilder.toString(), (Throwable)remoteException);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.logBufferLock;
        synchronized (object) {
            this.closed = true;
            this.logBuffer.clear();
        }
    }

    public void sendALAlertTrap(final String string, final String string2, final String string3, final String string4, final String string5, final String string6, final String string7, final String string8, final String string9, final String string10, final String string11, final String string12) throws Exception {
        try {
            final DomainLogHandler domainLogHandler = this.domainLogHandler;
            if (domainLogHandler == null) {
                Loggable loggable = LogMgmtLogger.logDomainLogHandlerNotAvailableForTrapLoggable();
                if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug(loggable.getMessageBody());
                }
                throw new Exception(loggable.getMessageBody());
            }
            this.workManager.schedule(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            domainLogHandler.sendALAlertTrap(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12);
                        }
                        catch (RemoteException remoteException) {
                            if (!DEBUG.isDebugEnabled()) break block2;
                            DEBUG.debug("Failed to send AquaLogic Alert trap to the domain", (Throwable)remoteException);
                        }
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Failed to send AquaLogic Alert trap to the domain", (Throwable)remoteException);
            }
            throw new Exception(remoteException.getMessage());
        }
    }

    public void sendTrap(final String string, final List<Object[]> list) throws RemoteException {
        final DomainLogHandler domainLogHandler = this.domainLogHandler;
        if (domainLogHandler == null) {
            Loggable loggable = LogMgmtLogger.logDomainLogHandlerNotAvailableForTrapLoggable();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug(loggable.getMessageBody());
            }
            throw new RemoteException(loggable.getMessageBody());
        }
        this.workManager.schedule(new Runnable(){

            public void run() {
                block3: {
                    try {
                        if (DEBUG.isDebugEnabled()) {
                            DEBUG.debug("Sending trap " + string);
                        }
                        domainLogHandler.sendTrap(string, list);
                    }
                    catch (RemoteException remoteException) {
                        if (!DEBUG.isDebugEnabled()) break block3;
                        DEBUG.debug("Failed to send trap to the domain", (Throwable)remoteException);
                    }
                }
            }
        });
    }
}

