/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.LogFileConfigBean;
import com.bea.logging.RotatingFileStreamHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Handler;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.LogFileConfigUtil;
import weblogic.logging.WLErrorManager;
import weblogic.management.configuration.LogFileMBean;
import weblogic.management.configuration.LogMBean;

public final class FileStreamHandler
extends RotatingFileStreamHandler
implements BeanUpdateListener {
    private final LogFileMBean logConfig;
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugLoggingConfiguration");

    public FileStreamHandler(LogMBean logMBean) throws IOException {
        this((LogFileMBean)logMBean);
    }

    public FileStreamHandler(LogFileMBean logFileMBean) throws IOException {
        super(LogFileConfigUtil.getLogFileConfig(logFileMBean));
        this.setErrorManager(new WLErrorManager((Handler)((Object)this)));
        this.logConfig = logFileMBean;
        logFileMBean.setOutputStream((OutputStream)this.getRotatingFileOutputStream());
        logFileMBean.addBeanUpdateListener(this);
    }

    public String toString() {
        String string = this.logConfig.computeLogFilePath();
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        Object object;
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Activating update to log configuration");
        }
        if ((object = beanUpdateEvent.getSource()) instanceof LogFileMBean) {
            LogFileMBean logFileMBean = (LogFileMBean)object;
            try {
                LogFileConfigBean logFileConfigBean = LogFileConfigUtil.getLogFileConfig(logFileMBean);
                this.initialize(logFileConfigBean, true);
            }
            catch (IOException iOException) {
                throw new BeanUpdateFailedException("Failed to update log configuration for " + logFileMBean.getName(), (Throwable)iOException);
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }
}

