/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.BaseLogRecord;
import com.bea.logging.BaseLogRecordFactory;
import com.bea.logging.BaseLogger;
import com.bea.logging.BaseLoggerFactory;
import com.bea.logging.DateFormatter;
import com.bea.logging.LogBufferHandler;
import com.bea.logging.LoggingService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerRegistry;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.ConsoleHandler;
import weblogic.logging.DomainLogBroadcastHandler;
import weblogic.logging.FileStreamHandler;
import weblogic.logging.JMXBroadcastHandler;
import weblogic.logging.LogFileFormatter;
import weblogic.logging.LogFilter;
import weblogic.logging.LogMgmtLogger;
import weblogic.logging.ServerLoggingHandler;
import weblogic.logging.Severities;
import weblogic.logging.SeverityChangeListener;
import weblogic.logging.WLErrorManager;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.logging.WLLogger;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.ServerMBean;

public class JDKLoggerFactory
implements BaseLoggerFactory,
BaseLogRecordFactory,
BeanUpdateListener {
    protected static final String KERNEL_LOGGER = "com.bea.weblogic.kernel";
    protected static final String BRIDGE_LOGGER = "com.oracle.wls";
    private static final String LOG4J_ADAPTER_FACTORY = "weblogic.logging.log4j.JDKLog4jAdapterFactory";
    private static boolean log4jEnabled = false;
    public static final String DOMAIN_LOGGER = "com.bea.weblogic.domain";
    private Logger bridgeLogger;

    public static JDKLoggerFactory getJDKLoggerFactory(LogMBean logMBean) {
        boolean bl = logMBean.isLog4jLoggingEnabled();
        if (!bl) {
            return new JDKLoggerFactory();
        }
        try {
            Class<?> clazz = Class.forName(LOG4J_ADAPTER_FACTORY, true, Thread.currentThread().getContextClassLoader());
            JDKLoggerFactory jDKLoggerFactory = (JDKLoggerFactory)clazz.newInstance();
            log4jEnabled = true;
            return jDKLoggerFactory;
        }
        catch (Throwable throwable) {
            LogMgmtLogger.logErrorInitializingLog4jLogging((String)logMBean.getName(), (Throwable)throwable);
            return new JDKLoggerFactory();
        }
    }

    public static boolean isLog4jEnabled() {
        return log4jEnabled;
    }

    public BaseLogger createBaseLogger(String string) {
        WLLogger wLLogger = new WLLogger(string);
        wLLogger.setUseParentHandlers(true);
        return wLLogger;
    }

    public BaseLogRecord createBaseLogRecord(LogMessage logMessage) {
        return new WLLogRecord(logMessage);
    }

    public Logger createAndInitializeDomainLogger(LogMBean logMBean) throws IOException {
        WLLogger wLLogger = new WLLogger(DOMAIN_LOGGER, true);
        wLLogger.setLevel(WLLevel.getLevel((int)Severities.severityStringToNum((String)logMBean.getLoggerSeverity())));
        FileStreamHandler fileStreamHandler = new FileStreamHandler(logMBean);
        LogFileFormatter logFileFormatter = new LogFileFormatter();
        DateFormatter dateFormatter = new DateFormatter(logMBean.getDateFormatPattern());
        logFileFormatter.setDateFormatter(dateFormatter);
        fileStreamHandler.setFormatter(logFileFormatter);
        fileStreamHandler.setErrorManager(new WLErrorManager((Handler)((Object)fileStreamHandler)));
        wLLogger.setUseParentHandlers(false);
        wLLogger.setLevel(Level.ALL);
        wLLogger.addHandler((Handler)((Object)fileStreamHandler));
        LogMgmtLogger.logInitializedDomainLogFile((String)logMBean.computeLogFilePath());
        return wLLogger;
    }

    public Logger createAndInitializeServerLogger(ServerMBean serverMBean) {
        Object object;
        FileStreamHandler fileStreamHandler;
        LogMBean logMBean = serverMBean.getLog();
        LoggingService loggingService = LoggingService.getInstance();
        loggingService.setBaseLoggerFactory((BaseLoggerFactory)this);
        loggingService.setBaseLogRecordFactory((BaseLogRecordFactory)this);
        this.updateLoggerSeverities(serverMBean.getLog());
        serverMBean.getLog().addBeanUpdateListener(this);
        SeverityChangeListener severityChangeListener = null;
        ConsoleHandler consoleHandler = new ConsoleHandler(serverMBean.getLog());
        consoleHandler.setFormatter(new ConsoleFormatter(serverMBean.getLog()));
        DateFormatter dateFormatter = ((ConsoleFormatter)consoleHandler.getFormatter()).getDateFormatter();
        severityChangeListener = new SeverityChangeListener(logMBean, "StdoutSeverity", consoleHandler);
        severityChangeListener.setLevel(logMBean.getStdoutSeverity());
        consoleHandler.setFilter(new LogFilter(logMBean, "StdoutFilter", logMBean.getStdoutFilter()));
        Logger logger = loggingService.getLogger("");
        logger.addHandler(consoleHandler);
        try {
            fileStreamHandler = new FileStreamHandler(logMBean);
            LogBufferHandler.getInstance().dumpLogBuffer((OutputStream)fileStreamHandler.getRotatingFileOutputStream(), (Formatter)new LogFileFormatter());
            object = new LogFileFormatter();
            ((ConsoleFormatter)object).setDateFormatter(dateFormatter);
            fileStreamHandler.setFormatter((Formatter)object);
            severityChangeListener = new SeverityChangeListener(logMBean, "LogFileSeverity", (Object)fileStreamHandler);
            severityChangeListener.setLevel(logMBean.getLogFileSeverity());
            fileStreamHandler.setFilter(new LogFilter(logMBean, "LogFileFilter", logMBean.getLogFileFilter()));
            logger.addHandler((Handler)((Object)fileStreamHandler));
            MessageLoggerRegistry.registerMessageLogger((String)"", (MessageLogger)loggingService);
            LogMgmtLogger.logServerLogFileOpened((String)fileStreamHandler.toString());
        }
        catch (IOException iOException) {
            LogMgmtLogger.logErrorOpeningLogFile((String)logMBean.computeLogFilePath());
        }
        fileStreamHandler = LogBufferHandler.getInstance();
        severityChangeListener = new SeverityChangeListener(logMBean, "MemoryBufferSeverity", (Object)fileStreamHandler);
        severityChangeListener.setLevel(logMBean.getMemoryBufferSeverity());
        fileStreamHandler.setFilter(new LogFilter(logMBean, "MemoryBufferFilter", logMBean.getMemoryBufferFilter()));
        object = new DomainLogBroadcastHandler();
        severityChangeListener = new SeverityChangeListener(logMBean, "DomainLogBroadcastSeverity", object);
        severityChangeListener.setLevel(logMBean.getDomainLogBroadcastSeverity());
        ((Handler)object).setFilter(new LogFilter(logMBean, "DomainLogBroadcastFilter", logMBean.getDomainLogBroadcastFilter()));
        logger.addHandler((Handler)object);
        try {
            logger.addHandler(new JMXBroadcastHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializeBridgeHandler(logMBean);
        loggingService.stopUsingPrimordialLogger();
        LogMgmtLogger.logDefaultServerLoggingInitialized();
        return logger;
    }

    protected void initializeBridgeHandler(final LogMBean logMBean) {
        this.registerBridgeHandler(logMBean);
        LogManager.getLogManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JDKLoggerFactory.this.registerBridgeHandler(logMBean);
            }
        });
    }

    protected void registerBridgeHandler(LogMBean logMBean) {
        this.bridgeLogger = Logger.getLogger(BRIDGE_LOGGER);
        Handler[] handlerArray = this.bridgeLogger.getHandlers();
        if (handlerArray != null) {
            for (Handler handler : handlerArray) {
                if (!handler.getClass().getName().equals(ServerLoggingHandler.class.getName())) continue;
                return;
            }
        }
        this.bridgeLogger.setUseParentHandlers(logMBean.isServerLoggingBridgeUseParentLoggersEnabled());
        this.bridgeLogger.addHandler(new ServerLoggingHandler());
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        LogMBean logMBean = (LogMBean)beanUpdateEvent.getSourceBean();
        this.updateLoggerSeverities(logMBean);
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    protected void updateLoggerSeverities(LogMBean logMBean) {
        LoggingService loggingService = LoggingService.getInstance();
        Logger logger = loggingService.getLogger("");
        logger.setLevel(WLLevel.getLevel((int)Severities.severityStringToNum((String)logMBean.getLoggerSeverity())));
        Properties properties = logMBean.getLoggerSeverityProperties();
        LoggingService.getInstance().setLoggerSeverities(properties);
    }
}

