/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import weblogic.management.configuration.DomainLogFilterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.provider.AccessCallback;
import weblogic.utils.ArrayUtils;

public final class LogEditObserver
implements AccessCallback,
PropertyChangeListener,
ArrayUtils.DiffHandler {
    private static final String DOMAIN_LOG_FILTERS_PROP = "DomainLogFilters";
    private DomainMBean domain;

    public void accessed(DomainMBean domainMBean) {
        this.domain = domainMBean;
        LogFilterMBean[] logFilterMBeanArray = domainMBean.getLogFilters();
        for (int i = 0; logFilterMBeanArray != null && i < logFilterMBeanArray.length; ++i) {
            DomainLogFilterMBean domainLogFilterMBean = domainMBean.createDomainLogFilter(logFilterMBeanArray[i].getName());
            domainLogFilterMBean.setDelegate(logFilterMBeanArray[i]);
        }
        domainMBean.addPropertyChangeListener(this);
    }

    public void shutdown() {
        this.domain.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(DOMAIN_LOG_FILTERS_PROP)) {
            Object[] objectArray = (DomainLogFilterMBean[])propertyChangeEvent.getOldValue();
            Object[] objectArray2 = (DomainLogFilterMBean[])propertyChangeEvent.getNewValue();
            ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this);
        }
    }

    public void addObject(Object object) {
        DomainLogFilterMBean domainLogFilterMBean = (DomainLogFilterMBean)object;
        if (this.domain.lookupLogFilter(domainLogFilterMBean.getName()) == null) {
            LogFilterMBean logFilterMBean = this.domain.createLogFilter(domainLogFilterMBean.getName());
            domainLogFilterMBean.setDelegate(logFilterMBean);
        }
    }

    public void removeObject(Object object) {
        DomainLogFilterMBean domainLogFilterMBean = (DomainLogFilterMBean)object;
        if (this.domain.lookupLogFilter(domainLogFilterMBean.getName()) != null) {
            this.domain.destroyLogFilter(this.domain.lookupLogFilter(domainLogFilterMBean.getName()));
        }
    }
}

