/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import javax.security.auth.Subject;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.logging.LogEntry;
import weblogic.management.provider.ManagementService;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TxHelper;

public final class LogEntryInitializer {
    private static final String UNKNOWN = "Unknown";
    private static String currentMachineName = null;
    private static String currentServerName = null;
    private static boolean serverInitialized = false;
    private static final AuditableThreadLocal threadLocal = AuditableThreadLocalFactory.createThreadLocal();
    private static final boolean DEBUG = false;

    public static void initializeLogEntry(LogEntry logEntry) {
        if (threadLocal.get() != null) {
            return;
        }
        threadLocal.set((Object)new Boolean(true));
        try {
            logEntry.setUserId(LogEntryInitializer.getCurrentUserId());
            logEntry.setTransactionId(LogEntryInitializer.getCurrentTransactionId());
            logEntry.setMachineName(LogEntryInitializer.getCurrentMachineName());
            logEntry.setServerName(LogEntryInitializer.getCurrentServerName());
            logEntry.setDiagnosticContextId(LogEntryInitializer.getCurrentDiagnosticContextId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        threadLocal.set(null);
    }

    public static String getCurrentMachineName() {
        if (currentMachineName == null) {
            try {
                currentMachineName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                currentMachineName = UNKNOWN;
            }
        }
        return currentMachineName;
    }

    public static String getCurrentServerName() {
        if (!serverInitialized) {
            return "";
        }
        if (currentServerName == null) {
            currentServerName = ManagementService.getRuntimeAccess(KernelIdInitializer.KERNEL_ID).getServerName();
        }
        return currentServerName;
    }

    public static String getCurrentTransactionId() {
        if (!serverInitialized) {
            return "";
        }
        String string = TxHelper.getTransactionId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getCurrentUserId() {
        if (!serverInitialized) {
            return "";
        }
        String string = SubjectUtils.getUsername((Subject)Security.getCurrentSubject());
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getCurrentDiagnosticContextId() {
        if (!serverInitialized) {
            return "";
        }
        String string = DiagnosticContextHelper.getContextId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    static boolean isServerInitialized() {
        return serverInitialized;
    }

    static void setServerInitialized(boolean bl) {
        serverInitialized = bl;
    }

    private static class KernelIdInitializer {
        private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

        private KernelIdInitializer() {
        }
    }
}

