/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.LogFileConfigBean;
import weblogic.management.configuration.CommonLogMBean;
import weblogic.management.configuration.LogFileMBean;

public class LogFileConfigUtil {
    private static final String DEFAULT_ROTATION_TIME = "00:00";

    public static LogFileConfigBean getLogFileConfig(LogFileMBean logFileMBean) {
        String string;
        LogFileConfigBean logFileConfigBean = new LogFileConfigBean();
        logFileConfigBean.setBaseLogFileName(logFileMBean.computeLogFilePath());
        logFileConfigBean.setRotateLogOnStartupEnabled(logFileMBean.getRotateLogOnStartup());
        if (logFileMBean instanceof CommonLogMBean && (string = ((CommonLogMBean)logFileMBean).getLogFileSeverity()) != null) {
            logFileConfigBean.setLogFileSeverity(string);
        }
        logFileConfigBean.setRotatedFileCount(logFileMBean.getFileCount());
        logFileConfigBean.setRotationSize(logFileMBean.getFileMinSize());
        string = logFileMBean.getLogFileRotationDir();
        if (string != null && string.length() > 0) {
            logFileConfigBean.setLogFileRotationDir(string);
        }
        logFileConfigBean.setNumberOfFilesLimited(logFileMBean.isNumberOfFilesLimited());
        String string2 = logFileMBean.getRotationTime();
        if (string2 == null || string2.equals("")) {
            string2 = DEFAULT_ROTATION_TIME;
        }
        logFileConfigBean.setRotationTime(string2);
        String string3 = logFileMBean.getRotationType();
        if (string3 == null || string3.equals("")) {
            string3 = "bySize";
        }
        logFileConfigBean.setRotationType(string3);
        logFileConfigBean.setRotationTimeSpan(logFileMBean.getFileTimeSpan());
        logFileConfigBean.setRotationTimeSpanFactor(logFileMBean.getFileTimeSpanFactor());
        logFileConfigBean.setBufferSizeKB(logFileMBean.getBufferSizeKB());
        return logFileConfigBean;
    }
}

