/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.DateFormatter;
import com.bea.logging.ThrowableWrapper;
import java.util.logging.LogRecord;
import weblogic.kernel.Kernel;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.LogEntry;
import weblogic.logging.SeverityI18N;
import weblogic.logging.WLLogRecord;
import weblogic.logging.WLLogger;
import weblogic.management.configuration.LogFileMBean;
import weblogic.trace.Trace;
import weblogic.utils.PlatformConstants;

public final class LogFileFormatter
extends ConsoleFormatter {
    public static final String BEGIN_MARKER = "####";
    private static final boolean TRACING_ENABLED = Kernel.isTracingEnabled();

    public LogFileFormatter() {
    }

    public LogFileFormatter(LogFileMBean logFileMBean) {
        this.setDateFormatter(new DateFormatter(logFileMBean.getDateFormatPattern()));
    }

    public String format(LogRecord logRecord) {
        WLLogRecord wLLogRecord = WLLogger.normalizeLogRecord(logRecord);
        return this.toString(wLLogRecord);
    }

    public String toString(LogEntry logEntry) {
        return LogFileFormatter.formatForLogFile(logEntry, this.getDateFormatter());
    }

    public static String formatForLogFile(LogEntry logEntry, DateFormatter dateFormatter) {
        String string = logEntry.getMachineName();
        String string2 = logEntry.getServerName();
        String string3 = logEntry.getThreadName();
        if (string3 == null) {
            string3 = Thread.currentThread().getName();
        }
        long l = logEntry.getTimestamp();
        StringBuilder stringBuilder = new StringBuilder(BEGIN_MARKER);
        if (TRACING_ENABLED && Trace.currentTrace() != null) {
            LogFileFormatter.appendToBuffer(stringBuilder, "Tracing Data here");
        }
        logEntry.ensureFormattedDateInitialized(dateFormatter);
        LogFileFormatter.appendToBuffer(stringBuilder, logEntry.getFormattedDate());
        LogFileFormatter.appendToBuffer(stringBuilder, SeverityI18N.severityNumToString((int)logEntry.getSeverity()));
        LogFileFormatter.appendToBuffer(stringBuilder, logEntry.getSubsystem());
        LogFileFormatter.appendToBuffer(stringBuilder, string);
        if (Kernel.isServer()) {
            LogFileFormatter.appendToBuffer(stringBuilder, string2);
            LogFileFormatter.appendToBuffer(stringBuilder, string3);
        }
        LogFileFormatter.appendToBuffer(stringBuilder, logEntry.getUserId());
        LogFileFormatter.appendToBuffer(stringBuilder, logEntry.getTransactionId());
        LogFileFormatter.appendToBuffer(stringBuilder, logEntry.getDiagnosticContextId());
        LogFileFormatter.appendToBuffer(stringBuilder, Long.toString(l));
        LogFileFormatter.appendToBuffer(stringBuilder, logEntry.getId());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(logEntry.getLogMessage());
        ThrowableWrapper throwableWrapper = logEntry.getThrowableWrapper();
        if (throwableWrapper != null) {
            stringBuilder2.append(PlatformConstants.EOL);
            stringBuilder2.append(throwableWrapper.toString(-1));
        }
        LogFileFormatter.appendToBuffer(stringBuilder, stringBuilder2.toString());
        stringBuilder.append(PlatformConstants.EOL);
        return stringBuilder.toString();
    }
}

