/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.BaseLogEntry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.logging.LogVariablesImpl;
import weblogic.diagnostics.query.Query;
import weblogic.diagnostics.query.QueryException;
import weblogic.diagnostics.query.VariableResolver;
import weblogic.logging.LogEntry;
import weblogic.logging.WLLogRecord;
import weblogic.logging.WLLogger;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.LogMBean;

public class LogFilter
implements Filter,
PropertyChangeListener {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugLoggingConfiguration");
    public static final String FILE_FILTER_ATTR = "LogFileFilter";
    public static final String STDOUT_FILTER_ATTR = "StdoutFilter";
    public static final String MEMORY_FILTER_ATTR = "MemoryBufferFilter";
    public static final String DOMAIN_FILTER_ATTR = "DomainLogBroadcastFilter";
    private static final String FILTER_ATTR = "FilterExpression";
    private Query filterQuery = null;
    private String filterAttrName;
    private LogFilterMBean filterConfig = null;

    public LogFilter(LogMBean logMBean, String string, LogFilterMBean logFilterMBean) {
        this.filterConfig = logFilterMBean;
        if (this.filterConfig != null) {
            this.filterConfig.addPropertyChangeListener(this);
        }
        this.filterAttrName = string;
        logMBean.addPropertyChangeListener(this);
        this.initialize();
    }

    public boolean isLoggable(LogRecord logRecord) {
        WLLogRecord wLLogRecord = WLLogger.normalizeLogRecord(logRecord);
        return this.filterLogEntry(wLLogRecord);
    }

    public boolean filterLogEntry(LogEntry logEntry) {
        if (this.filterQuery != null) {
            try {
                return this.filterQuery.executeQuery((VariableResolver)LogVariablesImpl.getInstance().getLogVariablesResolver((BaseLogEntry)logEntry));
            }
            catch (QueryException queryException) {
                return true;
            }
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (string.equals(FILTER_ATTR)) {
            this.initialize();
        } else if (string.equals(this.filterAttrName)) {
            if (this.filterConfig != null) {
                this.filterConfig.removePropertyChangeListener(this);
            }
            this.filterConfig = (LogFilterMBean)object2;
            if (this.filterConfig != null) {
                this.filterConfig.addPropertyChangeListener(this);
            }
            this.initialize();
        }
    }

    private void initialize() {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Initializing filter for " + this.filterAttrName);
        }
        if (this.filterConfig != null) {
            this.filterQuery = this.filterConfig.getQuery();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Filter expression is " + this.filterConfig.getFilterExpression());
            }
        } else {
            this.filterQuery = null;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Filter expression is null");
            }
        }
    }

    public String toString() {
        String string = this.filterConfig == null ? "" : this.filterConfig.getFilterExpression();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The filter is for attribute = " + this.filterAttrName + " with expression " + string);
        return stringBuilder.toString();
    }
}

