/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.File;
import java.io.IOException;
import javax.management.InvalidAttributeValueException;
import weblogic.logging.Severities;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainLogFilterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LogFilterMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;
import weblogic.utils.PlatformConstants;

public class LoggingConfigurationProcessor
implements ConfigurationProcessor {
    private static String FILE_NAME_ATTR = "FileName";
    private static final boolean DEBUG = false;

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        DomainLogFilterMBean[] domainLogFilterMBeanArray = domainMBean.getDomainLogFilters();
        for (int i = 0; domainLogFilterMBeanArray != null && i < domainLogFilterMBeanArray.length; ++i) {
            LoggingConfigurationProcessor.upgradeDomainLogFilter(domainMBean, domainLogFilterMBeanArray[i]);
        }
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            this.upgradeServerLogConfiguration(domainMBean, serverMBeanArray[i]);
        }
        LogMBean logMBean = domainMBean.getLog();
        if (LoggingConfigurationProcessor.isLogFileNameDefaulted(logMBean)) {
            LoggingConfigurationProcessor.unsetLogFileName(logMBean);
        }
    }

    public void upgradeServerLogConfiguration(DomainMBean domainMBean, ServerMBean serverMBean) {
        LogMBean logMBean = serverMBean.getLog();
        String string = LoggingConfigurationProcessor.getNormalizedStdoutSeverity(serverMBean.isStdoutEnabled(), serverMBean.getStdoutSeverityLevel(), serverMBean.isStdoutDebugEnabled());
        if (logMBean.getStdoutSeverity() == null || logMBean.getStdoutSeverity().equals("Notice") && !string.equals("Notice")) {
            logMBean.setStdoutSeverity(string);
        }
        if (serverMBean.isSet("StdoutFormat")) {
            logMBean.setStdoutFormat(serverMBean.getStdoutFormat());
        }
        if (serverMBean.isSet("StdoutLogStack")) {
            logMBean.setStdoutLogStack(serverMBean.isStdoutLogStack());
        }
        LoggingConfigurationProcessor.upgradeDomainLogFilterEnabled(serverMBean);
        LoggingConfigurationProcessor.upgradeDomainLogFilter(domainMBean, serverMBean);
        if (LoggingConfigurationProcessor.isLogFileNameDefaulted(logMBean)) {
            LoggingConfigurationProcessor.unsetLogFileName(logMBean);
        }
    }

    private static void unsetLogFileName(LogMBean logMBean) {
        logMBean.unSet(FILE_NAME_ATTR);
    }

    private static boolean isLogFileNameDefaulted(LogMBean logMBean) {
        String string = logMBean.getFileName();
        String string2 = logMBean.getName() + ".log";
        if (string.equals(string2)) {
            return true;
        }
        File file = new File(logMBean.getFileName());
        if (file.isAbsolute()) {
            return false;
        }
        File file2 = null;
        boolean bl = logMBean.getParent() instanceof ServerMBean;
        file2 = bl ? new File(DomainDir.getRootDir() + PlatformConstants.FILE_SEP + logMBean.getName()) : new File(DomainDir.getRootDir());
        File file3 = new File(file2, logMBean.getName() + ".log");
        try {
            boolean bl2 = file3.getCanonicalFile().equals(file.getCanonicalFile());
            return bl2;
        }
        catch (IOException iOException) {
            return file3.equals(file);
        }
    }

    public static void upgradeDomainLogFilter(DomainMBean domainMBean, ServerMBean serverMBean) {
        DomainLogFilterMBean domainLogFilterMBean = serverMBean.getDomainLogFilter();
        LoggingConfigurationProcessor.applyDomainLogFilterToLogMBean(domainMBean, serverMBean.getLog(), domainLogFilterMBean);
    }

    public static void upgradeDomainLogFilter(DomainMBean domainMBean, DomainLogFilterMBean domainLogFilterMBean) {
        if (domainLogFilterMBean == null) {
            return;
        }
        LogFilterMBean logFilterMBean = domainMBean.createLogFilter(domainLogFilterMBean.getName());
        String[] stringArray = domainLogFilterMBean.getUserIds();
        String[] stringArray2 = domainLogFilterMBean.getSubsystemNames();
        int n = domainLogFilterMBean.getSeverityLevel();
        logFilterMBean.setUserIds(stringArray);
        logFilterMBean.setSubsystemNames(stringArray2);
        logFilterMBean.setSeverityLevel(n);
        String string = LoggingConfigurationProcessor.convertOldAttrsToFilterExpression(stringArray, stringArray2);
        try {
            logFilterMBean.setFilterExpression(string);
            if (string.length() == 0) {
                logFilterMBean.unSet("FilterExpression");
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)"Invalid filter expression");
        }
    }

    public static void applyDomainLogFilterToLogMBean(DomainMBean domainMBean, LogMBean logMBean, DomainLogFilterMBean domainLogFilterMBean) {
        if (domainLogFilterMBean != null) {
            String string = Severities.severityNumToString((int)domainLogFilterMBean.getSeverityLevel());
            logMBean.setDomainLogBroadcastSeverity(string);
            LogFilterMBean logFilterMBean = domainMBean.lookupLogFilter(domainLogFilterMBean.getName());
            logMBean.setDomainLogBroadcastFilter(logFilterMBean);
        } else {
            logMBean.unSet("DomainLogBroadcastFilter");
        }
    }

    public static String convertOldAttrsToFilterExpression(String[] stringArray, String[] stringArray2) {
        String string = "";
        if (stringArray != null && stringArray.length > 0) {
            string = "USERID IN " + LoggingConfigurationProcessor.convertToQueryParams(stringArray);
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            String string2 = "SUBSYSTEM IN " + LoggingConfigurationProcessor.convertToQueryParams(stringArray2);
            string = string.length() > 0 ? string + " AND " + string2 : string2;
        }
        return string;
    }

    private static String convertToQueryParams(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("('");
        stringBuilder.append(stringArray[0]);
        stringBuilder.append("'");
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",'");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("'");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void upgradeDomainLogFilterEnabled(ServerMBean serverMBean) {
        LogMBean logMBean = serverMBean.getLog();
        if (serverMBean.isEnabledForDomainLog()) {
            if (logMBean.getDomainLogBroadcastSeverity().equals("Off")) {
                logMBean.setDomainLogBroadcastSeverity("Warning");
            }
        } else {
            logMBean.setDomainLogBroadcastSeverity("Off");
        }
    }

    public static String getNormalizedStdoutSeverity(boolean bl, int n, boolean bl2) {
        n = Math.max(n, bl2 ? 128 : n);
        if (!bl) {
            n = 0;
        }
        return Severities.severityNumToString((int)n);
    }
}

