/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.logging.Logger;
import weblogic.i18n.logging.LoggingTextFormatter;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelLogManager;
import weblogic.logging.LoggerNotAvailableException;
import weblogic.management.logging.DomainLogHandlerException;
import weblogic.management.logging.DomainLogHandlerImpl;

public final class LoggingHelper {
    public static Logger getServerLogger() {
        if (Kernel.isServer()) {
            return KernelLogManager.getLogger();
        }
        return null;
    }

    public static Logger getClientLogger() {
        if (!Kernel.isServer()) {
            return KernelLogManager.getLogger();
        }
        return null;
    }

    public static Logger getDomainLogger() throws LoggerNotAvailableException {
        try {
            return ((DomainLogHandlerImpl)DomainLogHandlerImpl.getInstance()).getDomainLogger();
        }
        catch (DomainLogHandlerException domainLogHandlerException) {
            LoggingTextFormatter loggingTextFormatter = new LoggingTextFormatter();
            throw new LoggerNotAvailableException(loggingTextFormatter.getDomainLoggerDoesNotExistMsg());
        }
    }
}

