/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.BaseLogEntry;
import com.bea.logging.LogBufferHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.descriptor.LogEntryBean;
import weblogic.diagnostics.image.descriptor.LoggingImageSourceBean;

public class LoggingImageSource
implements ImageSource {
    private static LoggingImageSource singleton = new LoggingImageSource();
    private boolean timedOut = false;

    public static LoggingImageSource getInstance() {
        return singleton;
    }

    private LoggingImageSource() {
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        this.timedOut = false;
        try {
            DescriptorManager descriptorManager = new DescriptorManager();
            Descriptor descriptor = descriptorManager.createDescriptorRoot(LoggingImageSourceBean.class);
            LoggingImageSourceBean loggingImageSourceBean = (LoggingImageSourceBean)descriptor.getRootBean();
            Iterator iterator = LogBufferHandler.getInstance().getLogBufferIterator();
            while (iterator.hasNext()) {
                BaseLogEntry baseLogEntry = (BaseLogEntry)iterator.next();
                LogEntryBean logEntryBean = loggingImageSourceBean.createLogEntry();
                logEntryBean.setDiagnosticContextId(baseLogEntry.getDiagnosticContextId());
                logEntryBean.setMachineName(baseLogEntry.getMachineName());
                logEntryBean.setServerName(baseLogEntry.getServerName());
                logEntryBean.setTransactionId(baseLogEntry.getTransactionId());
                logEntryBean.setUserId(baseLogEntry.getUserId());
                logEntryBean.setLogMessage(baseLogEntry.getLogMessage());
                logEntryBean.setFormattedDate(baseLogEntry.getFormattedDate());
                logEntryBean.setMessageId(baseLogEntry.getId());
                logEntryBean.setSeverity(baseLogEntry.getSeverity());
                logEntryBean.setSubsystem(baseLogEntry.getSubsystem());
                logEntryBean.setThreadName(baseLogEntry.getThreadName());
                logEntryBean.setTimestamp(baseLogEntry.getTimestamp());
                if (baseLogEntry.getThrowableWrapper() == null) continue;
                logEntryBean.setStackTrace(baseLogEntry.getThrowableWrapper().toString());
            }
            descriptorManager.writeDescriptorBeanAsXML((DescriptorBean)loggingImageSourceBean, outputStream);
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException((Throwable)iOException);
        }
    }

    public void timeoutImageCreation() {
        this.timedOut = true;
    }
}

