/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import weblogic.kernel.KernelLogManager;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class LoggingOutputStream
extends OutputStream {
    private static final NoOpRunnable NOOP_TASK = new NoOpRunnable();
    static final String STDOUT = "Stdout";
    static final String STDERR = "StdErr";
    private static final int MAX_LIMIT = 10;
    private ByteArrayOutputStream buffer;
    private String logStream;
    private WLLevel level;
    private boolean async = false;
    private WorkManager workManager = WorkManagerFactory.getInstance().find("weblogic.admin.RMI");
    private ConcurrentLinkedQueue<LogRecord> logRecordQueue = new ConcurrentLinkedQueue();
    private AtomicInteger queueSize = new AtomicInteger();

    public LoggingOutputStream(String string, WLLevel wLLevel, boolean bl) {
        this.buffer = new ByteArrayOutputStream();
        this.logStream = string;
        this.level = wLLevel;
        this.async = bl;
    }

    public LoggingOutputStream(String string, WLLevel wLLevel) {
        this(string, wLLevel, false);
    }

    public void write(int n) {
        this.buffer.write(n);
    }

    public void flush() {
        String string = this.buffer.toString().trim();
        if (string.length() == 0) {
            return;
        }
        WLLogRecord wLLogRecord = new WLLogRecord((Level)((Object)this.level), string);
        wLLogRecord.setLoggerName(this.logStream);
        if (this.async) {
            int n = this.queueSize.get();
            if (n < 10) {
                this.logRecordQueue.add((LogRecord)((Object)wLLogRecord));
                this.queueSize.incrementAndGet();
                this.logAsync(wLLogRecord);
            }
        } else {
            KernelLogManager.getLogger().log((LogRecord)((Object)wLLogRecord));
        }
        this.buffer.reset();
    }

    private void logAsync(WLLogRecord wLLogRecord) {
        this.workManager.schedule((Runnable)new WorkAdapter(){

            public Runnable cancel(String string) {
                return NOOP_TASK;
            }

            public Runnable overloadAction(String string) {
                return NOOP_TASK;
            }

            public void run() {
                LogRecord logRecord = null;
                while ((logRecord = (LogRecord)LoggingOutputStream.this.logRecordQueue.poll()) != null) {
                    LoggingOutputStream.this.queueSize.decrementAndGet();
                    KernelLogManager.getLogger().log(logRecord);
                }
            }
        });
    }

    private static class NoOpRunnable
    implements Runnable {
        private NoOpRunnable() {
        }

        public void run() {
        }
    }
}

