/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.MsgIdPrefixConverter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.CatalogMessage;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18ntools.L10nLookup;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;

public final class MessageLogger {
    private static final boolean USE_PREFIX = true;
    private static final String PREFIX_PROP = "weblogic.MessageIdPrefixEnabled";
    private static boolean usePrefix;
    private static Method getLoggerMethod;

    public static void log(String string, Object[] objectArray, String string2) {
        MessageLogger.log(new CatalogMessage(string, objectArray, string2));
    }

    public static void log(CatalogMessage catalogMessage) {
        Object object;
        Object[] objectArray = catalogMessage.getArguments();
        WLLogRecord wLLogRecord = new WLLogRecord(Level.OFF, null);
        wLLogRecord.setParameters(objectArray);
        try {
            Object object2;
            object = catalogMessage.getMessageId();
            if (usePrefix) {
                try {
                    object2 = catalogMessage.getMessageIdPrefix();
                    if (object2 != null) {
                        object = MsgIdPrefixConverter.convertMsgIdPrefix((String)object2) + "-" + catalogMessage.getMessageId();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            wLLogRecord.setId((String)object);
            object2 = WLLevel.getLevel((int)catalogMessage.getSeverity());
            wLLogRecord.setLevel((Level)object2);
            wLLogRecord.setLoggerName(catalogMessage.getSubsystem());
            wLLogRecord.setMessage(catalogMessage.getMessage());
            wLLogRecord.setParameters(objectArray);
            wLLogRecord.setDiagnosticVolume(catalogMessage.getDiagnosticVolume());
        }
        catch (MissingResourceException missingResourceException) {
            wLLogRecord.setLoggerName("Unknown");
            wLLogRecord.setMessage("Message text not found - " + missingResourceException.getMessage());
        }
        if (catalogMessage.isStackTraceEnabled()) {
            wLLogRecord.setThrown(MessageLogger.getThrowable(objectArray));
        }
        try {
            object = (Logger)getLoggerMethod.invoke(null, null);
            ((Logger)object).log((LogRecord)((Object)wLLogRecord));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static void log(LogMessage logMessage) {
        Object object;
        if (logMessage instanceof CatalogMessage) {
            CatalogMessage catalogMessage = (CatalogMessage)logMessage;
            MessageLogger.log(catalogMessage);
            return;
        }
        WLLogRecord wLLogRecord = new WLLogRecord(Level.OFF, null);
        String string = logMessage.getMessageId();
        if (string != null && string.length() > 0) {
            Object object2 = object = usePrefix ? logMessage.getMessageIdPrefix() : "";
            if (object != null && ((String)object).length() > 0) {
                string = MsgIdPrefixConverter.convertMsgIdPrefix((String)object) + "-" + logMessage.getMessageId();
            }
        }
        wLLogRecord.setId(string);
        object = WLLevel.getLevel((int)logMessage.getSeverity());
        wLLogRecord.setLevel((Level)object);
        wLLogRecord.setLoggerName(logMessage.getSubsystem());
        wLLogRecord.setMessage(logMessage.getMessage());
        wLLogRecord.setThrown(logMessage.getThrowable());
        try {
            Logger logger = (Logger)getLoggerMethod.invoke(null, null);
            logger.log((LogRecord)((Object)wLLogRecord));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static Throwable getThrowable(Object[] objectArray) {
        Object object;
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length - 1;
        if (n >= 0 && (object = objectArray[n]) instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    public static void log(Level level, String string, String string2) {
        MessageLogger.log(level, string, string2, null);
    }

    public static void log(Level level, String string, String string2, Throwable throwable) {
        WLLogRecord wLLogRecord = new WLLogRecord(level, string2, throwable);
        wLLogRecord.setLoggerName(string);
        try {
            Logger logger = (Logger)getLoggerMethod.invoke(null, null);
            logger.log((LogRecord)((Object)wLLogRecord));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static void setUsePrefix(boolean bl) {
        usePrefix = bl;
    }

    public static String localizeMessage(String string, Object[] objectArray, String string2) {
        try {
            Localizer localizer = L10nLookup.getLocalizer((Locale)Locale.getDefault(), (String)string2);
            String string3 = localizer.getBody(string);
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return "Error message text was not found: " + missingResourceException.getMessage();
        }
    }

    static {
        Object object;
        usePrefix = true;
        try {
            object = System.getProperty(PREFIX_PROP);
            if (object != null) {
                MessageLogger.setUsePrefix(Boolean.getBoolean(PREFIX_PROP));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = Class.forName("weblogic.kernel.KernelLogManager");
            getLoggerMethod = ((Class)object).getMethod("getLogger", null);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

