/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.MsgIdPrefixConverter;
import java.security.AccessController;
import java.util.logging.Logger;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.diagnostics.image.ImageManager;
import weblogic.kernel.KernelLogManager;
import weblogic.logging.JDKLoggerFactory;
import weblogic.logging.LogBufferHandlerInitializer;
import weblogic.logging.LogEntryInitializer;
import weblogic.logging.LoggingImageSource;
import weblogic.logging.LoggingOutputStream;
import weblogic.logging.LoggingPrintStream;
import weblogic.logging.StdoutSeverityListener;
import weblogic.logging.WLLevel;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.logging.LogRuntime;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ServerLoggingInitializer {
    private static final boolean DEBUG = false;

    public static void initializeServerLogging() throws ManagementException {
        RuntimeAccess runtimeAccess = ServerLoggingInitializer.getRuntimeAccess();
        ServerMBean serverMBean = runtimeAccess.getServer();
        if (serverMBean == null) {
            return;
        }
        LogBufferHandlerInitializer.initServerLogBufferHandler(serverMBean.getLog());
        JDKLoggerFactory jDKLoggerFactory = JDKLoggerFactory.getJDKLoggerFactory(serverMBean.getLog());
        Logger logger = jDKLoggerFactory.createAndInitializeServerLogger(serverMBean);
        KernelLogManager.setLogger(logger);
        serverMBean.getLog().addPropertyChangeListener(StdoutSeverityListener.getStdoutSeverityListener(serverMBean));
        if (serverMBean.getLog().isRedirectStdoutToServerLogEnabled()) {
            System.setOut(new LoggingPrintStream(new LoggingOutputStream("Stdout", WLLevel.NOTICE, true)));
        }
        if (serverMBean.getLog().isRedirectStderrToServerLogEnabled()) {
            System.setErr(new LoggingPrintStream(new LoggingOutputStream("StdErr", WLLevel.NOTICE, true)));
        }
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource("Logging", LoggingImageSource.getInstance());
        ServerRuntimeMBean serverRuntimeMBean = runtimeAccess.getServerRuntime();
        LogRuntime logRuntime = new LogRuntime(serverMBean.getLog(), serverRuntimeMBean);
        serverRuntimeMBean.setLogRuntime(logRuntime);
        LogEntryInitializer.setServerInitialized(true);
        boolean bl = runtimeAccess.getDomain().isMsgIdPrefixCompatibilityEnabled();
        ServerLoggingInitializer.initializeMsgIdPrefixConverter(bl);
        runtimeAccess.getDomain().addBeanUpdateListener(new BeanUpdateListener(){

            public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
                DomainMBean domainMBean = (DomainMBean)beanUpdateEvent.getProposedBean();
                ServerLoggingInitializer.initializeMsgIdPrefixConverter(domainMBean.isMsgIdPrefixCompatibilityEnabled());
            }

            public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            }

            public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            }
        });
    }

    private static void initializeMsgIdPrefixConverter(boolean bl) {
        MsgIdPrefixConverter.setCompatibilityModeEnabled((boolean)bl);
    }

    private static RuntimeAccess getRuntimeAccess() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return ManagementService.getRuntimeAccess(authenticatedSubject);
    }
}

