/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Handler;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Severities;
import weblogic.logging.WLLevel;
import weblogic.management.configuration.LogMBean;

public class SeverityChangeListener
implements PropertyChangeListener {
    public static final String STDOUT_ATTR = "StdoutSeverity";
    public static final String FILE_ATTR = "LogFileSeverity";
    public static final String MEMORY_BUFFER_ATTR = "MemoryBufferSeverity";
    public static final String DOMAIN_LOG_BROADCAST_ATTR = "DomainLogBroadcastSeverity";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugLoggingConfiguration");
    private String severityAttrName;
    protected Object logDest;

    public SeverityChangeListener(LogMBean logMBean, String string, Object object) {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Adding listener on " + logMBean.toString());
        }
        logMBean.addPropertyChangeListener(this);
        this.severityAttrName = string;
        this.logDest = object;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(this.severityAttrName)) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.setLevel(string);
        }
    }

    public void setLevel(String string) {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Setting severity = " + string + " on the " + this.logDest.getClass().getName() + " Handler");
        }
        int n = Severities.severityStringToNum((String)string);
        ((Handler)this.logDest).setLevel(WLLevel.getLevel((int)n));
    }
}

