/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.logging.Level;
import weblogic.i18n.logging.LoggingTextFormatter;
import weblogic.logging.ConsoleHandler;
import weblogic.logging.MessageLogger;
import weblogic.logging.Severities;
import weblogic.logging.SeverityI18N;
import weblogic.logging.WLLevel;
import weblogic.management.configuration.KernelMBean;

public class StdoutSeverityListener
implements PropertyChangeListener {
    private static StdoutSeverityListener singleton = null;
    private final LoggingTextFormatter formatter = new LoggingTextFormatter();
    private final KernelMBean config;
    private final ConsoleHandler console;
    private int stdoutSeverityLevel;

    public static StdoutSeverityListener getStdoutSeverityListener(KernelMBean kernelMBean) {
        if (singleton == null) {
            singleton = new StdoutSeverityListener(kernelMBean);
        }
        return singleton;
    }

    private StdoutSeverityListener(KernelMBean kernelMBean) {
        this.config = kernelMBean;
        this.console = new ConsoleHandler(kernelMBean);
        this.initializeSeverityLevel();
    }

    int getStdoutSeverityLevel() {
        return this.stdoutSeverityLevel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.initializeSeverityLevel();
        if ("StdoutSeverity".equals(propertyChangeEvent.getPropertyName())) {
            this.informUsersOfSeverityLevel();
        }
    }

    private void initializeSeverityLevel() {
        this.stdoutSeverityLevel = Severities.severityStringToNum((String)this.config.getLog().getStdoutSeverity());
    }

    private void informUsersOfSeverityLevel() {
        if (!this.config.isStdoutEnabled()) {
            String string = this.formatter.noConsoleSeverity2Log();
            MessageLogger.log((Level)((Object)WLLevel.INFO), "Logging", string);
            return;
        }
        int n = this.config.getStdoutSeverityLevel();
        String string = null;
        if (n >= 64) {
            string = this.formatter.everyConsoleSeverity2Log();
        } else {
            String string2 = SeverityI18N.severityNumToString((int)n, (Locale)Locale.getDefault());
            string = this.formatter.someConsoleSeverity2Log(string2);
        }
        MessageLogger.log((Level)((Object)WLLevel.INFO), "Logging", string);
    }
}

