/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.util.logging.ErrorManager;
import java.util.logging.Handler;

public class WLErrorManager
extends ErrorManager {
    private final Handler handler;
    private static final int EXCEPTION_TOLERANCE_LIMIT = 3;
    private int exceptionsEncountered = 0;
    private boolean exitImmediately = false;

    public WLErrorManager(Handler handler) {
        this.handler = handler;
    }

    public synchronized void error(String string, Exception exception, int n) {
        if (this.exitImmediately) {
            return;
        }
        ++this.exceptionsEncountered;
        String string2 = null;
        if (this.exceptionsEncountered > 3 || n == 4) {
            this.exitImmediately = true;
            this.handler.close();
            string2 = "Handler: '" + this.handler.toString() + "' reported critical error(s). Shutting it down.";
        } else {
            string2 = "Handler: '" + this.handler.toString() + "' raised exception" + WLErrorManager.codeToDesc(n) + ".";
        }
        System.err.println(string2);
    }

    private static String codeToDesc(int n) {
        switch (n) {
            case 1: {
                return " when writing";
            }
            case 2: {
                return " when flushing";
            }
            case 3: {
                return " when closing";
            }
            case 4: {
                return " when opening";
            }
            case 5: {
                return " when formatting";
            }
        }
        return "";
    }
}

