/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.BaseLogRecord;
import com.bea.logging.LogLevel;
import com.bea.logging.ThrowableWrapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import weblogic.i18n.logging.LogMessage;
import weblogic.logging.LogEntry;
import weblogic.logging.LogEntryInitializer;
import weblogic.logging.ThrowableInfo;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogger;

public class WLLogRecord
extends BaseLogRecord
implements LogEntry,
Externalizable {
    private static final long serialVersionUID = -8930788966766077378L;
    private transient ThrowableInfo thInfo = null;

    public WLLogRecord() {
        this((Level)((Object)WLLevel.INFO), "");
    }

    public WLLogRecord(Level level, String string) {
        super(LogLevel.getSeverity((Level)level), string);
        LogEntryInitializer.initializeLogEntry(this);
    }

    public WLLogRecord(Level level, String string, Throwable throwable) {
        this(level, string);
        this.setThrown(throwable);
    }

    public WLLogRecord(LogMessage logMessage) {
        super(logMessage);
        LogEntryInitializer.initializeLogEntry(this);
    }

    public ThrowableInfo getThrowableInfo() {
        ThrowableWrapper throwableWrapper = this.getThrowableWrapper();
        if (throwableWrapper != null && throwableWrapper.getThrowable() != null) {
            this.thInfo = new ThrowableInfo(throwableWrapper.getThrowable());
        }
        return this.thInfo;
    }

    public void setThrowableInfo(ThrowableInfo throwableInfo) {
        this.thInfo = throwableInfo;
        if (throwableInfo != null && throwableInfo.getThrowable() != null) {
            super.setThrown(throwableInfo.getThrowable());
        }
    }

    public static WLLogRecord normalizeLogRecord(LogRecord logRecord) {
        return WLLogger.normalizeLogRecord(logRecord);
    }

    public String toString() {
        return this.getMessage();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.getSubsystem());
        objectOutput.writeUTF(this.getId());
        String string = this.getLogMessage();
        byte[] byArray = string != null ? string.getBytes("UTF-8") : new byte[]{};
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
        objectOutput.writeInt(this.getSeverity());
        objectOutput.writeLong(this.getTimestamp());
        objectOutput.writeObject(this.getThrowableWrapper());
        objectOutput.writeUTF(this.getMachineName());
        objectOutput.writeUTF(this.getServerName());
        objectOutput.writeUTF(this.getThreadName());
        objectOutput.writeUTF(this.getTransactionId());
        objectOutput.writeUTF(this.getDiagnosticContextId());
        objectOutput.writeUTF(this.getUserId());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setLoggerName(objectInput.readUTF());
        this.setId(objectInput.readUTF());
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        String string = new String(byArray, "UTF-8");
        this.setMessage(string);
        this.setLevel(WLLevel.getLevel((int)objectInput.readInt()));
        this.setMillis(objectInput.readLong());
        this.setThrowableWrapper((ThrowableWrapper)objectInput.readObject());
        this.setMachineName(objectInput.readUTF());
        this.setServerName(objectInput.readUTF());
        this.setThreadName(objectInput.readUTF());
        this.setTransactionId(objectInput.readUTF());
        this.setDiagnosticContextId(objectInput.readUTF());
        this.setUserId(objectInput.readUTF());
    }
}

