/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import com.bea.logging.BaseLogger;
import java.util.WeakHashMap;
import java.util.logging.LogRecord;
import weblogic.logging.LogEntryInitializer;
import weblogic.logging.WLLogRecord;

public class WLLogger
extends BaseLogger {
    private boolean isDomainLogger = false;
    private static final WeakHashMap NORMALIZED_CACHE = new WeakHashMap();

    public WLLogger(String string) {
        this(string, false);
    }

    public WLLogger(String string, boolean bl) {
        super(string);
        this.isDomainLogger = bl;
    }

    public void log(LogRecord serializable) {
        if (!(serializable instanceof WLLogRecord)) {
            serializable = WLLogger.normalizeLogRecord(serializable);
        }
        if (!this.isDomainLogger) {
            LogEntryInitializer.initializeLogEntry((WLLogRecord)serializable);
        }
        super.log(serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WLLogRecord normalizeLogRecord(LogRecord logRecord) {
        if (logRecord instanceof WLLogRecord) {
            return (WLLogRecord)((Object)logRecord);
        }
        WLLogRecord wLLogRecord = null;
        WeakHashMap weakHashMap = NORMALIZED_CACHE;
        synchronized (weakHashMap) {
            wLLogRecord = (WLLogRecord)NORMALIZED_CACHE.get(logRecord);
        }
        if (wLLogRecord != null) {
            return wLLogRecord;
        }
        wLLogRecord = new WLLogRecord(logRecord.getLevel(), WLLogger.formatMessage((LogRecord)logRecord), logRecord.getThrown());
        wLLogRecord.setLoggerName(logRecord.getLoggerName() == null ? "Default" : logRecord.getLoggerName());
        wLLogRecord.setMillis(logRecord.getMillis());
        wLLogRecord.setParameters(logRecord.getParameters());
        wLLogRecord.setResourceBundle(logRecord.getResourceBundle());
        wLLogRecord.setResourceBundleName(logRecord.getResourceBundleName());
        wLLogRecord.setSequenceNumber(logRecord.getSequenceNumber());
        wLLogRecord.setSourceClassName(logRecord.getSourceClassName());
        wLLogRecord.setSourceMethodName(logRecord.getSourceMethodName());
        wLLogRecord.setThreadID(logRecord.getThreadID());
        wLLogRecord.setThrown(logRecord.getThrown());
        weakHashMap = NORMALIZED_CACHE;
        synchronized (weakHashMap) {
            NORMALIZED_CACHE.put(logRecord, wLLogRecord);
        }
        return wLLogRecord;
    }
}

