/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class WeblogicLogfileFilter
implements FilenameFilter {
    private String wlsLogfile;
    private static final int NUM_OF_DIGITS_IN_SUFFIX = String.valueOf(99999).length();
    private Pattern pattern = null;

    public WeblogicLogfileFilter(String string) {
        this.wlsLogfile = string;
        if (this.wlsLogfile.indexOf(37) > -1) {
            try {
                String string2 = Pattern.compile("%.*?%").matcher(string).replaceAll(".*?") + "([0-9]{" + NUM_OF_DIGITS_IN_SUFFIX + "})*";
                this.pattern = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.pattern = null;
            }
        }
    }

    public WeblogicLogfileFilter(File file) {
        this(file.getName());
    }

    public boolean accept(File file, String string) {
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(string);
            return matcher.matches();
        }
        int n = this.wlsLogfile.length();
        if (!string.startsWith(this.wlsLogfile)) {
            return false;
        }
        if (string.length() != n + NUM_OF_DIGITS_IN_SUFFIX) {
            return false;
        }
        for (int i = 0; i < NUM_OF_DIGITS_IN_SUFFIX; ++i) {
            if (Character.isDigit(string.charAt(n + i))) continue;
            return false;
        }
        return true;
    }
}

