/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging.j2ee;

import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import weblogic.j2ee.descriptor.wl.LoggingBean;
import weblogic.kernel.KernelLogManager;
import weblogic.logging.FileStreamHandler;
import weblogic.logging.LogFileFormatter;
import weblogic.logging.MessageLogger;
import weblogic.logging.WLErrorManager;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.logging.WLLogger;
import weblogic.logging.j2ee.LoggingBeanAdapter;
import weblogic.management.configuration.LogFileMBean;

public final class ServletContextLogger {
    private static final String LOCALIZER_CLASS = "weblogic.i18n.LogMgmtLogLocalizer";
    private static final String MSG_ID = "170028";
    private String contextName;
    private LoggingBeanAdapter logAdapter = null;
    private Logger logger = KernelLogManager.getLogger();

    public ServletContextLogger(String string, LoggingBean loggingBean) {
        this.contextName = string;
        if (loggingBean != null && loggingBean.getLogFilename() != null && loggingBean.getLogFilename().length() > 0) {
            WLLogger wLLogger = new WLLogger(this.contextName);
            this.logAdapter = new LoggingBeanAdapter(loggingBean);
            try {
                FileStreamHandler fileStreamHandler = new FileStreamHandler(this.logAdapter);
                fileStreamHandler.setFormatter(new LogFileFormatter((LogFileMBean)this.logAdapter));
                fileStreamHandler.setErrorManager(new WLErrorManager((Handler)((Object)fileStreamHandler)));
                wLLogger.addHandler((Handler)((Object)fileStreamHandler));
                this.logger = wLLogger;
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{this.contextName};
                MessageLogger.log(MSG_ID, objectArray, LOCALIZER_CLASS);
            }
        }
    }

    public LoggingBeanAdapter getLogAdapter() {
        return this.logAdapter;
    }

    public void log(String string) {
        WLLogRecord wLLogRecord = new WLLogRecord((Level)((Object)WLLevel.INFO), string);
        wLLogRecord.setLoggerName(this.contextName);
        this.logger.log((LogRecord)((Object)wLLogRecord));
    }

    public void logError(String string) {
        WLLogRecord wLLogRecord = new WLLogRecord((Level)((Object)WLLevel.ERROR), string);
        wLLogRecord.setLoggerName(this.contextName);
        this.logger.log((LogRecord)((Object)wLLogRecord));
    }

    public void log(String string, Throwable throwable) {
        WLLogRecord wLLogRecord = new WLLogRecord((Level)((Object)WLLevel.ERROR), string, throwable);
        wLLogRecord.setLoggerName(this.contextName);
        this.logger.log((LogRecord)((Object)wLLogRecord));
    }
}

