/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging.jms;

import com.bea.logging.DateFormatter;
import java.util.Date;
import java.util.logging.LogRecord;
import weblogic.logging.ConsoleFormatter;
import weblogic.logging.jms.JMSMessageConsumerCreationLogRecord;
import weblogic.logging.jms.JMSMessageLogRecord;
import weblogic.management.configuration.LogFileMBean;
import weblogic.utils.PlatformConstants;

public final class JMSMessageLogFileFormatter
extends ConsoleFormatter {
    public static final String BEGIN_MARKER = "####";
    private static final String UNKNOWN = "Unknown";

    public JMSMessageLogFileFormatter(LogFileMBean logFileMBean) {
        this.setDateFormatter(new DateFormatter(logFileMBean.getDateFormatPattern()));
    }

    public String format(LogRecord logRecord) {
        return this.formatJMSMessageLogRecord((JMSMessageLogRecord)logRecord);
    }

    private String formatJMSMessageLogRecord(JMSMessageLogRecord jMSMessageLogRecord) {
        long l = jMSMessageLogRecord.getEventTimeMillisStamp();
        String string = this.formatDate(new Date(l));
        StringBuilder stringBuilder = new StringBuilder(BEGIN_MARKER);
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, string);
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getTransactionId());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getDiagnosticContextId());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, Long.toString(l));
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, Long.toString(jMSMessageLogRecord.getEventTimeNanoStamp()));
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getJMSMessageId());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getJMSCorrelationId());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getJMSDestinationName());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getJMSMessageState());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getUser());
        JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, jMSMessageLogRecord.getDurableSubscriber());
        JMSMessageLogFileFormatter.appendToBufferEscaped(stringBuilder, jMSMessageLogRecord.getMessage());
        if (jMSMessageLogRecord instanceof JMSMessageConsumerCreationLogRecord) {
            JMSMessageLogFileFormatter.appendToBufferEscaped(stringBuilder, ((JMSMessageConsumerCreationLogRecord)jMSMessageLogRecord).getSelector());
        } else {
            JMSMessageLogFileFormatter.appendToBuffer(stringBuilder, null);
        }
        stringBuilder.append(PlatformConstants.EOL);
        return stringBuilder.toString();
    }
}

