/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging.jms;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import weblogic.logging.FileStreamHandler;
import weblogic.logging.jms.JMSMessageLogFileFormatter;
import weblogic.logging.jms.JMSMessageLogger;
import weblogic.logging.jms.JMSSAFMessageLogger;
import weblogic.management.configuration.JMSMessageLogFileMBean;
import weblogic.management.configuration.JMSSAFMessageLogFileMBean;

public class JMSMessageLoggerFactory {
    private static Map jmsMessageLoggers = new HashMap();
    private static Map jmsSAFMessageLoggers = new HashMap();

    public static JMSMessageLogger findOrCreateJMSMessageLogger(JMSMessageLogFileMBean jMSMessageLogFileMBean) throws IOException {
        String string = jMSMessageLogFileMBean.getName();
        if (!jmsMessageLoggers.containsKey(string)) {
            JMSMessageLogger jMSMessageLogger = new JMSMessageLogger(string);
            FileStreamHandler fileStreamHandler = new FileStreamHandler(jMSMessageLogFileMBean);
            fileStreamHandler.setFormatter(new JMSMessageLogFileFormatter(jMSMessageLogFileMBean));
            jMSMessageLogger.addHandler((Handler)((Object)fileStreamHandler));
            jmsMessageLoggers.put(string, jMSMessageLogger);
        }
        return (JMSMessageLogger)jmsMessageLoggers.get(string);
    }

    public static JMSSAFMessageLogger findOrCreateJMSSAFMessageLogger(JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean) throws IOException {
        String string = jMSSAFMessageLogFileMBean.getName();
        if (!jmsSAFMessageLoggers.containsKey(string)) {
            JMSSAFMessageLogger jMSSAFMessageLogger = new JMSSAFMessageLogger(string);
            FileStreamHandler fileStreamHandler = new FileStreamHandler(jMSSAFMessageLogFileMBean);
            fileStreamHandler.setFormatter(new JMSMessageLogFileFormatter(jMSSAFMessageLogFileMBean));
            jMSSAFMessageLogger.addHandler((Handler)((Object)fileStreamHandler));
            jmsSAFMessageLoggers.put(string, jMSSAFMessageLogger);
        }
        return (JMSSAFMessageLogger)jmsSAFMessageLoggers.get(string);
    }
}

