/*
 * Decompiled with CFR 0.152.
 */
package weblogic.logging.parsers;

import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import weblogic.logging.parsers.LogLexerTokenTypes;

public class LogLexer
extends CharScanner
implements LogLexerTokenTypes,
TokenStream {
    private static final boolean DEBUG = true;
    private boolean hitEOF = false;

    public void uponEOF() throws TokenStreamException, CharStreamException {
        System.out.println("Reached end of file.");
        this.hitEOF = true;
        super.uponEOF();
    }

    public boolean isEOFReached() {
        return this.hitEOF;
    }

    public LogLexer(InputStream inputStream) {
        this((InputBuffer)new ByteBuffer(inputStream));
    }

    public LogLexer(Reader reader) {
        this((InputBuffer)new CharBuffer(reader));
    }

    public LogLexer(InputBuffer inputBuffer) {
        this(new LexerSharedInputState(inputBuffer));
    }

    public LogLexer(LexerSharedInputState lexerSharedInputState) {
        super(lexerSharedInputState);
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = new Hashtable();
    }

    public Token nextToken() throws TokenStreamException {
        Token token = null;
        while (true) {
            Object var2_2 = null;
            int n = 0;
            this.setCommitToPath(false);
            this.resetText();
            try {
                try {
                    if (this.LA(1) == '#' && this.getColumn() == 1) {
                        this.mBEGIN_LOG_RECORD(true);
                        token = this._returnToken;
                    } else if (this.LA(1) == '<') {
                        this.mLOGFIELD(true);
                        token = this._returnToken;
                    } else if (this.LA(1) == '\uffff') {
                        this.uponEOF();
                        this._returnToken = this.makeToken(1);
                    } else {
                        this.consume();
                        continue;
                    }
                    if (this._returnToken == null) continue;
                    n = this._returnToken.getType();
                    n = this.testLiteralsTable(n);
                    this._returnToken.setType(n);
                    return this._returnToken;
                }
                catch (RecognitionException recognitionException) {
                    if (!this.getCommitToPath()) {
                        this.consume();
                        continue;
                    }
                    throw new TokenStreamRecognitionException(recognitionException);
                }
            }
            catch (CharStreamException charStreamException) {
                if (charStreamException instanceof CharStreamIOException) {
                    throw new TokenStreamIOException(((CharStreamIOException)charStreamException).io);
                }
                throw new TokenStreamException(charStreamException.getMessage());
            }
            break;
        }
    }

    public final void mBEGIN_LOG_RECORD(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 4;
        if (this.getColumn() != 1) {
            throw new SemanticException("getColumn()==1");
        }
        this.match("####");
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }

    public final void mLOGFIELD(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 5;
        int n3 = this.text.length();
        this.mSTART_DELIMITER(false);
        this.text.setLength(n3);
        while (this.LA(1) != '>' || this.LA(2) != ' ') {
            if ((this.LA(1) == '\n' || this.LA(1) == '\r') && this.LA(2) >= '\u0003' && this.LA(2) <= '\u00ff' && this.LA(3) >= '\u0003' && this.LA(3) <= '\u00ff') {
                this.mNEWLINE(false);
                continue;
            }
            if (this.LA(1) == '&' && this.LA(2) == 'l' && this.LA(3) == 't') {
                this.mESCAPED_START(false);
                continue;
            }
            if (this.LA(1) == '&' && this.LA(2) == 'g' && this.LA(3) == 't') {
                this.mESCAPED_END(false);
                continue;
            }
            if (this.LA(1) < '\u0003' || this.LA(1) > '\u00ff' || this.LA(2) < '\u0003' || this.LA(2) > '\u00ff' || this.LA(3) < '\u0003' || this.LA(3) > '\u00ff') break;
            this.matchNot('\uffff');
        }
        n3 = this.text.length();
        this.mEND_DELIMITER(false);
        this.text.setLength(n3);
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }

    protected final void mSTART_DELIMITER(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 9;
        this.match("<");
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }

    protected final void mNEWLINE(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 6;
        switch (this.LA(1)) {
            case '\r': {
                this.match('\r');
                this.match('\n');
                this.newline();
                break;
            }
            case '\n': {
                this.match('\n');
                this.newline();
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }

    protected final void mESCAPED_START(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 7;
        this.match("&lt;");
        this.text.setLength(n);
        this.text.append("<");
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }

    protected final void mESCAPED_END(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 8;
        this.match("&gt;");
        this.text.setLength(n);
        this.text.append(">");
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }

    protected final void mEND_DELIMITER(boolean bl) throws RecognitionException, CharStreamException, TokenStreamException {
        Token token = null;
        int n = this.text.length();
        int n2 = 10;
        this.match("> ");
        if (this.LA(1) == '\n' || this.LA(1) == '\r') {
            this.mNEWLINE(false);
        }
        if (bl && token == null && n2 != -1) {
            token = this.makeToken(n2);
            token.setText(new String(this.text.getBuffer(), n, this.text.length() - n));
        }
        this._returnToken = token;
    }
}

