/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jndi.Environment;
import weblogic.management.MBeanHome;
import weblogic.management.WebLogicObjectName;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ProductionModeHelper;
import weblogic.management.provider.ManagementConstants;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class Admin
implements ManagementConstants {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean isPasswordEchoAllowed = Boolean.getBoolean("weblogic.management.allowPasswordEcho");

    private Admin() {
    }

    public static final Admin getInstance() {
        return AdminSingleton.SINGLETON;
    }

    public static final boolean isAdminServer() {
        return ManagementService.getPropertyService(kernelId).isAdminServer();
    }

    public static boolean isBooting() {
        return ManagementService.getRuntimeAccess(kernelId) != null;
    }

    public static final synchronized String getAdminT3Url() {
        return ManagementService.getPropertyService(kernelId).getAdminBinaryURL();
    }

    public static boolean isConfigLoaded() {
        return ManagementService.getRuntimeAccess(kernelId) != null;
    }

    public boolean isProductionModeEnabled() {
        if (!Admin.isConfigLoaded()) {
            return ProductionModeHelper.getProductionModeProperty();
        }
        return ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled();
    }

    public boolean isPasswordEchoAllowed() {
        return this.isPasswordEchoAllowed;
    }

    public static synchronized void setAdminURL(String string) throws MalformedURLException {
        ManagementService.getPropertyService(kernelId).setAdminHost(string);
    }

    public static final Admin createInstance() {
        throw new UnsupportedOperationException("Admin.createInstance");
    }

    public final ServerMBean getLocalServer() {
        throw new UnsupportedOperationException("Admin.getLocalServer");
    }

    public final DomainMBean getActiveDomain() {
        return this.getMBeanHome().getActiveDomain();
    }

    public final String getDomainName() {
        throw new UnsupportedOperationException("Admin.getDomainName");
    }

    public final MBeanHome getMBeanHome(String string) throws NamingException {
        Environment environment = new Environment();
        Context context = environment.getInitialContext();
        return (MBeanHome)context.lookup("weblogic.management.home." + string);
    }

    public final MBeanHome getMBeanHome() {
        return this.lookupMBeanHome("weblogic.management.home.localhome");
    }

    private MBeanHome lookupMBeanHome(String string) {
        try {
            Context context = new Environment().getInitialContext();
            return (MBeanHome)context.lookup(string);
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)("MBeanHome lookup failed" + namingException));
        }
    }

    public final MBeanHome getAdminMBeanHome() {
        return this.lookupMBeanHome("weblogic.management.adminhome");
    }

    public final DomainMBean getDomain() {
        try {
            WebLogicObjectName webLogicObjectName = new WebLogicObjectName(this.getDomainName(), "Domain", this.getDomainName());
            return (DomainMBean)this.getAdminMBeanHome().getMBean((ObjectName)webLogicObjectName);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public final ServerMBean getServer() {
        try {
            return (ServerMBean)this.getAdminMBeanHome().getAdminMBean(Admin.getServerName(), "Server", this.getDomainName());
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public final URL getAdminURL() {
        return ManagementService.getPropertyService(kernelId).getAdminURL();
    }

    public String getAdminServerName() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain().getAdminServerName();
    }

    public ServerIdentity getAdminIdentity() {
        return LocalServerIdentity.getIdentity();
    }

    private ServerMBean getAdminServerMBean() {
        throw new UnsupportedOperationException("Admin.getAdminServerMBean");
    }

    public int getMasterEmbeddedLDAPPortFromConfig() {
        throw new UnsupportedOperationException("Admin.getMasterEmbeddedLDAPPortFromConfig");
    }

    public boolean isLocalAdminServer() {
        return false;
    }

    public static final synchronized String getAdminHttpUrl() {
        ManagementService.getPropertyService(kernelId);
        return PropertyService.getAdminHttpUrl();
    }

    public static final String getServerName() {
        return ManagementService.getPropertyService(kernelId).getServerName();
    }

    private static final class AdminSingleton {
        private static final Admin SINGLETON = new Admin();

        private AdminSingleton() {
        }
    }
}

