/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.util.Enumeration;
import java.util.Hashtable;
import weblogic.utils.NestedException;

public class ApplicationException
extends NestedException {
    private static final long serialVersionUID = -2538796139370040809L;
    private Hashtable moduleErrors = new Hashtable();
    private Hashtable targetExs = null;
    private String appMessage = "None";

    public ApplicationException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ApplicationException(Exception exception) {
        super((Throwable)exception);
    }

    public ApplicationException(String string) {
        super(string);
        this.appMessage = string;
    }

    public ApplicationException(Hashtable hashtable, String string) {
        super(string);
        this.moduleErrors = hashtable;
    }

    public String getApplicationMessage() {
        return this.appMessage;
    }

    public void addError(String string, String string2) {
        this.moduleErrors.put(string, string2);
    }

    public Hashtable getModuleErrors() {
        return this.moduleErrors;
    }

    public Exception getTargetException(String string) {
        return this.targetExs == null ? null : (Exception)this.targetExs.get(string);
    }

    public void setTargetException(String string, Exception exception) {
        if (this.targetExs == null) {
            this.targetExs = new Hashtable();
        }
        this.targetExs.put(string, exception);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        Hashtable hashtable = this.getModuleErrors();
        if (!hashtable.isEmpty()) {
            stringBuffer.append("\n{");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                stringBuffer.append("\nModule Name: ");
                stringBuffer.append(k);
                stringBuffer.append(", Error: ");
                stringBuffer.append(v);
                Exception exception = this.getTargetException((String)k);
                if (exception == null) continue;
                stringBuffer.append("\n TargetException: " + exception);
            }
            stringBuffer.append("\n}");
        }
        return super.toString() + stringBuffer;
    }
}

