/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.util.Date;
import javax.management.Notification;
import javax.management.ObjectName;

public final class DeploymentNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    private static long sequenceNumber = 0L;
    private String appName = null;
    private String serverName = null;
    private String moduleName = null;
    private String transition = null;
    private String currentState = null;
    private String targetState = null;
    private boolean appNotification = false;
    private boolean moduleNotification = false;
    private String appPhase;
    public static final String PREPARING = "preparing";
    public static final String PREPARED = "prepared";
    public static final String ACTIVATING = "activating";
    public static final String ACTIVATED = "activated";
    public static final String DEACTIVATING = "deactivating";
    public static final String DEACTIVATED = "deactivated";
    public static final String UNPREPARING = "unpreparing";
    public static final String UNPREPARED = "unprepared";
    public static final String FAILED = "failed";
    public static final String DISTRIBUTING = "distributing";
    public static final String DISTRIBUTED = "distributed";
    public static final String TYPE_APPLICATION = "weblogic.deployment.application";
    public static final String TYPE_MODULE = "weblogic.deployment.application.module";
    public static final String TRANSITION_BEGIN = "begin";
    public static final String TRANSITION_END = "end";
    public static final String TRANSITION_FAILED = "failed";
    public static final String STATE_UNPREPARED = "unprepared";
    public static final String STATE_PREPARED = "prepared";
    public static final String STATE_ACTIVE = "active";
    public static final String STATE_START = "start";
    private String task = null;

    public String getTask() {
        return this.task;
    }

    public void setTask(String string) {
        this.task = string;
    }

    public DeploymentNotification(ObjectName objectName, long l, String string, String string2, String string3) {
        super(TYPE_APPLICATION, objectName, l, new Date().getTime(), string3 + "." + string + "." + string2);
        this.appName = string2;
        this.serverName = string;
        this.appNotification = true;
        this.appPhase = string3;
        this.transition = string3.endsWith("ed") ? TRANSITION_END : TRANSITION_BEGIN;
        if (string3.equals(DISTRIBUTING)) {
            this.currentState = STATE_START;
            this.targetState = "unprepared";
        } else if (string3.equals(DISTRIBUTED)) {
            this.currentState = STATE_START;
            this.targetState = "unprepared";
        } else if (string3.equals(PREPARING)) {
            this.currentState = "unprepared";
            this.targetState = "prepared";
        } else if (string3.equals("prepared")) {
            this.currentState = "unprepared";
            this.targetState = "prepared";
        } else if (string3.equals(ACTIVATING)) {
            this.currentState = "prepared";
            this.targetState = STATE_ACTIVE;
        } else if (string3.equals(ACTIVATED)) {
            this.currentState = "prepared";
            this.targetState = STATE_ACTIVE;
        } else if (string3.equals(UNPREPARING)) {
            this.currentState = "prepared";
            this.targetState = "unprepared";
        } else if (string3.equals("unprepared")) {
            this.currentState = "prepared";
            this.targetState = "unprepared";
        } else if (string3.equals("failed")) {
            this.transition = "failed";
        }
    }

    public DeploymentNotification(ObjectName objectName, long l, String string, String string2, String string3, String string4, String string5, String string6, long l2) {
        super(TYPE_MODULE, objectName, l, l2, string + "." + string2 + "." + string3 + "." + string4 + "." + string5 + "." + string6);
        this.appName = string2;
        this.serverName = string;
        this.moduleName = string3;
        this.transition = string4;
        this.currentState = string5;
        this.targetState = string6;
        this.moduleNotification = true;
    }

    public DeploymentNotification(ObjectName objectName, long l, String string, String string2, String string3, String string4, String string5, String string6) {
        this(objectName, l, string, string2, string3, string4, string5, string6, new Date().getTime());
    }

    public static long getChangeNotificationCount() {
        return sequenceNumber;
    }

    private static synchronized long generateSequenceNumber() {
        return sequenceNumber++;
    }

    public String getPhase() {
        return this.appPhase;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTransition() {
        return this.transition;
    }

    public boolean isEndTransition() {
        return TRANSITION_END.equals(this.transition);
    }

    public boolean isBeginTransition() {
        return TRANSITION_BEGIN.equals(this.transition);
    }

    public boolean isFailedTransition() {
        return "failed".equals(this.transition);
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getTargetState() {
        return this.targetState;
    }

    public boolean isAppNotification() {
        return this.appNotification;
    }

    public boolean isModuleNotification() {
        return this.moduleNotification;
    }

    public String toString() {
        return new StringBuffer("[DeploymentNotification: ").append("AppName:").append(this.appName).append(", ModName:").append(this.moduleName).append(", ServerName:").append(this.serverName).append(", ").append(this.transition).append(".").append(this.currentState).append(".").append(this.targetState).append("]").toString();
    }
}

