/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import weblogic.kernel.Kernel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.security.service.SecurityServiceManager;

public final class EncryptionHelper {
    private static EncryptionService encryptor = null;
    private static final byte CLEAR_BYTE = 0;
    private static ClearOrEncryptedService cEncryptor = null;

    public static final String decryptString(byte[] byArray, AuthenticatedSubject authenticatedSubject) throws EncryptionServiceException {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ClearOrEncryptedService clearOrEncryptedService = EncryptionHelper.getCEncryptionService();
        return clearOrEncryptedService.decrypt(new String(byArray));
    }

    public static final byte[] decrypt(byte[] byArray, AuthenticatedSubject authenticatedSubject) throws EncryptionServiceException {
        SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)authenticatedSubject);
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        ClearOrEncryptedService clearOrEncryptedService = EncryptionHelper.getCEncryptionService();
        return clearOrEncryptedService.decryptBytes(byArray);
    }

    public static final byte[] encryptString(String string) throws EncryptionServiceException {
        if (!Kernel.isServer()) {
            throw new EncryptionServiceException("Caller not part of the Server JVM, Access to encrypt passwords is denied");
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        ClearOrEncryptedService clearOrEncryptedService = EncryptionHelper.getCEncryptionService();
        return clearOrEncryptedService.encrypt(string).getBytes();
    }

    public static final byte[] encrypt(byte[] byArray) throws EncryptionServiceException {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        ClearOrEncryptedService clearOrEncryptedService = EncryptionHelper.getCEncryptionService();
        return clearOrEncryptedService.encryptBytes(byArray);
    }

    public static byte[] clear(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    public static boolean isEncrypted(String string) {
        if (string == null) {
            return false;
        }
        ClearOrEncryptedService clearOrEncryptedService = EncryptionHelper.getCEncryptionService();
        return clearOrEncryptedService.isEncrypted(string);
    }

    private static ClearOrEncryptedService getCEncryptionService() {
        if (cEncryptor == null) {
            if (encryptor == null) {
                encryptor = SerializedSystemIni.getExistingEncryptionService();
            }
            cEncryptor = new ClearOrEncryptedService(encryptor);
        }
        return cEncryptor;
    }
}

