/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.store.SystemProperties;
import weblogic.utils.collections.EnumerationIterator;
import weblogic.utils.collections.PropertiesHelper;

public class SpecialPropertiesHelper {
    private static Set specialProperties = new HashSet();
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    public static final String PRODUCTION_MODE_ENABLED_PROP = "weblogic.ProductionModeEnabled";
    public static final String MBEAN_AUDITING_ENABLED_PROP = "weblogic.AdministrationMBeanAuditingEnabled";
    public static final String LEGAL_BYPASS_ON_PARSING_PROP = "weblogic.mbeanLegalClause.ByPass";
    public static final String ADMIN_SSLTRUSTCA_PROP = "weblogic.security.SSL.trustedCAKeyStore";
    public static final String SAVE_DOMAIN_INTERVAL_PROP = "weblogic.management.saveDomainMillis";
    static final String WLEC_TIMEOUT_PROP = "weblogic.CORBA.connectionPoolSoTimeout";
    static final String ADMIN_CONFIGFILE_PROP = "weblogic.ConfigFile";
    static final String ADMIN_DEBUGCATEGORY_PROP = "Debug";
    static final String ADMIN_DEBUGFILTER_PROP = "DebugFilter";
    static final String ADMIN_GEN_DEFAULT_CONFIG_PROP = "weblogic.management.GenerateDefaultConfig";
    static final String ADMIN_HOME_PROP = "weblogic.home";
    static final String ADMIN_SSLDEBUG1_PROP = "ssl.debug";
    static final String ADMIN_SSLDEBUG2_PROP = "weblogic.security.SSL.verbose";
    static final String ADMIN_SSLDEBUG3_PROP = "weblogic.security.ssl.verbose";
    static final String ADMIN_SSLHOSTNAMEVER_IGNORE1_PROP = "weblogic.security.SSL.ignoreHostnameVerification";
    static final String ADMIN_SSLHOSTNAMEVER_IGNORE2_PROP = "weblogic.security.SSL.ignoreHostnameVerify";
    static final String ADMIN_SSLHOSTNAMEVER_CLASS_PROP = "weblogic.security.SSL.hostnameVerifier";
    public static final String ADMIN_SSL_MINIMUM_PROTOCOL_VERSION_PROP = "weblogic.security.SSL.minimumProtocolVersion";
    public static final String ADMIN_SSLVERSION_PROP = "weblogic.security.SSL.protocolVersion";
    public static final String ADMIN_SSLENFORCECONSTRAINT_PROP = "weblogic.security.SSL.enforceConstraints";
    public static final String ADMIN_ROLEMAPPERFACTORY_PROP = "weblogic.security.jacc.RoleMapperFactory.provider";
    public static final String ADMIN_ANONYMOUSADMINLOOKUPENABLED_PROP = "weblogic.management.anonymousAdminLookupEnabled";
    public static final String ADMIN_CLEAR_TEXT_CREDENTIAL_ACCESS_ENABLED = "weblogic.management.clearTextCredentialAccessEnabled";
    public static final String ADMIN_IACACHETTL_PROP = "weblogic.security.identityAssertionTTL";
    static final String DOMAIN_PROP = "Domain";
    static final String NAME_PROP = "Name";
    static final String STORE_BOOT_IDENTITY_PROP = "weblogic.system.StoreBootIdentity";
    static final String BOOT_IDENTITY_FILE_PROP = "weblogic.system.BootIdentityFile";
    static final String REMOVE_BOOT_IDENTITY_PROP = "weblogic.system.RemoveBootIdentity";
    static final String NODE_MANAGER_BOOT_PROP = "weblogic.system.NodeManagerBoot";
    static final String FULLY_DELEGATE_AUTH_PROP = "weblogic.security.fullyDelegateAuthorization";
    static final String ADMIN_ANON_USERNAME_PROP = "weblogic.security.anonymousUserName";
    static final String ENTITY_EXPANSION_LIMIT_PROP = "weblogic.apache.xerces.maxentityrefs";
    public static final String ADMIN_HIERARCHY_GROUP_PROP = "weblogic.security.hierarchyGroupMemberships";
    public static final String LDAP_DELEGATE_POOL_SIZE_PROP = "weblogic.security.providers.authentication.LDAPDelegatePoolSize";
    public static final String SECURITY_FW_SUBJECT_MANAGER_CLASS_NAME_PROP = "weblogic.security.SubjectManager";
    public static final String SECURITY_FW_DELEGATE_CLASS_NAME_PROP = "weblogic.security.SecurityServiceManagerDelegate";
    static final String WTC_TRACELEVEL = "weblogic.wtc.TraceLevel";
    static final String WTC_PASSWORDKEY = "weblogic.wtc.PasswordKey";
    static final String CLASSLOADER_PREPROCESSOR = "weblogic.classloader.preprocessor";
    static final String OCI_SELECT_BLOB_CHUNKSIZE = "weblogic.oci.selectBlobChunkSize";
    static final String NUMBER_POSIX_SOCKET_READERS = "weblogic.PosixSocketReaders";
    static final String USE_EXTENTED_SESSION_FORMAT = "weblogic.servlet.useExtendedSessionFormat";
    static final String WEBSERVICE_I18N_CHARSET = "weblogic.webservice.i18n.charset";
    static final String WEBSERVICE_SSL_TRUSTEDCERTFILE = "weblogic.webservice.client.ssl.trustedcertfile";
    static final String NODEMANAGER_SERVICE_ENABLED = "weblogic.nodemanager.ServiceEnabled";
    public static final String WEBSS_VERBOSE = "weblogic.webservice.verbose";
    public static final String DIABLO_BEANTREE_ENABLED = "weblogic.internal.beantree";
    public static final String ADMIN_USERNAME_PROP = "weblogic.management.username";
    public static final String ADMIN_PASSWORD_PROP = "weblogic.management.password";
    public static final String ADMIN_PKPASSWORD_PROP = "weblogic.management.pkpassword";
    public static final String ADMIN_HOST_PROP = "weblogic.management.server";
    public static final String OLD_ADMIN_HOST_PROP = "weblogic.admin.host";
    static final String OPTIONAL_PACKAGE_PROP = "weblogic.application.RequireOptionalPackages";
    static final String J2EE_TMP_DIR = "weblogic.j2ee.application.tmpDir";
    static final String WEBSERVICE_CERTFILE = "webservice.client.ssl.trustedcertfile";
    public static final String ADMIN_ALLOWPWD_ECHO = "weblogic.management.allowPasswordEcho";
    public static final String ADMIN_AUDITLOG_DIR = "weblogic.security.audit.auditLogDir";
    public static final String REGISTER_X509_CERTIFICATE_FACTORY = "weblogic.security.RegisterX509CertificateFactory";
    public static final String MESSAGE_LOG_NON_DURABLE_PROP = "weblogic.jms.message.logging.logNonDurableSubscriber";
    public static final String MESSAGE_LOG_DESTINATIONS_ALL_PROP = "weblogic.jms.message.logging.destinations.all";
    public static final String SECURITY_CHECK_INTERVAL_PROP = "weblogic.jms.securityCheckInterval";
    public static final String MULTICAST_SEND_DELAY_PROP = "weblogic.jms.extensions.multicast.sendDelay";
    public static final String JMX_REMOTE_REQUEST_TIMEOUT = "weblogic.management.jmx.remote.requestTimeout";
    public static final String CONVERT_SECURITY_EXTENSION_SCHEMA = "weblogic.management.convertSecurityExtensionSchema";

    public static void configureFromSystemProperties(ServerMBean serverMBean) {
        SpecialPropertiesHelper.configureFromSystemProperties(serverMBean, false, false);
    }

    public static void configureFromSystemProperties(ServerMBean serverMBean, boolean bl, boolean bl2) {
        Properties properties = System.getProperties();
        EnumerationIterator enumerationIterator = new EnumerationIterator(properties.propertyNames());
        while (enumerationIterator.hasNext()) {
            String string = (String)enumerationIterator.next();
            if (string.equalsIgnoreCase(MBEAN_AUDITING_ENABLED_PROP)) {
                ((DomainMBean)serverMBean.getParent()).setAdministrationMBeanAuditingEnabled(Boolean.getBoolean(MBEAN_AUDITING_ENABLED_PROP));
                continue;
            }
            String string2 = string.toLowerCase(Locale.US);
            String string3 = null;
            ConfigurationMBean configurationMBean = serverMBean;
            if (string2.equals("weblogic.class.path") || specialProperties.contains(string) || SystemProperties.isSpecialFileStoreProperty((String)string2)) continue;
            if (string2.startsWith("weblogic.debug.")) {
                string3 = string.substring("weblogic.debug.".length());
                configurationMBean = serverMBean.getServerDebug();
            } else if (string2.startsWith("weblogic.ssl.")) {
                string3 = string.substring("weblogic.ssl.".length());
                configurationMBean = serverMBean.getSSL();
            } else if (string2.startsWith("weblogic.log.")) {
                string3 = string.substring("weblogic.log.".length());
                configurationMBean = serverMBean.getLog();
            } else if (string2.startsWith("weblogic.") && !string2.startsWith("weblogic.cluster.")) {
                string3 = string.substring("weblogic.".length());
                if (string3.equals("Cluster") && bl) continue;
                configurationMBean = serverMBean;
            } else if (string2.startsWith("weblogic.cluster.") && !bl) {
                string3 = string.substring("weblogic.cluster.".length());
                if (serverMBean.getCluster() == null) {
                    if (!bl2) continue;
                    ManagementLogger.logClusterPropertyIgnoreBecauseNoClusterConfigured((String)string);
                    continue;
                }
                configurationMBean = serverMBean.getCluster();
            }
            if (string3 == null || specialProperties.contains(string3)) continue;
            try {
                Method[] methodArray = configurationMBean.getClass().getMethods();
                boolean bl3 = false;
                for (int i = 0; i < methodArray.length; ++i) {
                    Class<?>[] classArray = methodArray[i].getParameterTypes();
                    if (!methodArray[i].getName().startsWith("set") || classArray.length != 1 || !methodArray[i].getName().substring(3).equals(string3)) continue;
                    String string4 = (String)properties.get(string);
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("setting from command line [" + string3 + "=" + string4 + "] on " + configurationMBean.getType() + "{" + configurationMBean.getName() + "}");
                    }
                    Object[] objectArray = new Object[1];
                    Class<?> clazz = classArray[0];
                    if (clazz == Boolean.TYPE) {
                        objectArray[0] = new Boolean(string4);
                    } else if (clazz == Character.TYPE) {
                        objectArray[0] = new Character(string4.charAt(0));
                    } else if (clazz == Byte.TYPE) {
                        objectArray[0] = new Byte(string4);
                    } else if (clazz == Short.TYPE) {
                        objectArray[0] = new Short(string4);
                    } else if (clazz == Integer.TYPE) {
                        objectArray[0] = new Integer(string4);
                    } else if (clazz == Long.TYPE) {
                        objectArray[0] = new Long(string4);
                    } else if (clazz == Float.TYPE) {
                        objectArray[0] = new Float(string4);
                    } else if (clazz == Double.TYPE) {
                        objectArray[0] = new Double(string4);
                    } else if (clazz == String.class) {
                        objectArray[0] = string4;
                    } else if (clazz == Properties.class) {
                        objectArray[0] = PropertiesHelper.parse((String)string4);
                    } else if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("UNKNOWN TYPE: " + clazz);
                    }
                    bl3 = true;
                    methodArray[i].invoke((Object)configurationMBean, objectArray);
                }
                if (bl3 || !bl2) continue;
                ManagementLogger.logUnrecognizedProperty((String)string);
            }
            catch (Exception exception) {
                ManagementLogger.logErrorSettingAttribute((String)string3, (Throwable)exception);
            }
        }
    }

    static {
        specialProperties.add(ADMIN_PKPASSWORD_PROP);
        specialProperties.add(ADMIN_PASSWORD_PROP);
        specialProperties.add(ADMIN_USERNAME_PROP);
        specialProperties.add(DOMAIN_PROP);
        specialProperties.add(NAME_PROP);
        specialProperties.add(ADMIN_DEBUGCATEGORY_PROP);
        specialProperties.add(ADMIN_DEBUGFILTER_PROP);
        specialProperties.add(ADMIN_HOST_PROP);
        specialProperties.add(OLD_ADMIN_HOST_PROP);
        specialProperties.add(WLEC_TIMEOUT_PROP);
        specialProperties.add(PRODUCTION_MODE_ENABLED_PROP);
        specialProperties.add(MBEAN_AUDITING_ENABLED_PROP);
        specialProperties.add(ADMIN_GEN_DEFAULT_CONFIG_PROP);
        specialProperties.add(ADMIN_HOME_PROP);
        specialProperties.add(SAVE_DOMAIN_INTERVAL_PROP);
        specialProperties.add("weblogic.debug.DebugScopes");
        specialProperties.add(STORE_BOOT_IDENTITY_PROP);
        specialProperties.add(BOOT_IDENTITY_FILE_PROP);
        specialProperties.add(REMOVE_BOOT_IDENTITY_PROP);
        specialProperties.add(NODE_MANAGER_BOOT_PROP);
        specialProperties.add(LEGAL_BYPASS_ON_PARSING_PROP);
        specialProperties.add(FULLY_DELEGATE_AUTH_PROP);
        specialProperties.add(ADMIN_ANON_USERNAME_PROP);
        specialProperties.add(ADMIN_SSLDEBUG1_PROP);
        specialProperties.add(ADMIN_SSLDEBUG2_PROP);
        specialProperties.add(ADMIN_SSLDEBUG3_PROP);
        specialProperties.add(ADMIN_SSLHOSTNAMEVER_IGNORE1_PROP);
        specialProperties.add(ADMIN_SSLHOSTNAMEVER_IGNORE2_PROP);
        specialProperties.add(ADMIN_SSLHOSTNAMEVER_CLASS_PROP);
        specialProperties.add(ADMIN_SSLTRUSTCA_PROP);
        specialProperties.add(ADMIN_SSLVERSION_PROP);
        specialProperties.add(ADMIN_SSLENFORCECONSTRAINT_PROP);
        specialProperties.add(ADMIN_ROLEMAPPERFACTORY_PROP);
        specialProperties.add(ADMIN_ANONYMOUSADMINLOOKUPENABLED_PROP);
        specialProperties.add(ADMIN_IACACHETTL_PROP);
        specialProperties.add(ADMIN_CONFIGFILE_PROP);
        specialProperties.add(WTC_TRACELEVEL);
        specialProperties.add(WTC_PASSWORDKEY);
        specialProperties.add(CLASSLOADER_PREPROCESSOR);
        specialProperties.add(OCI_SELECT_BLOB_CHUNKSIZE);
        specialProperties.add(NUMBER_POSIX_SOCKET_READERS);
        specialProperties.add(ADMIN_HIERARCHY_GROUP_PROP);
        specialProperties.add(OPTIONAL_PACKAGE_PROP);
        specialProperties.add(JMX_REMOTE_REQUEST_TIMEOUT);
        specialProperties.add(CONVERT_SECURITY_EXTENSION_SCHEMA);
        specialProperties.add("weblogic.security.TrustKeyStore");
        specialProperties.add("weblogic.security.CustomTrustKeyStoreFileName");
        specialProperties.add("weblogic.security.CustomTrustKeyStoreType");
        specialProperties.add("weblogic.security.CustomTrustKeyStorePassPhrase");
        specialProperties.add("weblogic.security.JavaStandardTrustKeyStorePassPhrase");
        specialProperties.add(NODEMANAGER_SERVICE_ENABLED);
        specialProperties.add(ENTITY_EXPANSION_LIMIT_PROP);
        specialProperties.add(USE_EXTENTED_SESSION_FORMAT);
        specialProperties.add(WEBSERVICE_I18N_CHARSET);
        specialProperties.add(WEBSERVICE_SSL_TRUSTEDCERTFILE);
        specialProperties.add(SECURITY_FW_SUBJECT_MANAGER_CLASS_NAME_PROP);
        specialProperties.add(SECURITY_FW_DELEGATE_CLASS_NAME_PROP);
        specialProperties.add(WEBSS_VERBOSE);
        specialProperties.add(DIABLO_BEANTREE_ENABLED);
        specialProperties.add(LDAP_DELEGATE_POOL_SIZE_PROP);
        specialProperties.add(MESSAGE_LOG_DESTINATIONS_ALL_PROP);
        specialProperties.add(MESSAGE_LOG_NON_DURABLE_PROP);
        specialProperties.add(SECURITY_CHECK_INTERVAL_PROP);
        specialProperties.add(MULTICAST_SEND_DELAY_PROP);
        SystemProperties.register((Set)specialProperties);
        specialProperties.add("weblogic.messaging.kernel.persistence.InLineBodyThreshold");
        specialProperties.add("weblogic.messaging.kernel.persistence.PageInOnBoot");
        specialProperties.add("weblogic.messaging.kernel.paging.AlwaysUsePagingStore");
        specialProperties.add("weblogic.messaging.kernel.paging.BatchSize");
        specialProperties.add("weblogic.messaging.kernel.paging.PagedMessageThreshold");
        specialProperties.add("weblogic.ForceImplicitUpgradeIfNeeded");
        specialProperties.add("weblogic.diagnostics.instrumentation");
        specialProperties.add(J2EE_TMP_DIR);
        specialProperties.add(ADMIN_ALLOWPWD_ECHO);
        specialProperties.add(WEBSERVICE_CERTFILE);
        specialProperties.add(ADMIN_AUDITLOG_DIR);
        specialProperties.add(REGISTER_X509_CERTIFICATE_FACTORY);
        specialProperties.add(ADMIN_CLEAR_TEXT_CREDENTIAL_ACCESS_ENABLED);
    }
}

