/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management;

import weblogic.management.SpecialPropertiesHelper;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.ConfigLogger;
import weblogic.management.internal.Utils;
import weblogic.management.provider.UpdateException;

public class SpecialPropertiesProcessor {
    public static void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        boolean bl;
        String string = Utils.findServerName(domainMBean);
        if (string == null) {
            throw new UpdateException(ConfigLogger.logCouldNotDetermineServerNameLoggable().getMessage());
        }
        ServerMBean serverMBean = domainMBean.lookupServer(string);
        if (serverMBean == null) {
            throw new UpdateException(ConfigLogger.logServerNameNotFoundLoggable((String)string, (String)domainMBean.getName()).getMessage());
        }
        boolean bl2 = bl = serverMBean.getCluster() != null;
        if (bl) {
            SpecialPropertiesHelper.configureFromSystemProperties(serverMBean, bl, false);
        } else {
            SpecialPropertiesHelper.configureFromSystemProperties(serverMBean);
        }
    }
}

