/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.util.Locale;
import weblogic.common.T3Client;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.Kernel;
import weblogic.management.NoAccessException;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.tools.AdminConfigCommandLineInvoker;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.commandline.tools.ClusterAdminCommandLineInvoker;
import weblogic.management.commandline.tools.JDBCCommandLineInvoker;
import weblogic.management.commandline.tools.MBeanCommandLineInvoker;
import weblogic.management.commandline.tools.ServerAdminCommandLineInvoker;
import weblogic.management.commandline.tools.ServerInfoCommandLineInvoker;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.security.internal.encryption.EncryptionServiceException;

public class AdminMain {
    private static final AuditableThreadLocal outputStream = AuditableThreadLocalFactory.createThreadLocal();
    static CommandLineArgs params = null;
    static AdminToolHelper toolHelper = null;
    static T3Client t3 = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Throwable {
        try {
            params = new CommandLineArgs(stringArray);
            toolHelper = new AdminToolHelper(params);
            if (stringArray.length == 0) {
                AdminMain.usage();
                throw new Exception();
            }
            if (!Kernel.isServer() && params.getOperation() != 41) {
                toolHelper.evaluateCredentials();
                if (params.getUsername() == null & params.getPassword() == null || params.getUsername().length() == 0 & params.getPassword().length() == 0) {
                    int n = params.getOperation();
                    if (n == 0 || n == 1 || n == 20 || n > 99) {
                        AdminMain.usage();
                        throw new Exception();
                    }
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    AdminMain.getOutputStream().println(managementTextTextFormatter.getNoUserNameNoPassword());
                    AdminMain.usage();
                    throw new Exception();
                }
                if (params.getUsername() == null) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    AdminMain.getOutputStream().println(managementTextTextFormatter.getNoUserNameNoPassword());
                    AdminMain.usage();
                    throw new Exception();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AdminToolHelper.printErrorMessage(illegalArgumentException.getMessage(), true);
            AdminMain.usage();
            throw illegalArgumentException;
        }
        catch (EncryptionServiceException encryptionServiceException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            AdminMain.getOutputStream().println(managementTextTextFormatter.getEncryptionError());
            AdminMain.userconfigusage();
            throw encryptionServiceException;
        }
        int n = 1;
        n = params.getOperation();
        try {
            switch (n) {
                case 20: {
                    AdminMain.showHelp();
                    return;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 18: 
                case 19: 
                case 28: {
                    new ServerInfoCommandLineInvoker(params, AdminMain.getOutputStream());
                    return;
                }
                case 29: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    new MBeanCommandLineInvoker(params, AdminMain.getOutputStream());
                    return;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 38: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    new JDBCCommandLineInvoker(params, AdminMain.getOutputStream());
                    return;
                }
                case 4: 
                case 8: 
                case 9: 
                case 11: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: 
                case 42: 
                case 43: {
                    new ServerAdminCommandLineInvoker(params, AdminMain.getOutputStream());
                    return;
                }
                case 37: 
                case 39: 
                case 40: 
                case 41: 
                case 50: 
                case 52: {
                    new ClusterAdminCommandLineInvoker(params, AdminMain.getOutputStream());
                    return;
                }
                case 51: {
                    new AdminConfigCommandLineInvoker(params, AdminMain.getOutputStream());
                    return;
                }
                default: {
                    AdminMain.usage();
                    return;
                }
            }
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
            if (throwable instanceof NoAccessException) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    System.out.println(managementTextTextFormatter.getAuthError());
                    AdminToolHelper.printDone = true;
                }
            }
            if (!params.isNoExit()) throw undeclaredThrowableException;
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ClassCastException) {
                return;
            }
            if (params.isVerbose()) {
                throwable.printStackTrace();
            } else if (!AdminToolHelper.printDone) {
                if (throwable.getMessage() != null && throwable.getMessage().length() != 0) {
                    AdminToolHelper.printErrorMessage(throwable.getMessage(), true);
                } else {
                    throwable.printStackTrace();
                }
            }
            if (!params.isNoExit()) throw throwable;
            return;
        }
        finally {
            if (t3 != null && t3.isConnected()) {
                t3.disconnect();
            }
        }
    }

    static void usage() {
        AdminMain.getOutputStream().println(CommandLineArgs.getUsageString(false));
    }

    static void userconfigusage() {
        AdminMain.getOutputStream().println(CommandLineArgs.getUsageString(true));
    }

    private static void showHelp() throws IllegalArgumentException, MalformedURLException {
        String string = toolHelper.nextArg("", 0);
        if (string.equals("")) {
            AdminMain.usage();
            return;
        }
        string = string.toUpperCase(Locale.US);
        System.out.println(CommandLineArgs.getUsageString(string, false));
    }

    public static final void setOutputStream(OutputStream outputStream) {
        AdminMain.outputStream.set((Object)new PrintStream(outputStream));
    }

    private static final PrintStream getOutputStream() {
        PrintStream printStream = (PrintStream)outputStream.get();
        return printStream == null ? System.out : printStream;
    }
}

