/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline;

import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.kernel.Kernel;
import weblogic.management.MBeanHome;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commandline.ANFE;
import weblogic.management.commandline.CommandDescription;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.commandline.tools.MBeanCommandLineInvoker;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.provider.ManagementServiceClient;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.utils.TypeConversionUtils;
import weblogic.utils.io.TerminalIO;

public final class CommandLineArgs {
    public static final int NONE = 1;
    public static final int PING = 2;
    public static final int STAT = 3;
    public static final int SHUT = 4;
    public static final int LICENCES = 5;
    public static final int VERSION = 6;
    public static final int CONNECT = 7;
    public static final int LOCK = 8;
    public static final int UNLOCK = 9;
    public static final int LIST = 10;
    public static final int CANCEL_SHUT = 11;
    public static final int RESET_POOL = 12;
    public static final int CREATE_POOL = 13;
    public static final int REMOVE_POOL = 14;
    public static final int ENABLE_POOL = 15;
    public static final int DISABLE_POOL = 16;
    public static final int EXISTS_POOL = 17;
    public static final int THREAD_DUMP = 18;
    public static final int LOG_OPERATION = 19;
    public static final int HELP_OPERATION = 20;
    public static final int START = 21;
    public static final int STARTINSTANDBY = 22;
    public static final int SUSPEND = 23;
    public static final int FORCESUSPEND = 24;
    public static final int RESUME = 25;
    public static final int SHUTDOWN = 26;
    public static final int FORCESHUTDOWN = 27;
    public static final int GETSTATE = 28;
    public static final int QUERY_OPERATION = 29;
    public static final int GET_OPERATION = 31;
    public static final int SET_OPERATION = 32;
    public static final int CREATE_OPERATION = 33;
    public static final int DELETE_OPERATION = 34;
    public static final int INVOKE_OPERATION = 35;
    public static final int BATCHUPDATE_OPERATION = 36;
    public static final int CLUSTERSTATE = 37;
    public static final int TEST_POOL = 38;
    public static final int STARTCLUSTER = 39;
    public static final int STOPCLUSTER = 40;
    public static final int VALIDATECLUSTERCONFIG = 41;
    public static final int CONVERTPROPS = 42;
    public static final int DISCOVERMANAGEDSERVER = 43;
    public static final int SUSPEND_POOL = 44;
    public static final int SHUTDOWN_POOL = 45;
    public static final int RESUME_POOL = 46;
    public static final int DELETE_POOL = 47;
    public static final int DESTROY_POOL = 48;
    public static final int MIGRATE_OPERATION = 50;
    public static final int STORE_USER_CONFIG = 51;
    public static final int MIGRATE_SERVER_OPERATION = 52;
    public static final int MIGRATE_ALL_OPERATION = 53;
    public static final int ALL = 100;
    public static final int SERVERINFO = 101;
    public static final int LIFECYCLE = 102;
    public static final int JDBC = 103;
    public static final int MBEAN = 104;
    public static final int CLUSTER = 105;
    public static final int ADMINCONFIG = 106;
    static final String DEFAULT_URL = "t3://localhost:7001";
    public static final String IGNORE_SESSIONS = "-ignoreExistingSessions";
    public static final String TIMEOUT = "-timeout";
    public boolean isIIOP = false;
    private static final int MBEAN_OPERATION_START = 30;
    static Hashtable cmds = new Hashtable();
    static Hashtable infoCmds = new Hashtable();
    static Hashtable serverSpecificCmds = new Hashtable();
    static Hashtable poolCmds = new Hashtable();
    static Hashtable mbeanCmds = new Hashtable();
    static Hashtable clusterCmds = new Hashtable();
    static Hashtable adminConfigCmds = new Hashtable();
    private static String operationString = null;
    private String url = "t3://localhost:7001";
    private String username = null;
    private String password = null;
    private String userconfigfile = null;
    private String userkeyfile = null;
    private int operation = 0;
    private String mBeanObjName;
    private String mbeanType;
    private boolean pretty = false;
    private boolean exclude = true;
    private boolean verbose = false;
    private boolean isURLset = false;
    private boolean isTimeoutSet = false;
    private AttributeList attribList = new AttributeList();
    private String methodName;
    private String domainName = null;
    private Vector methodArguments;
    private String newMBeanName = null;
    private String migratableTargetName;
    private String singletonServiceName;
    private String migratableServerName;
    private String destinationServerName;
    private String migratableServerDestinationMachineName;
    private String sourceServer;
    private boolean migrateJTA;
    private boolean sourceDown;
    private boolean destinationDown;
    private boolean commoType = false;
    private String pattern;
    private String batchFile = null;
    private boolean continueOnErr = false;
    private boolean showNoMessages = false;
    private boolean batchCmd = false;
    private String clusterName = null;
    private String configPath = null;
    private String adminUrl = null;
    private boolean ignoreSessions = false;
    private int timeout = 0;
    private boolean batchCmdVerbose = false;
    private String serverPropertiesDir = null;
    private String clusterPropertiesDir = null;
    private String outputDir = null;
    private String serverName = null;
    private String newDomainName = null;
    private String usernamePwdLocation = null;
    private String listenAdress = null;
    private String listenPort = null;
    private boolean listenPortSecure = false;
    private boolean usingBootProperties = false;
    public static boolean typeMunged = false;
    private String poolName = null;
    private boolean noExit = false;
    private Vector positionalArgs = new Vector();
    private MBeanHome adminHome = null;
    private WebLogicMBean mbean = null;
    private MBeanInfo info = null;
    BeanInfoAccess beanInfoAccess = null;
    private static final String ADMIN_CONFIG_PKG_NAME = "weblogic.management.configuration";

    public CommandLineArgs(String[] stringArray) throws IllegalArgumentException {
        this(null, null, null, stringArray);
    }

    public CommandLineArgs(String string, String string2, String string3, String[] stringArray) throws IllegalArgumentException {
        this.username = string;
        this.password = string2;
        if (string3 != null) {
            this.url = string3;
        }
        this.processArgs(stringArray);
        this.postProcessArgs();
    }

    public boolean continueOnError() {
        return this.continueOnErr;
    }

    public boolean isBatchCmdVerbose() {
        return this.batchCmdVerbose;
    }

    public boolean showNoMessages() {
        return this.showNoMessages;
    }

    public boolean exclude() {
        return this.exclude;
    }

    public boolean isIIOP() {
        return this.isIIOP;
    }

    public boolean isListenPortSecure() {
        return this.listenPortSecure;
    }

    public String getListenPort() {
        return this.listenPort;
    }

    public String getListenAddress() {
        return this.listenAdress;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getAdminUrl() {
        if (this.adminUrl != null) {
            int n = this.adminUrl.indexOf("//");
            if (n > 0 && this.adminUrl.charAt(n - 1) == ':') {
                return this.adminUrl;
            }
            if (n == 0) {
                return "t3:" + this.adminUrl;
            }
            return "t3://" + this.adminUrl;
        }
        return this.adminUrl;
    }

    public String getUsernamePasswordLocation() {
        return this.usernamePwdLocation;
    }

    public CommandDescription getCommandDescription(String string) {
        return (CommandDescription)cmds.get(string.toUpperCase());
    }

    public String toString() {
        return "url: " + this.url + "\nusername: " + this.username + "\npassword: " + this.password + "\noperation: " + this.operation + "\nmBeanObjName: " + this.mBeanObjName + "\nmbeanType: " + this.mbeanType + "\nnewMBeanName: " + this.newMBeanName + "\npretty: " + this.pretty + "\nexclude: " + this.exclude + "\nattribList: " + this.getStringAttribList(this.attribList) + "\nmethodName: " + this.methodName + "\ndomainName: " + this.domainName + "\nmethodArguments: " + this.methodArguments;
    }

    static void addCmd(String string, int n, String string2, String string3, boolean bl, String string4, String string5) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, bl, string4, string5, "");
        cmds.put(string, commandDescription);
    }

    static void addCmd(String string, int n, String string2, String string3, String string4, String string5, String string6) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6);
        cmds.put(string, commandDescription);
    }

    static void addCmd(String string, int n, String string2, String string3, String string4, String string5) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, "");
        cmds.put(string, commandDescription);
    }

    static void addInfoCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2);
        infoCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addInfoCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2, string7);
        infoCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addServerSpecificCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2);
        serverSpecificCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addServerSpecificCmd(String string, int n, String string2, String string3, boolean bl, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, bl, string4, string5, string6, n2);
        serverSpecificCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addServerSpecificCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2, string7);
        serverSpecificCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addPoolCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2);
        poolCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addPoolCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2, string7);
        poolCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addMBeanCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2);
        mbeanCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addMBeanCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2, string7);
        mbeanCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addClusterCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2);
        clusterCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addClusterCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2, string7);
        clusterCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    static void addAdminConfigCmd(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        CommandDescription commandDescription = new CommandDescription(string, n, string2, string3, true, string4, string5, string6, n2);
        adminConfigCmds.put(string, commandDescription);
        cmds.put(string, commandDescription);
    }

    boolean populateOperation(String[] stringArray, int n, String string) throws ANFE {
        String string2 = null;
        string2 = stringArray[n].startsWith("-") ? stringArray[n].substring(1) : stringArray[n];
        if (string2.equalsIgnoreCase(string)) {
            this.operation = ((CommandDescription)cmds.get(string.toUpperCase())).getCommandId();
            if (this.operation == 20 && stringArray.length > 1) {
                string2 = stringArray[1].startsWith("-") ? stringArray[1].substring(1) : stringArray[1];
            }
            operationString = string2;
            return true;
        }
        throw new ANFE();
    }

    void postProcessArgs() throws IllegalArgumentException {
        if (33 != this.getOperation() && 34 != this.getOperation()) {
            if (null != this.getNewMBeanName()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                throw new IllegalArgumentException(managementTextTextFormatter.getPostProcessArgsMBeanNameError(this.getNewMBeanName()));
            }
            if (null != this.getDomainName()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                throw new IllegalArgumentException(managementTextTextFormatter.getPostProcessArgsDomainNameError(this.getDomainName()));
            }
        }
        if (this.getOperation() == 50) {
            if (this.getMigratableTargetName() == null && this.getSingletonServiceName() == null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                throw new IllegalArgumentException(managementTextTextFormatter.getPostProcessArgsTargetError());
            }
            if (this.getDestinationServerName() == null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                throw new IllegalArgumentException(managementTextTextFormatter.getPostProcessArgsDestinationError());
            }
        }
        if (this.getOperation() == 52) {
            if (this.getMigratableServerName() == null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                throw new IllegalArgumentException(managementTextTextFormatter.getPostProcessArgsMigratableServerError());
            }
            if (this.getDestinationMachineName() == null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                throw new IllegalArgumentException(managementTextTextFormatter.getPostProcessArgsDestinationMachineError());
            }
        }
    }

    void processArgs(String[] stringArray) throws IllegalArgumentException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("commotype")) continue;
            this.commoType = true;
            break;
        }
        int n = 0;
        Object object = null;
        while (n < stringArray.length) {
            try {
                this.url = this.getParameter(stringArray, n, "-url");
                ++n;
                ++n;
                if (this.url.startsWith("iiop")) {
                    this.isIIOP = true;
                }
                this.isURLset = true;
            }
            catch (ANFE aNFE) {
                try {
                    this.username = this.getParameter(stringArray, n, "-username");
                    ++n;
                    ++n;
                }
                catch (ANFE aNFE2) {
                    try {
                        this.password = this.getParameter(stringArray, n, "-password");
                        ++n;
                        ++n;
                    }
                    catch (ANFE aNFE3) {
                        try {
                            this.mbeanType = this.getParameter(stringArray, n, "-type");
                            ++n;
                            ++n;
                            typeMunged = false;
                        }
                        catch (ANFE aNFE4) {
                            try {
                                this.migratableTargetName = this.getParameter(stringArray, n, "-migratabletarget");
                                ++n;
                                ++n;
                            }
                            catch (ANFE aNFE5) {
                                try {
                                    this.singletonServiceName = this.getParameter(stringArray, n, "-singletonservice");
                                    ++n;
                                    ++n;
                                }
                                catch (ANFE aNFE6) {
                                    try {
                                        this.migratableServerName = this.getParameter(stringArray, n, "-migratableserver");
                                        ++n;
                                        ++n;
                                    }
                                    catch (ANFE aNFE7) {
                                        try {
                                            this.migratableServerDestinationMachineName = this.getParameter(stringArray, n, "-destinationmachine");
                                            ++n;
                                            ++n;
                                        }
                                        catch (ANFE aNFE8) {
                                            try {
                                                this.destinationServerName = this.getParameter(stringArray, n, "-destination");
                                                ++n;
                                                ++n;
                                            }
                                            catch (ANFE aNFE9) {
                                                Object object2;
                                                try {
                                                    this.mBeanObjName = this.getParameter(stringArray, n, "-mbean");
                                                    ++n;
                                                    ++n;
                                                    try {
                                                        if (this.mbeanType != null) continue;
                                                        typeMunged = true;
                                                        this.mbeanType = this.getTypeFromObj(this.mBeanObjName);
                                                    }
                                                    catch (MalformedObjectNameException malformedObjectNameException) {
                                                        object2 = new ManagementTextTextFormatter();
                                                        throw new IllegalArgumentException(object2.getProcessArgsMBeanNameError(stringArray[n - 1], n + 1 - 1));
                                                    }
                                                }
                                                catch (ANFE aNFE10) {
                                                    try {
                                                        this.domainName = this.getParameter(stringArray, n, "-domain");
                                                        ++n;
                                                        ++n;
                                                    }
                                                    catch (ANFE aNFE11) {
                                                        try {
                                                            this.newMBeanName = this.getParameter(stringArray, n, "-name");
                                                            ++n;
                                                            ++n;
                                                        }
                                                        catch (ANFE aNFE12) {
                                                            try {
                                                                boolean bl = this.getFlag(stringArray, n, "commotype");
                                                                ++n;
                                                            }
                                                            catch (ANFE aNFE13) {
                                                                try {
                                                                    this.pretty = this.getFlag(stringArray, n, "pretty");
                                                                    ++n;
                                                                }
                                                                catch (ANFE aNFE14) {
                                                                    try {
                                                                        this.exclude = !this.getFlag(stringArray, n, "include");
                                                                        ++n;
                                                                    }
                                                                    catch (ANFE aNFE15) {
                                                                        try {
                                                                            this.verbose = this.getFlag(stringArray, n, "verbose");
                                                                            ++n;
                                                                        }
                                                                        catch (ANFE aNFE16) {
                                                                            try {
                                                                                this.migrateJTA = this.getFlag(stringArray, n, "jta");
                                                                                ++n;
                                                                            }
                                                                            catch (ANFE aNFE17) {
                                                                                try {
                                                                                    this.sourceDown = this.getFlag(stringArray, n, "sourcedown");
                                                                                    ++n;
                                                                                }
                                                                                catch (ANFE aNFE18) {
                                                                                    try {
                                                                                        this.destinationDown = this.getFlag(stringArray, n, "destinationdown");
                                                                                        ++n;
                                                                                    }
                                                                                    catch (ANFE aNFE19) {
                                                                                        try {
                                                                                            this.pattern = this.getParameter(stringArray, n, "-pattern");
                                                                                            ++n;
                                                                                            ++n;
                                                                                        }
                                                                                        catch (ANFE aNFE20) {
                                                                                            try {
                                                                                                this.batchFile = this.getParameter(stringArray, n, "-batchFile");
                                                                                                ++n;
                                                                                                ++n;
                                                                                            }
                                                                                            catch (ANFE aNFE21) {
                                                                                                try {
                                                                                                    this.continueOnErr = this.getFlag(stringArray, n, "continueOnError");
                                                                                                    ++n;
                                                                                                }
                                                                                                catch (ANFE aNFE22) {
                                                                                                    try {
                                                                                                        this.showNoMessages = this.getFlag(stringArray, n, "showNoMessages");
                                                                                                        ++n;
                                                                                                    }
                                                                                                    catch (ANFE aNFE23) {
                                                                                                        try {
                                                                                                            this.batchCmd = this.getFlag(stringArray, n, "batchCmd");
                                                                                                            ++n;
                                                                                                        }
                                                                                                        catch (ANFE aNFE24) {
                                                                                                            try {
                                                                                                                this.batchCmdVerbose = this.getFlag(stringArray, n, "batchCmdVerbose");
                                                                                                                ++n;
                                                                                                            }
                                                                                                            catch (ANFE aNFE25) {
                                                                                                                try {
                                                                                                                    this.listenPortSecure = this.getFlag(stringArray, n, "listenPortSecure");
                                                                                                                    ++n;
                                                                                                                }
                                                                                                                catch (ANFE aNFE26) {
                                                                                                                    try {
                                                                                                                        this.clusterName = this.getParameter(stringArray, n, "-clusterName");
                                                                                                                        ++n;
                                                                                                                        ++n;
                                                                                                                    }
                                                                                                                    catch (ANFE aNFE27) {
                                                                                                                        try {
                                                                                                                            this.configPath = this.getParameter(stringArray, n, "-configPath");
                                                                                                                            ++n;
                                                                                                                            ++n;
                                                                                                                        }
                                                                                                                        catch (ANFE aNFE28) {
                                                                                                                            try {
                                                                                                                                this.getFlag(stringArray, n, IGNORE_SESSIONS.substring(1));
                                                                                                                                this.ignoreSessions = true;
                                                                                                                                ++n;
                                                                                                                            }
                                                                                                                            catch (ANFE aNFE29) {
                                                                                                                                try {
                                                                                                                                    this.timeout = this.getInt(stringArray, n, TIMEOUT);
                                                                                                                                    ++n;
                                                                                                                                    ++n;
                                                                                                                                    this.isTimeoutSet = true;
                                                                                                                                }
                                                                                                                                catch (ANFE aNFE30) {
                                                                                                                                    try {
                                                                                                                                        this.adminUrl = this.getParameter(stringArray, n, "-adminUrl");
                                                                                                                                        if (!this.isURLset && this.adminUrl.startsWith("iiop")) {
                                                                                                                                            this.isIIOP = true;
                                                                                                                                        }
                                                                                                                                        ++n;
                                                                                                                                        ++n;
                                                                                                                                    }
                                                                                                                                    catch (ANFE aNFE31) {
                                                                                                                                        try {
                                                                                                                                            this.serverPropertiesDir = this.getParameter(stringArray, n, "-serverPropDir");
                                                                                                                                            ++n;
                                                                                                                                            ++n;
                                                                                                                                        }
                                                                                                                                        catch (ANFE aNFE32) {
                                                                                                                                            try {
                                                                                                                                                this.clusterPropertiesDir = this.getParameter(stringArray, n, "-clusterPropDir");
                                                                                                                                                ++n;
                                                                                                                                                ++n;
                                                                                                                                            }
                                                                                                                                            catch (ANFE aNFE33) {
                                                                                                                                                try {
                                                                                                                                                    this.newDomainName = this.getParameter(stringArray, n, "-newDomainName");
                                                                                                                                                    ++n;
                                                                                                                                                    ++n;
                                                                                                                                                }
                                                                                                                                                catch (ANFE aNFE34) {
                                                                                                                                                    try {
                                                                                                                                                        this.poolName = this.getParameter(stringArray, n, "-poolName");
                                                                                                                                                        ++n;
                                                                                                                                                        ++n;
                                                                                                                                                    }
                                                                                                                                                    catch (ANFE aNFE35) {
                                                                                                                                                        try {
                                                                                                                                                            this.serverName = this.getParameter(stringArray, n, "-serverName");
                                                                                                                                                            ++n;
                                                                                                                                                            ++n;
                                                                                                                                                        }
                                                                                                                                                        catch (ANFE aNFE36) {
                                                                                                                                                            try {
                                                                                                                                                                this.outputDir = this.getParameter(stringArray, n, "-outputDir");
                                                                                                                                                                ++n;
                                                                                                                                                                ++n;
                                                                                                                                                            }
                                                                                                                                                            catch (ANFE aNFE37) {
                                                                                                                                                                try {
                                                                                                                                                                    this.usernamePwdLocation = this.getParameter(stringArray, n, "-usernamePwdLocation");
                                                                                                                                                                    ++n;
                                                                                                                                                                    ++n;
                                                                                                                                                                }
                                                                                                                                                                catch (ANFE aNFE38) {
                                                                                                                                                                    try {
                                                                                                                                                                        this.listenAdress = this.getParameter(stringArray, n, "-listenAddress");
                                                                                                                                                                        ++n;
                                                                                                                                                                        ++n;
                                                                                                                                                                    }
                                                                                                                                                                    catch (ANFE aNFE39) {
                                                                                                                                                                        try {
                                                                                                                                                                            this.listenPort = this.getParameter(stringArray, n, "-listenPort");
                                                                                                                                                                            ++n;
                                                                                                                                                                            ++n;
                                                                                                                                                                        }
                                                                                                                                                                        catch (ANFE aNFE40) {
                                                                                                                                                                            try {
                                                                                                                                                                                this.noExit = this.getFlag(stringArray, n, "noExit");
                                                                                                                                                                                ++n;
                                                                                                                                                                            }
                                                                                                                                                                            catch (ANFE aNFE41) {
                                                                                                                                                                                try {
                                                                                                                                                                                    String string = this.getParameter(stringArray, n, "-property");
                                                                                                                                                                                    ++n;
                                                                                                                                                                                    if (32 == this.operation) {
                                                                                                                                                                                        if (null == this.mbeanType) {
                                                                                                                                                                                            this.commoType = true;
                                                                                                                                                                                        }
                                                                                                                                                                                        String string2 = null;
                                                                                                                                                                                        if (++n < stringArray.length) {
                                                                                                                                                                                            string2 = stringArray[n];
                                                                                                                                                                                            int n2 = n;
                                                                                                                                                                                            for (n2 = n; !(n2 >= stringArray.length - 1 || stringArray[n2 + 1].equals("-property") || stringArray[n2 + 1].equals("-pretty") || stringArray[n2 + 1].equals("-commotype")); ++n2) {
                                                                                                                                                                                                string2 = string2 + " " + stringArray[n2 + 1];
                                                                                                                                                                                                ++n;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (string2 != null && string2.startsWith("\"") && string2.endsWith("\"")) {
                                                                                                                                                                                                string2 = string2.substring(1, string2.length());
                                                                                                                                                                                                object2 = new StringBuffer(string2);
                                                                                                                                                                                                ((StringBuffer)object2).deleteCharAt(string2.length() - 1);
                                                                                                                                                                                                string2 = ((StringBuffer)object2).toString();
                                                                                                                                                                                            }
                                                                                                                                                                                        } else {
                                                                                                                                                                                            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                                                                                                                                                                                            throw new IllegalArgumentException(managementTextTextFormatter.getProcessArgsPropError(string));
                                                                                                                                                                                        }
                                                                                                                                                                                        try {
                                                                                                                                                                                            if (!this.getCommoType()) {
                                                                                                                                                                                                object = this.getValueObjectFromString(string, string2, this.mbeanType);
                                                                                                                                                                                            }
                                                                                                                                                                                            object = string2;
                                                                                                                                                                                        }
                                                                                                                                                                                        catch (InstanceNotFoundException instanceNotFoundException) {
                                                                                                                                                                                            object2 = new ManagementTextTextFormatter();
                                                                                                                                                                                            throw new IllegalArgumentException("Could not find the instance " + instanceNotFoundException);
                                                                                                                                                                                        }
                                                                                                                                                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                                                                                                                                                            object2 = new ManagementTextTextFormatter();
                                                                                                                                                                                            throw new IllegalArgumentException(object2.getProcessArgsPropNameValError(string2, string) + illegalArgumentException);
                                                                                                                                                                                        }
                                                                                                                                                                                        catch (ConfigurationError configurationError) {
                                                                                                                                                                                            object = string2;
                                                                                                                                                                                            this.commoType = true;
                                                                                                                                                                                        }
                                                                                                                                                                                    } else if (null == object) {
                                                                                                                                                                                        object = new Object();
                                                                                                                                                                                    }
                                                                                                                                                                                    Attribute attribute = new Attribute(string, object);
                                                                                                                                                                                    this.attribList.add(attribute);
                                                                                                                                                                                    ++n;
                                                                                                                                                                                }
                                                                                                                                                                                catch (ANFE aNFE42) {
                                                                                                                                                                                    try {
                                                                                                                                                                                        this.methodName = this.getParameter(stringArray, n, "-method");
                                                                                                                                                                                        ++n;
                                                                                                                                                                                        this.methodArguments = new Vector();
                                                                                                                                                                                        while (n < stringArray.length - 1) {
                                                                                                                                                                                            this.methodArguments.addElement(stringArray[++n]);
                                                                                                                                                                                        }
                                                                                                                                                                                        ++n;
                                                                                                                                                                                    }
                                                                                                                                                                                    catch (ANFE aNFE43) {
                                                                                                                                                                                        try {
                                                                                                                                                                                            this.userconfigfile = this.getParameter(stringArray, n, "-userconfigfile");
                                                                                                                                                                                            this.setUAndPFromConfigFile();
                                                                                                                                                                                            ++n;
                                                                                                                                                                                            ++n;
                                                                                                                                                                                        }
                                                                                                                                                                                        catch (ANFE aNFE44) {
                                                                                                                                                                                            try {
                                                                                                                                                                                                this.userkeyfile = this.getParameter(stringArray, n, "-userkeyfile");
                                                                                                                                                                                                this.setUAndPFromConfigFile();
                                                                                                                                                                                                ++n;
                                                                                                                                                                                                ++n;
                                                                                                                                                                                            }
                                                                                                                                                                                            catch (ANFE aNFE45) {
                                                                                                                                                                                                try {
                                                                                                                                                                                                    this.sourceServer = this.getParameter(stringArray, n, "-server");
                                                                                                                                                                                                    ++n;
                                                                                                                                                                                                    ++n;
                                                                                                                                                                                                }
                                                                                                                                                                                                catch (ANFE aNFE46) {
                                                                                                                                                                                                    ManagementTextTextFormatter managementTextTextFormatter;
                                                                                                                                                                                                    if (0 == this.operation) {
                                                                                                                                                                                                        managementTextTextFormatter = cmds.keys();
                                                                                                                                                                                                        while (managementTextTextFormatter.hasMoreElements()) {
                                                                                                                                                                                                            object2 = (String)managementTextTextFormatter.nextElement();
                                                                                                                                                                                                            try {
                                                                                                                                                                                                                this.populateOperation(stringArray, n, (String)object2);
                                                                                                                                                                                                                ++n;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            catch (ANFE aNFE47) {
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (0 != this.operation) continue;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (0 != this.operation && 30 > this.operation) {
                                                                                                                                                                                                        this.positionalArgs.add(stringArray[n]);
                                                                                                                                                                                                        ++n;
                                                                                                                                                                                                        continue;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (0 != this.operation && (38 == this.operation || 48 == this.operation)) {
                                                                                                                                                                                                        this.positionalArgs.add(stringArray[n]);
                                                                                                                                                                                                        ++n;
                                                                                                                                                                                                        continue;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    managementTextTextFormatter = new ManagementTextTextFormatter();
                                                                                                                                                                                                    throw new IllegalArgumentException(managementTextTextFormatter.getProcessArgsCmdLineError(stringArray[n], n + 1));
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static String replacePrefix(String string, String string2, String string3) {
        return string.toLowerCase().startsWith(string2) ? string3 + string.substring(string2.length()) : string;
    }

    public static String getOperationString() {
        return operationString;
    }

    public static String getUsageString() {
        return CommandLineArgs.getUsageString(false);
    }

    public static String getUsageString(boolean bl) {
        if (null == CommandLineArgs.getOperationString() || CommandLineArgs.getOperationString().equalsIgnoreCase("help")) {
            return CommandLineArgs.getGenericUsage();
        }
        return CommandLineArgs.getUsageString(CommandLineArgs.getOperationString(), bl);
    }

    public static String getGenericUsage() {
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        System.out.println("\n" + managementTextTextFormatter.getAdminDescr());
        System.out.println("\n\t" + managementTextTextFormatter.getAdmin());
        System.out.println("\n\t" + managementTextTextFormatter.getInfo());
        System.out.println("\n\t" + managementTextTextFormatter.getJdbc());
        System.out.println("\n\t" + managementTextTextFormatter.getMbean());
        System.out.println("\n\t" + managementTextTextFormatter.getCluster());
        System.out.println("\n\t" + managementTextTextFormatter.getAdminConfig());
        System.out.println("\n\t" + managementTextTextFormatter.getAll());
        System.out.println("\n" + managementTextTextFormatter.getGenUsage1());
        System.out.println("\n" + managementTextTextFormatter.getHelpUrl());
        return "";
    }

    public static String getUsageString(String string, boolean bl) {
        Object object;
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string2 = null;
        string2 = bl ? "\n" + managementTextTextFormatter.getGenUserConfigUsage1() : "\n" + managementTextTextFormatter.getGenUsage1();
        String string3 = "\n" + managementTextTextFormatter.getInfoStr();
        String string4 = "\n" + managementTextTextFormatter.getServerAdmin();
        String string5 = "\n" + managementTextTextFormatter.getPoolStr();
        String string6 = "\n" + managementTextTextFormatter.getMbeanStr();
        String string7 = "\n" + managementTextTextFormatter.getClusterStr();
        String string8 = "\n" + managementTextTextFormatter.getAdminConfigStr();
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        CommandDescription commandDescription = null;
        String string15 = "\n\n********** SSL Trust Options **********";
        string15 = string15 + "\n\nIf the domain-wide administration port is enabled, or if you are";
        string15 = string15 + "\n connecting to a server through some other SSL port, you might need";
        string15 = string15 + "\nto include Java options to indicate which host the weblogic.Admin";
        string15 = string15 + "\nutility trusts. For example, if the server to which you are connecting";
        string15 = string15 + "\nis using the demonstration SSL keys and certificates, you must include";
        string15 = string15 + "\nthe TrustKeyStore option as follows:";
        string15 = string15 + "\njava -Dweblogic.security.TrustKeyStore=DemoTrust weblogic.Admin <...>";
        string15 = string15 + "\nFor more information, refer to the WebLogic Server security documentation.";
        String string16 = "\njava -Dweblogic.security.TrustKeyStore=DemoTrust ";
        string16 = string16 + "weblogic.Admin -url t3s://localhost:7002 -username weblogic -password weblogic ";
        String string17 = "\nConnecting through an SSL listen port on a server that is using the";
        string17 = string17 + "\ndemonstration SSL keys and certificates:";
        if (null != string && !string.equals("")) {
            object = string.startsWith("-") ? string.substring(1).toUpperCase() : string.toUpperCase();
            commandDescription = (CommandDescription)cmds.get(object);
        }
        if (null == commandDescription || commandDescription.getCommandId() == 100) {
            String string18;
            string2 = string2 + "\n\n" + managementTextTextFormatter.getGenUsage2();
            object = infoCmds.elements();
            while (object.hasMoreElements()) {
                commandDescription = (CommandDescription)object.nextElement();
                if (!commandDescription.isExpose()) continue;
                string18 = commandDescription.getSyntax();
                string9 = string9 + "\n\t" + string18;
            }
            object = serverSpecificCmds.elements();
            while (object.hasMoreElements()) {
                commandDescription = (CommandDescription)object.nextElement();
                if (!commandDescription.isExpose() || (string18 = commandDescription.getSyntax()).length() == 0) continue;
                string11 = string11 + "\n\t" + string18;
            }
            object = poolCmds.elements();
            while (object.hasMoreElements()) {
                commandDescription = (CommandDescription)object.nextElement();
                if (!commandDescription.isExpose()) continue;
                string18 = commandDescription.getSyntax();
                string12 = string12 + "\n\t" + string18;
            }
            object = mbeanCmds.elements();
            while (object.hasMoreElements()) {
                commandDescription = (CommandDescription)object.nextElement();
                if (!commandDescription.isExpose()) continue;
                string18 = commandDescription.getSyntax();
                string10 = string10 + "\n\t" + string18;
            }
            object = clusterCmds.elements();
            while (object.hasMoreElements()) {
                commandDescription = (CommandDescription)object.nextElement();
                if (!commandDescription.isExpose()) continue;
                string18 = commandDescription.getSyntax();
                string13 = string13 + "\n\t" + string18;
            }
            object = adminConfigCmds.elements();
            while (object.hasMoreElements()) {
                commandDescription = (CommandDescription)object.nextElement();
                if (!commandDescription.isExpose()) continue;
                string18 = commandDescription.getSyntax();
                string14 = string14 + "\n\t" + string18;
            }
            object = string2 + "\n" + string4 + "\n" + string11 + "\n" + string3 + "\n" + string9 + "\n" + string5 + "\n" + string12 + "\n" + string6 + "\n" + string10 + "\n" + string7 + "\n" + string13 + "\n" + string8 + "\n" + string14;
            object = (String)object + string15;
            string18 = managementTextTextFormatter.getgetHelp();
            return (String)object + string18;
        }
        object = managementTextTextFormatter.getGenUsage2();
        if (commandDescription.getCommandId() == 101) {
            Enumeration enumeration = infoCmds.elements();
            while (enumeration.hasMoreElements()) {
                CommandDescription commandDescription2 = (CommandDescription)enumeration.nextElement();
                if (!commandDescription2.isExpose()) continue;
                String string19 = commandDescription2.getSyntax();
                string9 = string9 + "\n\t" + string19;
            }
            return "\n" + string3 + "\n" + string2 + "\n" + object + "\n" + string9 + string15 + managementTextTextFormatter.getgetHelp();
        }
        if (commandDescription.getCommandId() == 102) {
            Enumeration enumeration = serverSpecificCmds.elements();
            while (enumeration.hasMoreElements()) {
                String string20;
                CommandDescription commandDescription3 = (CommandDescription)enumeration.nextElement();
                if (!commandDescription3.isExpose() || (string20 = commandDescription3.getSyntax()).length() == 0) continue;
                string11 = string11 + "\n\t" + string20;
            }
            return "\n" + string4 + "\n" + string2 + "\n" + object + "\n" + string11 + string15 + managementTextTextFormatter.getgetHelp();
        }
        if (commandDescription.getCommandId() == 103) {
            Enumeration enumeration = poolCmds.elements();
            while (enumeration.hasMoreElements()) {
                CommandDescription commandDescription4 = (CommandDescription)enumeration.nextElement();
                if (!commandDescription4.isExpose()) continue;
                String string21 = commandDescription4.getSyntax();
                string12 = string12 + "\n\t" + string21;
            }
            return "\n" + string5 + "\n" + string2 + "\n" + object + "\n" + string12 + string15 + managementTextTextFormatter.getgetHelp();
        }
        if (commandDescription.getCommandId() == 104) {
            Enumeration enumeration = mbeanCmds.elements();
            while (enumeration.hasMoreElements()) {
                CommandDescription commandDescription5 = (CommandDescription)enumeration.nextElement();
                if (!commandDescription5.isExpose()) continue;
                String string22 = commandDescription5.getSyntax();
                string10 = string10 + "\n\t" + string22;
            }
            return "\n" + string6 + "\n" + string2 + "\n" + object + "\n" + string10 + string15 + managementTextTextFormatter.getgetHelp();
        }
        if (commandDescription.getCommandId() == 105) {
            Enumeration enumeration = clusterCmds.elements();
            while (enumeration.hasMoreElements()) {
                CommandDescription commandDescription6 = (CommandDescription)enumeration.nextElement();
                if (!commandDescription6.isExpose()) continue;
                String string23 = commandDescription6.getSyntax();
                string13 = string13 + "\n\t" + string23;
            }
            return "\n" + string7 + "\n" + string2 + "\n" + object + "\n" + string13 + string15 + managementTextTextFormatter.getgetHelp();
        }
        if (commandDescription.getCommandId() == 106) {
            Enumeration enumeration = adminConfigCmds.elements();
            while (enumeration.hasMoreElements()) {
                CommandDescription commandDescription7 = (CommandDescription)enumeration.nextElement();
                if (!commandDescription7.isExpose()) continue;
                String string24 = commandDescription7.getSyntax();
                string14 = string14 + "\n\t" + string24;
            }
            return "\n" + string8 + "\n" + string2 + "\n" + object + "\n" + string14 + string15 + managementTextTextFormatter.getgetHelp();
        }
        String string25 = commandDescription.getInfoMessage();
        string2 = string25 != "" ? "\n ***** " + string25 + " *****" + "\n\n" + managementTextTextFormatter.getDesr() + "\n" + commandDescription.getDescription() : "\n" + managementTextTextFormatter.getDesr() + "\n" + commandDescription.getDescription();
        string2 = string2 + "\n\n" + (bl ? managementTextTextFormatter.getCommUserConfigUsage() : managementTextTextFormatter.getCommUsage()) + "\t" + commandDescription.getSyntax();
        if (commandDescription.getArgumentDescription().length() != 0) {
            string2 = string2 + "\n\n" + managementTextTextFormatter.getWhere() + "\n" + commandDescription.getArgumentDescription();
        }
        string2 = string2 + "\n\n" + managementTextTextFormatter.getExamples() + "\n" + commandDescription.getExample();
        string2 = string2 + "\n" + string17 + string16 + commandDescription.getSyntax();
        return string2;
    }

    public String getMBeanType() {
        return this.mbeanType;
    }

    public String getMBeanObjName() {
        return this.mBeanObjName;
    }

    public String getNewMBeanName() {
        return this.newMBeanName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMigratableTargetName() {
        return this.migratableTargetName;
    }

    public String getSingletonServiceName() {
        return this.singletonServiceName;
    }

    public String getMigratableServerName() {
        return this.migratableServerName;
    }

    public String getDestinationMachineName() {
        return this.migratableServerDestinationMachineName;
    }

    public String getSourceServerName() {
        return this.sourceServer;
    }

    public String getDestinationServerName() {
        return this.destinationServerName;
    }

    public boolean getMigrateJTA() {
        return this.migrateJTA;
    }

    public boolean getIgnoreSessions() {
        return this.ignoreSessions;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getSourceDown() {
        return this.sourceDown;
    }

    public boolean getDestinationDown() {
        return this.destinationDown;
    }

    public boolean getCommoType() {
        return this.commoType;
    }

    public String getObjectNamePattern() {
        return this.pattern;
    }

    public String getBatchFileName() {
        return this.batchFile;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public boolean isBatchCmd() {
        return this.batchCmd;
    }

    public String getURL() {
        if (this.url != null) {
            int n = this.url.indexOf("//");
            if (n > 0 && this.url.charAt(n - 1) == ':') {
                return this.url;
            }
            if (n == 0) {
                return "t3:" + this.url;
            }
            return "t3://" + this.url;
        }
        return DEFAULT_URL;
    }

    public String getT3URL() {
        return CommandLineArgs.replacePrefix(this.getURL(), "http", "t3");
    }

    public String getHttpURL() {
        return CommandLineArgs.replacePrefix(this.getURL(), "t3", "http");
    }

    public String getUsername() {
        if (Kernel.isServer()) {
            return null;
        }
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUsingBootProperties(boolean bl) {
        this.usingBootProperties = bl;
    }

    public boolean isUsingBootProperties() {
        return this.usingBootProperties;
    }

    public String getPassword() {
        if (Kernel.isServer()) {
            return null;
        }
        if (null == this.password) {
            if (this.username == null) {
                return null;
            }
            this.getPasswordInteractively();
        }
        return this.password;
    }

    public String getUserConfig() {
        if (Kernel.isServer()) {
            return null;
        }
        return this.userconfigfile;
    }

    public String getUserKey() {
        if (Kernel.isServer()) {
            return null;
        }
        return this.userkeyfile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public boolean isURLset() {
        return this.isURLset;
    }

    public boolean isTimeoutSet() {
        return this.isTimeoutSet;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getServerPropertiesDirectory() {
        return this.serverPropertiesDir;
    }

    public String getClusterPropertiesDirectory() {
        return this.clusterPropertiesDir;
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    public String getNewDomainName() {
        return this.newDomainName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isNoExit() {
        return this.noExit;
    }

    public AttributeList getAttribList() {
        return this.attribList;
    }

    public Object[] getMethodArguments(String[] stringArray) throws IllegalArgumentException {
        Object[] objectArray = new Object[stringArray.length];
        if (stringArray.length != this.methodArguments.size()) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getMethodArgumentsError(this.getMethodName(), stringArray.length, this.methodArguments.size()));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.getObjectFromString(stringArray[i], (String)this.methodArguments.elementAt(i));
        }
        return objectArray;
    }

    public String getPositionalArg(int n) {
        return (String)this.positionalArgs.get(n);
    }

    public int getPositionalArgCount() {
        return this.positionalArgs.size();
    }

    boolean getFlag(String[] stringArray, int n, String string) throws ANFE {
        String string2 = null;
        string2 = stringArray[n].startsWith("-") ? stringArray[n].substring(1) : stringArray[n];
        if (string2.equalsIgnoreCase(string)) {
            return true;
        }
        throw new ANFE();
    }

    String getParameter(String[] stringArray, int n, String string) throws IllegalArgumentException, ANFE {
        if (stringArray[n].equalsIgnoreCase(string)) {
            if (n < stringArray.length - 1) {
                return stringArray[n + 1];
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getParameterError(n + 1, string));
        }
        throw new ANFE();
    }

    int getInt(String[] stringArray, int n, String string) throws IllegalArgumentException, ANFE {
        try {
            return Integer.parseInt(this.getParameter(stringArray, n, string));
        }
        catch (NumberFormatException numberFormatException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getParameterError(n + 1, string));
        }
    }

    String getStringAttribList(AttributeList attributeList) {
        Object[] objectArray = attributeList.toArray();
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            Attribute attribute = (Attribute)objectArray[i];
            string = string + attribute.getName() + "=" + attribute.getValue() + "\n";
        }
        return string;
    }

    String getTypeFromObj(String string) throws MalformedObjectNameException {
        WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string);
        String string2 = webLogicObjectName.getType();
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    void getPasswordInteractively() {
        if (TerminalIO.isNoEchoAvailable()) {
            try {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.print(managementTextTextFormatter.getPwdInteractively(this.username));
                this.password = TerminalIO.readTerminalNoEcho();
                System.out.println("\n");
            }
            catch (Error error) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.err.println(managementTextTextFormatter.getPwdInteractivelyError());
            }
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.print(managementTextTextFormatter.getPwdInteractively(this.username));
                this.password = bufferedReader.readLine();
            }
            catch (Exception exception) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.err.println(managementTextTextFormatter.getPwdInteractivelyError());
            }
        }
    }

    private Object getValueObjectFromString(String string, String string2, String string3) throws IllegalArgumentException, InstanceNotFoundException, ConfigurationError {
        Object object;
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        try {
            if (this.mBeanObjName != null) {
                this.adminHome = AdminToolHelper.getAdminMBeanHome(this);
                this.mbean = this.adminHome.getMBean((ObjectName)new WebLogicObjectName(this.mBeanObjName));
                this.info = MBeanCommandLineInvoker.getMBeanInfo(this.mbean);
                this.adminHome = null;
            } else {
                mBeanAttributeInfoArray = ManagementServiceClient.getBeanInfoAccess();
                object = mBeanAttributeInfoArray.getBeanInfoForInterface("weblogic.management.configuration." + string3 + "MBean", false, "9.0.0");
                PropertyDescriptor[] propertyDescriptorArray = object.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                    if (!propertyDescriptor.getName().equals(string)) continue;
                    return this.getObjectFromString(propertyDescriptor.getPropertyType().getName(), string2);
                }
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
        mBeanAttributeInfoArray = null;
        mBeanAttributeInfoArray = this.info.getAttributes();
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            if (!mBeanAttributeInfoArray[i].getName().equals(string)) continue;
            object = mBeanAttributeInfoArray[i].getType();
            return this.getObjectFromString((String)object, string2);
        }
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        throw new IllegalArgumentException(managementTextTextFormatter.getValueObjectFromStringError(string, string3));
    }

    private Object getObjectFromString(String string, String string2) throws IllegalArgumentException {
        StringTokenizer stringTokenizer;
        String string3;
        boolean bl;
        Object object = null;
        Object[] objectArray = null;
        if (string.startsWith("[L") && string.endsWith(";")) {
            bl = true;
            string3 = string.substring("[L".length(), string.lastIndexOf(";"));
            stringTokenizer = new StringTokenizer(string2, ";");
            if (string3.startsWith("weblogic.management") && string3.endsWith("MBean")) {
                objectArray = new WebLogicObjectName[stringTokenizer.countTokens()];
            } else {
                try {
                    Class<?> clazz = Class.forName(string3);
                    objectArray = (Object[])Array.newInstance(clazz, stringTokenizer.countTokens());
                }
                catch (NegativeArraySizeException negativeArraySizeException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    throw new IllegalArgumentException(managementTextTextFormatter.getObjectFromStringError(string2, string) + classNotFoundException);
                }
            }
        } else {
            bl = false;
            string3 = string;
            stringTokenizer = new StringTokenizer(string2, "");
        }
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = (String)stringTokenizer.nextElement();
            object = this.getOneObjectFromString(string3, string4);
            if (bl) {
                objectArray[n++] = object;
                continue;
            }
            return object;
        }
        return objectArray;
    }

    private Object getOneObjectFromString(String string, String string2) throws IllegalArgumentException {
        if (string.equals("int")) {
            Integer n = new Integer(string2);
            return n;
        }
        if (string.equals("java.lang.String")) {
            return string2;
        }
        if (string.equals("java.util.Properties") || string.equals("java.util.Map")) {
            Properties properties = new Properties();
            if (this.mbeanType != null && (this.mbeanType.equals("JDBCConnectionPool") || this.mbeanType.equals("JDBCDataSourceFactory"))) {
                TypeConversionUtils.stringToDictionary((String)string2, (Dictionary)properties, (String)";");
            } else {
                TypeConversionUtils.stringToDictionary((String)string2, (Dictionary)properties);
            }
            return properties;
        }
        if (string.equals("boolean")) {
            Boolean bl = new Boolean(string2);
            return bl;
        }
        if (string.equals("long")) {
            Long l = new Long(string2);
            return l;
        }
        if (string.startsWith("weblogic.management") && string.endsWith("MBean")) {
            try {
                WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string2);
                return webLogicObjectName;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(malformedObjectNameException.toString());
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            String[] stringArray = new String[]{string2};
            Object obj = constructor.newInstance(stringArray);
            return obj;
        }
        catch (InstantiationException instantiationException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getOneObjectFromString(string2, string) + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getOneObjectFromString(string2, string) + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getOneObjectFromString(string2, string) + invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getOneObjectFromString(string2, string) + classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getOneObjectFromString(string2, string) + noSuchMethodException);
        }
        catch (SecurityException securityException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getOneObjectFromString(string2, string) + securityException);
        }
    }

    public MBeanHome getAdminHome() {
        return this.adminHome;
    }

    public WebLogicMBean getWebLogicMBean() {
        return this.mbean;
    }

    private void setUAndPFromConfigFile() {
        if (this.username != null || this.password != null) {
            return;
        }
        UsernameAndPassword usernameAndPassword = null;
        if (this.getUserConfig() != null && this.getUserKey() != null && (usernameAndPassword = UserConfigFileManager.getUsernameAndPassword(this.getUserConfig(), this.getUserKey(), "weblogic.management")) != null && usernameAndPassword.isUsernameSet() && usernameAndPassword.isPasswordSet()) {
            this.setUsername(usernameAndPassword.getUsername());
            this.setPassword(new String(usernameAndPassword.getPassword()));
        }
    }

    static {
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string = managementTextTextFormatter.getCommonSample();
        String string2 = managementTextTextFormatter.getPingArgs3() + "\n" + managementTextTextFormatter.getPingArgs1() + "\n" + managementTextTextFormatter.getPingArgs2();
        CommandLineArgs.addCmd("INFO", 101, "", "Retrieving Information About WebLogic Server", true, "", "");
        CommandLineArgs.addInfoCmd("PING", 2, managementTextTextFormatter.getPingUsage(), managementTextTextFormatter.getPingDescription(), string + managementTextTextFormatter.getPingExample(), "", string2, 101);
        String string3 = managementTextTextFormatter.getConnectArgs();
        CommandLineArgs.addInfoCmd("CONNECT", 7, managementTextTextFormatter.getConnectUsage(), managementTextTextFormatter.getConnectDescription(), string + managementTextTextFormatter.getConnectSample(), "", string3, 101);
        CommandLineArgs.addInfoCmd("VERSION", 6, managementTextTextFormatter.getVersionUsage(), managementTextTextFormatter.getVersionDescription(), string + " " + managementTextTextFormatter.getVersionSample(), "", "", 101);
        CommandLineArgs.addInfoCmd("LIST", 10, managementTextTextFormatter.getListUsage(), managementTextTextFormatter.getListDescription(), string + " " + managementTextTextFormatter.getListSample(), "", managementTextTextFormatter.getListArgs(), 101);
        CommandLineArgs.addInfoCmd("THREAD_DUMP", 18, managementTextTextFormatter.getThreadDumpUsage(), managementTextTextFormatter.getThreadDumpDescription(), string + " " + managementTextTextFormatter.getThreadDumpSample(), "", "", 101);
        CommandLineArgs.addInfoCmd("SERVERLOG", 19, managementTextTextFormatter.getLogOperationUsage(), managementTextTextFormatter.getLogDescription(), string + " " + managementTextTextFormatter.getLogSample(), "", managementTextTextFormatter.getLogArgs(), 101);
        CommandLineArgs.addInfoCmd("GETSTATE", 28, managementTextTextFormatter.getGetStateUsage(), managementTextTextFormatter.getGetStateDescription(), string + " " + managementTextTextFormatter.getGetStateSample(), "", managementTextTextFormatter.getGetStateArgs(), 101);
        CommandLineArgs.addCmd("JDBC", 103, "", "Managing JDBC Connection Pools", true, "", "");
        CommandLineArgs.addPoolCmd("RESET_POOL", 12, managementTextTextFormatter.getResetPoolUsage(), managementTextTextFormatter.getResetDescription(), string + " " + managementTextTextFormatter.getResetSample(), "", "", 103);
        CommandLineArgs.addPoolCmd("CREATE_POOL", 13, managementTextTextFormatter.getCreatePoolUsage(), managementTextTextFormatter.getCreatePoolDescription(), string + " " + managementTextTextFormatter.getCreatePoolSample(), "", managementTextTextFormatter.getCreatePoolArgs(), 103);
        CommandLineArgs.addPoolCmd("DESTROY_POOL", 48, managementTextTextFormatter.getDestroyPoolUsage(), managementTextTextFormatter.getDestroyPoolDescription(), string + " " + managementTextTextFormatter.getDestroyPoolSample(), "", managementTextTextFormatter.getDestroyPoolArgs(), 103);
        CommandLineArgs.addPoolCmd("ENABLE_POOL", 15, managementTextTextFormatter.getEnablePoolUsage(), managementTextTextFormatter.getEnablePoolDescription(), string + " " + managementTextTextFormatter.getEnablePoolSample(), "", managementTextTextFormatter.getEnablePoolArgs(), 103);
        CommandLineArgs.addPoolCmd("DISABLE_POOL", 16, managementTextTextFormatter.getDisablePoolUsage(), managementTextTextFormatter.getDisablePoolDescription(), string + " " + managementTextTextFormatter.getDisablePoolSample(), "", managementTextTextFormatter.getDisablePoolArgs(), 103);
        CommandLineArgs.addPoolCmd("EXISTS_POOL", 17, managementTextTextFormatter.getExistsPoolUsage(), managementTextTextFormatter.getExistsPoolDescription(), string + " " + managementTextTextFormatter.getExistsPoolSample(), "", managementTextTextFormatter.getExistsPoolArgs(), 103);
        CommandLineArgs.addPoolCmd("TEST_POOL", 38, managementTextTextFormatter.getTestPoolUsage1(), managementTextTextFormatter.getTestPoolDescription(), string + " " + managementTextTextFormatter.getTestPoolSample(), "", managementTextTextFormatter.getTestPoolArgs(), 103);
        CommandLineArgs.addPoolCmd("RESUME_POOL", 46, "RESUME_POOL -poolName <connection pool name>", "Resumes the connection pool", string + " " + "RESUME_POOL -poolName mypool", "", "", 103);
        CommandLineArgs.addPoolCmd("SHUTDOWN_POOL", 45, "SHUTDOWN_POOL -poolName <connection pool name>", "Shutsdown the connection pool", string + " " + "SHUTDOWN_POOL -poolName mypool", "", "", 103);
        CommandLineArgs.addPoolCmd("SUSPEND_POOL", 44, "SUSPEND_POOL -poolName <connection pool name>", "Suspends the connection pool", string + " " + "SUSPEND_POOL -poolName mypool", "", "", 103);
        CommandLineArgs.addPoolCmd("DELETE_POOL", 47, "DELETE_POOL -poolName <connection pool name>", "Deletes the connection pool after undeploying from all targets", string + " " + "DELETE_POOL -poolName mypool", "", "", 103);
        CommandLineArgs.addCmd("LIFECYCLE", 102, "", "Managing the Server Life Cycle", true, "", "");
        CommandLineArgs.addServerSpecificCmd("START", 21, managementTextTextFormatter.getStartUsage(), managementTextTextFormatter.getStartDescription(), string + " " + managementTextTextFormatter.getStartSample(), "", managementTextTextFormatter.getStartArgs(), 102, managementTextTextFormatter.getNeedNodeManager());
        CommandLineArgs.addServerSpecificCmd("STARTINSTANDBY", 22, managementTextTextFormatter.getSTARTINSTANDBYUsage(), managementTextTextFormatter.getStartInStandByDescription(), string + " " + managementTextTextFormatter.getStartInStandbySample(), "", managementTextTextFormatter.getStartInStandbyArgs(), 102);
        CommandLineArgs.addServerSpecificCmd("LOCK", 8, managementTextTextFormatter.getLockUsage(), managementTextTextFormatter.getLockDescription(), string + " " + managementTextTextFormatter.getLockSample(), "", managementTextTextFormatter.getLockArgs(), 102, managementTextTextFormatter.getNotSupported());
        CommandLineArgs.addServerSpecificCmd("UNLOCK", 9, managementTextTextFormatter.getUnlockUsage(), managementTextTextFormatter.getUnLockDescription(), string + " " + managementTextTextFormatter.getUnLockSample(), "", "", 102, managementTextTextFormatter.getNotSupported());
        CommandLineArgs.addServerSpecificCmd("RESUME", 25, managementTextTextFormatter.getResumeUsage(), managementTextTextFormatter.getResumeDescription(), string + " " + managementTextTextFormatter.getResumeSample(), "", managementTextTextFormatter.getResumeArgs(), 102, managementTextTextFormatter.getNotSupported());
        CommandLineArgs.addServerSpecificCmd("SHUTDOWN", 26, managementTextTextFormatter.getShutdownUsage(), managementTextTextFormatter.getShutDownDescription(), string + " " + managementTextTextFormatter.getShutDownSample(), "", managementTextTextFormatter.getShutDownArgs(), 102, managementTextTextFormatter.getshutNotSupported());
        CommandLineArgs.addServerSpecificCmd("CANCEL_SHUTDOWN", 11, "", "", "", "", "", 102, managementTextTextFormatter.getNotSupported());
        CommandLineArgs.addServerSpecificCmd("FORCESHUTDOWN", 27, managementTextTextFormatter.getForceSDUsage(), managementTextTextFormatter.getForceSDDescription(), string + " " + managementTextTextFormatter.getForceSDSample(), "", managementTextTextFormatter.getForceSDArgs(), 102);
        CommandLineArgs.addServerSpecificCmd("CONVERTPROPS", 42, "CONVERTPROPS  -serverPropdir <server Dir> -clusterPropDir <clusterDir> -newdomainName <domainName> -servername <server name> -outputDir <outputDir>", "Converts the weblogic.properties to config.xml", false, string + " " + "CONVERTPROPS -serverPropdir c:\\wls_jb\\config\\karma -newdomainName ydomain -servername yserver -outputDir c:\\temp", "", "later dude", 102);
        CommandLineArgs.addServerSpecificCmd("DISCOVERMANAGEDSERVER", 43, "DISCOVERMANAGEDSERVER [-serverName <targetServer> [-listenPort <listenport>] [-listenAddress <listen address>] [-listenPortSecure]]", "Causes the Administration Server to re-establish administrative control over Managed Servers.", string + " " + "DISCOVERMANAGEDSERVER -serverName managed1 -listenPort 7701 -listenAddress spiffy", "", "serverName = A Managed Server that is currently running. If you\n\tdo not specify a server, the Administration Server will\n\tdiscover and re-establish control over all the Managed\n\tServers that are known to be running but disconnected\n\tfrom administrative services. \nlistenPort = (optional)Listen port at which the managed server is running, if not specified, uses the listen port that is configured. \nlistenAddress = (optional) Listen address at which the managed server is running, if not specified uses the listen address that is configured. \nlistenPortSecure = (optional) Forces the Administration Server to use a secure protocol. Without this\noption, the Administration Server uses the t3 protocol. If you disable a \nManaged Server's non-SSL listen port, you must specify this option.", 102);
        CommandLineArgs.addCmd("MBEAN", 104, "", "Working with WebLogic Server MBeans", true, "", "");
        String string4 = string + " " + managementTextTextFormatter.getCreateWithON();
        string4 = string4 + "\n" + string + " " + managementTextTextFormatter.getCreateWithName();
        CommandLineArgs.addMBeanCmd("CREATE", 33, managementTextTextFormatter.getCreateUsage(), managementTextTextFormatter.getCreateDescription(), string4, "", managementTextTextFormatter.getCreateArgs(), 104);
        String string5 = string + " " + managementTextTextFormatter.getGetSampleForType();
        string5 = string5 + "\n" + string + " " + managementTextTextFormatter.getGetSampleForON();
        string5 = string5 + "\n" + string + " " + managementTextTextFormatter.getGetSampleForProperty();
        CommandLineArgs.addMBeanCmd("GET", 31, managementTextTextFormatter.getGetUsage(), managementTextTextFormatter.getGetDescription(), string5, "", managementTextTextFormatter.getGetArgs(), 104);
        String string6 = string + " " + managementTextTextFormatter.getSetSampleForType();
        string6 = string6 + "\n" + string + " " + managementTextTextFormatter.getSetSampleForON();
        CommandLineArgs.addMBeanCmd("SET", 32, managementTextTextFormatter.getSetUsage(), managementTextTextFormatter.getSetDescription(), string6, "", managementTextTextFormatter.getSetArgs(), 104);
        CommandLineArgs.addMBeanCmd("INVOKE", 35, managementTextTextFormatter.getInvokeUsage(), managementTextTextFormatter.getInvokeDescription(), string + " " + managementTextTextFormatter.getInvokeSample(), "", managementTextTextFormatter.getInvokeArgs(), 104);
        CommandLineArgs.addMBeanCmd("QUERY", 29, managementTextTextFormatter.getQueryUsage(), managementTextTextFormatter.getQueryDescription(), string + " " + managementTextTextFormatter.getQuerySample(), "", managementTextTextFormatter.getQueryArgs(), 104);
        String string7 = string + " " + managementTextTextFormatter.getDeleteWithON();
        string7 = string7 + "\n" + string + " " + managementTextTextFormatter.getDeleteType();
        CommandLineArgs.addMBeanCmd("DELETE", 34, managementTextTextFormatter.getDeleteUsage(), managementTextTextFormatter.getDeleteDescription(), string7, "", managementTextTextFormatter.getDeleteArgs(), 104);
        CommandLineArgs.addMBeanCmd("BATCHUPDATE", 36, managementTextTextFormatter.getBatchUsage(), managementTextTextFormatter.getBatchDescription(), string + " " + managementTextTextFormatter.getBatchSample(), "", managementTextTextFormatter.getBatchArgs(), 104);
        CommandLineArgs.addCmd("CLUSTER", 105, "", "Working with Clusters", true, "", "");
        CommandLineArgs.addClusterCmd("VALIDATECLUSTERCONFIG", 41, managementTextTextFormatter.getVCCUsage(), managementTextTextFormatter.getVCCDescription(), string + " " + managementTextTextFormatter.getVCCSample(), "", managementTextTextFormatter.getVCCArgs(), 105);
        CommandLineArgs.addClusterCmd("STARTCLUSTER", 39, managementTextTextFormatter.getclusterStartUsage(), managementTextTextFormatter.getClusterStartDescription(), string + " " + managementTextTextFormatter.getClusterStartSample(), "", managementTextTextFormatter.getStartClusterArgs(), 105, managementTextTextFormatter.getNeedNodeManager());
        CommandLineArgs.addClusterCmd("STOPCLUSTER", 40, managementTextTextFormatter.getClusterStopUsage(), managementTextTextFormatter.getClusterStopDescription(), string + " " + managementTextTextFormatter.getClusterStopSample(), "", managementTextTextFormatter.getStopClusterArgs(), 105, managementTextTextFormatter.getNeedNodeManager());
        CommandLineArgs.addClusterCmd("CLUSTERSTATE", 37, managementTextTextFormatter.getPingClusterUsage(), managementTextTextFormatter.getpingclusDesr(), string + " " + managementTextTextFormatter.getpingclusterSample(), "", managementTextTextFormatter.getpingClusterArgs(), 105);
        String string8 = string + " " + managementTextTextFormatter.getMigrateSampleJTA();
        string8 = string8 + "\n" + string + " " + managementTextTextFormatter.getMigrateSampleJMS();
        CommandLineArgs.addClusterCmd("MIGRATE", 50, managementTextTextFormatter.getMigrateUsage(), managementTextTextFormatter.getMigrateDescription(), string8, "", managementTextTextFormatter.getMigrateArgs(), 105);
        CommandLineArgs.addClusterCmd("MIGRATESERVER", 52, managementTextTextFormatter.getMigrateServerUsage(), managementTextTextFormatter.getMigrateServerDescription(), managementTextTextFormatter.getMigrateServerSample(), "", managementTextTextFormatter.getMigrateServerArgs(), 105);
        String string9 = string + " MIGRATEALL -server server1 " + "-destination server2";
        CommandLineArgs.addClusterCmd("MIGRATEALL", 53, managementTextTextFormatter.getMigrateAllUsage(), managementTextTextFormatter.getMigrateAllDescription(), string9, "", managementTextTextFormatter.getMigrateAllArgs(), 105);
        CommandLineArgs.addCmd("ADMINCONFIG", 106, "", "Managing the weblogic commands", true, "", "");
        CommandLineArgs.addAdminConfigCmd("STOREUSERCONFIG", 51, managementTextTextFormatter.getStoreUserConfigUsage(), managementTextTextFormatter.getStoreUserConfigDescription(), string + " " + managementTextTextFormatter.getStoreUserConfigSample(), "", managementTextTextFormatter.getStoreUserConfigArgs(), 106);
        CommandLineArgs.addCmd("ALL", 100, "", "Help for all available commands", true, "", "");
        CommandLineArgs.addInfoCmd("HELP", 20, managementTextTextFormatter.getHelpUsage(), "Help on a specific command", "", "", "", 0);
    }
}

