/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline;

import java.io.PrintStream;
import java.util.HashMap;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.Tool;

public class ExtendedTool
extends Tool {
    private HashMap childCommandMap = new HashMap();
    protected PrintStream printStream = System.out;

    public void addSubCommand(String string, ExtendedTool extendedTool) {
        this.childCommandMap.put(string, extendedTool);
    }

    public void removeSubCommand(String string) {
        this.childCommandMap.remove(string);
    }

    public Getopt2 getOpts() {
        return this.opts;
    }

    public void prepare() {
        this.opts = new Getopt2();
        for (String string : this.childCommandMap.keySet()) {
            ExtendedTool extendedTool = (ExtendedTool)((Object)this.childCommandMap.get(string));
            String string2 = extendedTool.getOpts().getUsageArgs();
            String string3 = extendedTool.getOpts().getUsageHeader();
            this.opts.addArgFlag(string, "<" + string2 + ">", string3);
        }
        if (this.childCommandMap.size() > 0) {
            this.opts.setFailOnUnrecognizedOpts(false);
            this.setRequireExtraArgs(true);
        }
    }

    public final void run(String[] stringArray) throws Exception {
        if (this.childCommandMap.size() == 0) {
            super.run(stringArray);
        } else {
            this.run(stringArray, 0);
        }
    }

    private void run(String[] stringArray, int n) throws Exception {
        if (this.childCommandMap.size() == 0) {
            super.run(stringArray);
            return;
        }
        ExtendedTool extendedTool = null;
        int n2 = stringArray.length;
        for (int i = n; i < n2; ++i) {
            String string = stringArray[i];
            String string2 = string.startsWith("-") ? string.substring(1) : string;
            extendedTool = (ExtendedTool)((Object)this.childCommandMap.get(string2));
            if (extendedTool == null) continue;
            stringArray[i] = "";
            extendedTool.run(stringArray, i + 1);
            return;
        }
    }

    public void runBody() throws Exception {
        throw new IllegalAccessError("This method should be overwritten by extended Class Or addSubCommand() should be called ");
    }

    public static void main(String[] stringArray) throws Exception {
        ExtendedTool extendedTool = new ExtendedTool();
    }
}

