/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.ConfigurationException;

public final class OutputFormatter {
    OutputStream out;
    boolean isPretty;

    public OutputFormatter(OutputStream outputStream, boolean bl) {
        this.out = outputStream;
        this.isPretty = bl;
    }

    public void mbeanBegin(String string) throws IOException {
        if (!this.isPretty) {
            this.out.write(("{MBeanName=\"" + string + "\"").getBytes());
        } else {
            this.out.write(("---------------------------\nMBeanName: \"" + string + "\"\n").getBytes());
        }
    }

    public void mbeanEnd() throws IOException {
        if (!this.isPretty) {
            this.out.write("}\n".getBytes());
        }
    }

    public void printReturnValue(String string, Object object) throws IOException {
        if (null == object) {
            return;
        }
        try {
            if (!this.isPretty) {
                this.out.write(("{" + string + "=" + OutputFormatter.getAttributeStringFromValue(object) + "}").getBytes());
            } else {
                this.out.write(("\t" + string + ": " + OutputFormatter.getAttributeStringFromValue(object) + "\n").getBytes());
            }
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationError(configurationException);
        }
    }

    public void printAttribs(AttributeList attributeList, String[] stringArray) throws IOException {
        int n;
        Object[] objectArray;
        int n2 = 0;
        if (attributeList != null) {
            n2 = attributeList.size();
        }
        int n3 = 0;
        if (stringArray != null) {
            n3 = stringArray.length;
        }
        if (n2 == 0 && n3 == 0) {
            String string = "\n\t\tIt appears that no attributes have been specified for this MBean\n";
            this.out.write(string.getBytes());
            return;
        }
        if (n3 > n2) {
            objectArray = new String[n3];
            n = 0;
            for (int i = 0; i < n3; ++i) {
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    String string = ((Attribute)attributeList.get(j)).getName();
                    if (!string.equals(stringArray[i])) continue;
                    bl = true;
                }
                if (bl) continue;
                objectArray[n] = stringArray[i];
                if (++n == objectArray.length) break;
            }
            if (n2 == 0) {
                return;
            }
        }
        objectArray = attributeList.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Attribute)object).getName().compareTo(((Attribute)object2).getName());
            }
        });
        for (n = 0; n < objectArray.length; ++n) {
            Attribute attribute = (Attribute)objectArray[n];
            try {
                if (attribute.getValue() == null) {
                    this.property(attribute.getName(), "");
                    continue;
                }
                this.property(attribute.getName(), OutputFormatter.getAttributeStringFromValue(attribute.getValue()));
                continue;
            }
            catch (ConfigurationException configurationException) {
                throw new ConfigurationError(configurationException);
            }
        }
    }

    public void property(String string, String string2) throws IOException {
        if (!this.isPretty) {
            this.out.write(("{" + string + "=" + string2 + "}").getBytes());
        } else {
            this.out.write(("\t" + string + ": " + string2 + "\n").getBytes());
        }
    }

    public void println(String string) throws IOException {
        this.print(string + "\n");
    }

    public void print(String string) throws IOException {
        this.out.write(string.getBytes());
    }

    private static String getAttributeStringFromValue(Object object) throws ConfigurationException {
        try {
            if (object instanceof ObjectName) {
                return ((ObjectName)object).getKeyProperty("Name");
            }
            if (object instanceof ObjectName) {
                return ((ObjectName)object).toString();
            }
            if (object instanceof WebLogicMBean) {
                WebLogicObjectName webLogicObjectName = ((WebLogicMBean)object).getObjectName();
                return webLogicObjectName.getName();
            }
            if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (string.length() != 0) {
                        string = string + ",";
                    }
                    string = string + stringArray[i];
                }
                return string;
            }
            if (object instanceof ObjectName[]) {
                ObjectName[] objectNameArray = (ObjectName[])object;
                String string = "";
                for (int i = 0; i < objectNameArray.length; ++i) {
                    if (string.length() != 0) {
                        string = string + ",";
                    }
                    string = string + objectNameArray[i].getKeyProperty("Name");
                }
                return string;
            }
            if (object instanceof ObjectName[]) {
                ObjectName[] objectNameArray = (ObjectName[])object;
                String string = "";
                for (int i = 0; i < objectNameArray.length; ++i) {
                    if (string.length() != 0) {
                        string = string + ",";
                    }
                    string = string + objectNameArray[i].getKeyProperty("Name");
                }
                return string;
            }
            if (object instanceof WebLogicMBean[]) {
                WebLogicMBean[] webLogicMBeanArray = (WebLogicMBean[])object;
                String string = "";
                for (int i = 0; i < webLogicMBeanArray.length; ++i) {
                    if (string.length() != 0) {
                        string = string + ",";
                    }
                    WebLogicObjectName webLogicObjectName = webLogicMBeanArray[i].getObjectName();
                    string = string + webLogicObjectName.getName();
                }
                return string;
            }
            if (object instanceof Properties) {
                StringBuffer stringBuffer = new StringBuffer();
                Properties properties = (Properties)object;
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(";");
                    }
                    String string = (String)iterator.next();
                    String string2 = (String)properties.get(string);
                    stringBuffer.append(string);
                    stringBuffer.append("=");
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }
            if (object instanceof Map) {
                String string = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    if (string3.length() != 0) {
                        string3 = string3 + ";";
                    }
                    string3 = string3 + stringTokenizer.nextToken();
                }
                string3 = string3.replace('{', ' ');
                string3 = string3.replace('}', ' ');
                string3 = string3.trim();
                return string3;
            }
            if (object instanceof StandardInterface[]) {
                StandardInterface[] standardInterfaceArray = (StandardInterface[])object;
                String string = "";
                for (int i = 0; i < standardInterfaceArray.length; ++i) {
                    if (string.length() != 0) {
                        string = string + ",";
                    }
                    string = string + standardInterfaceArray[i].wls_getObjectName();
                }
                return string;
            }
            if (object == null) {
                return "null";
            }
            return object.toString();
        }
        catch (Exception exception) {
            throw new ConfigurationException((Throwable)exception);
        }
    }
}

