/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.management.InstanceNotFoundException;
import weblogic.management.MBeanHome;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;

public final class AdminConfigCommandLineInvoker {
    static final String OK_STRING = "Ok";
    static CommandLineArgs params = null;
    static PrintWriter printLog = null;
    static AdminToolHelper toolHelper = null;
    MBeanHome adminHome = null;
    OutputFormatter out = null;
    private static boolean CONTINUE = true;
    private static PrintStream printStream = System.out;
    private boolean EXIT = false;

    public AdminConfigCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream) throws Exception {
        try {
            params = commandLineArgs;
            if (printStream != null) {
                AdminConfigCommandLineInvoker.printStream = printStream;
            }
            toolHelper = new AdminToolHelper(commandLineArgs);
            this.doCommandline();
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    public AdminConfigCommandLineInvoker(String[] stringArray, PrintStream printStream) throws Exception {
        this(new CommandLineArgs(stringArray), printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        AdminConfigCommandLineInvoker adminConfigCommandLineInvoker = new AdminConfigCommandLineInvoker(stringArray, System.out);
    }

    void storeUserConfig(CommandLineArgs commandLineArgs) throws Exception {
        UsernameAndPassword usernameAndPassword = new UsernameAndPassword(commandLineArgs.getUsername(), commandLineArgs.getPassword().toCharArray());
        if (commandLineArgs.getUserConfig() != null || commandLineArgs.getUserKey() != null) {
            UserConfigFileManager.setUsernameAndPassword(usernameAndPassword, commandLineArgs.getUserConfig(), commandLineArgs.getUserKey(), "weblogic.management");
        } else {
            UserConfigFileManager.setUsernameAndPassword(usernameAndPassword, "weblogic.management");
        }
    }

    void doOperation() throws Exception {
        String string = "";
        switch (params.getOperation()) {
            case 51: {
                this.storeUserConfig(params);
            }
        }
        System.out.println(string);
    }

    private void doCommandline() throws Exception {
        try {
            this.out = new OutputFormatter(printStream, params.isPretty());
            this.doOperation();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(illegalArgumentException);
                AdminToolHelper.printDone = true;
            }
            throw illegalArgumentException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                printStream.println(managementTextTextFormatter.getCouldNotFindInstance(params.getMBeanObjName()));
                AdminToolHelper.printDone = true;
            }
            throw instanceNotFoundException;
        }
        catch (IOException iOException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(managementTextTextFormatter.getErrorWriting(), iOException);
                AdminToolHelper.printDone = true;
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (exception instanceof ClassCastException) {
                return;
            }
            if (!params.showNoMessages() && !AdminToolHelper.printDone) {
                AdminToolHelper.printException(exception);
                AdminToolHelper.printDone = true;
            }
            throw exception;
        }
    }
}

