/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.File;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.common.T3User;
import weblogic.jndi.Environment;
import weblogic.kernel.Kernel;
import weblogic.management.MBeanHome;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.UserConfigFileManager;
import weblogic.security.UsernameAndPassword;
import weblogic.security.internal.BootProperties;
import weblogic.security.internal.SerializedSystemIni;

public class AdminToolHelper {
    private static final boolean debug = false;
    public static boolean printDone = false;
    public static boolean shutdownCommand = false;
    static CommandLineArgs params = null;
    static PrintStream printStream = System.out;
    private static boolean CONTINUE = true;
    private boolean EXIT = false;

    public AdminToolHelper(CommandLineArgs commandLineArgs) throws Exception {
        params = commandLineArgs;
    }

    public void evaluateCredentials() {
        Object object;
        String string;
        File file;
        if (params.getOperation() == 41) {
            return;
        }
        if (params.getUsername() != null && params.getPassword() != null) {
            return;
        }
        UsernameAndPassword usernameAndPassword = null;
        usernameAndPassword = params.getUserConfig() != null || params.getUserKey() != null ? UserConfigFileManager.getUsernameAndPassword(params.getUserConfig(), params.getUserKey(), "weblogic.management") : UserConfigFileManager.getUsernameAndPassword("weblogic.management");
        if (usernameAndPassword != null && usernameAndPassword.isUsernameSet() && usernameAndPassword.isPasswordSet()) {
            params.setUsername(usernameAndPassword.getUsername());
            params.setPassword(new String(usernameAndPassword.getPassword()));
        }
        if (!(file = new File(string = System.getProperty("weblogic.system.BootIdentityFile", "boot.properties"))).exists()) {
            object = params.getServerName();
            if (object == null) {
                return;
            }
            file = new File("./servers/" + (String)object + "/boot.properties");
        }
        if (file.exists() && SerializedSystemIni.exists()) {
            BootProperties.load(string, false);
            object = BootProperties.getBootProperties();
            if (((BootProperties)object).getOneClient().length() == 0) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                printStream.println(managementTextTextFormatter.getNoUserNameNoPassword());
                printStream.println(CommandLineArgs.getUsageString());
                return;
            }
            params.setUsername(((BootProperties)object).getOneClient());
            params.setPassword(((BootProperties)object).getTwoClient());
            params.setUsingBootProperties(true);
            BootProperties.unload(false);
        }
    }

    public static void printErrorMessage(String string, boolean bl) {
        if (null != string) {
            System.err.println("\n" + string);
        }
        if (!bl) {
            return;
        }
    }

    public static void printException(String string, Exception exception, boolean bl) {
        Object object;
        if (bl) {
            printStream.println((null == string ? "" : string) + exception.getClass().getName() + ": " + exception);
        } else {
            int n;
            object = exception.getMessage();
            if (object != null && (n = ((String)object).indexOf("Start server side stack trace:")) != -1) {
                object = ((String)object).substring(0, n);
            }
            if (null == string) {
                AdminToolHelper.printErrorMessage((String)object, CONTINUE);
            } else {
                AdminToolHelper.printErrorMessage(string + " : " + (String)object, CONTINUE);
            }
        }
        if (exception instanceof RuntimeErrorException) {
            object = (RuntimeErrorException)exception;
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            printStream.println(managementTextTextFormatter.getPrintExceptionErr() + ((RuntimeErrorException)object).getTargetError());
        } else if (exception instanceof RuntimeOperationsException) {
            object = (RuntimeOperationsException)exception;
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            printStream.println(managementTextTextFormatter.getPrintExceptionExp() + ((RuntimeOperationsException)object).getTargetException());
        }
        if (bl) {
            exception.printStackTrace();
        }
    }

    public static void printException(String string, Exception exception) {
        AdminToolHelper.printException(string, exception, false);
    }

    public static void printException(Exception exception, boolean bl) {
        AdminToolHelper.printException(null, exception, bl);
    }

    public static void printException(Exception exception) {
        AdminToolHelper.printException(null, exception);
    }

    public int nextArg(int n, int n2) {
        try {
            return Integer.parseInt(this.nextArg("" + n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public String nextArg(String string, int n) {
        try {
            return params.getPositionalArg(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return string;
        }
    }

    public boolean nextArg(boolean bl, int n) {
        String string = this.nextArg("" + bl, n);
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("1")) {
            return true;
        }
        return string.equalsIgnoreCase("yes");
    }

    public static Context getInitialContext(String string, T3User t3User) throws NamingException {
        Environment environment = new Environment();
        environment.setProviderUrl(string);
        environment.setSecurityCredentials(t3User);
        return environment.getInitialContext();
    }

    public static Context getInitialContext(String string, String string2, String string3) throws Exception {
        Object var3_3 = null;
        try {
            Environment environment = new Environment();
            environment.setProviderUrl(string);
            environment.setSecurityPrincipal(string2);
            environment.setSecurityCredentials(string3);
            return environment.getInitialContext();
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                printDone = true;
                CommunicationException communicationException = (CommunicationException)exception;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getFailedConnect(string) + " [" + communicationException.getRootCause().getMessage() + "]", CONTINUE);
            }
            throw exception;
        }
    }

    public static Context getInitialContext(CommandLineArgs commandLineArgs) throws Exception {
        Context context = null;
        Environment environment = new Environment();
        String string = commandLineArgs.getURL();
        try {
            if (commandLineArgs.isIIOP()) {
                if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                    System.setProperty("weblogic.system.iiop.enableClient", "false");
                }
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                hashtable.put("java.naming.provider.url", string);
                hashtable.put("java.naming.security.principal", commandLineArgs.getUsername());
                hashtable.put("java.naming.security.credentials", commandLineArgs.getPassword());
                long l = AdminToolHelper.getTimeout(commandLineArgs);
                if (l > 0L) {
                    hashtable.put("weblogic.jndi.requestTimeout", l);
                    hashtable.put("weblogic.rmi.clientTimeout", l);
                }
                context = new InitialContext(hashtable);
                return context;
            }
            if (!Kernel.isServer()) {
                environment.setProviderUrl(string);
                environment.setSecurityPrincipal(commandLineArgs.getUsername());
                environment.setSecurityCredentials(commandLineArgs.getPassword());
                long l = AdminToolHelper.getTimeout(commandLineArgs);
                if (l > 0L) {
                    environment.setRequestTimeout(l);
                    environment.setRMIClientTimeout(l);
                }
            }
            context = environment.getInitialContext();
            return context;
        }
        catch (Exception exception) {
            if (exception instanceof CommunicationException) {
                printDone = true;
                CommunicationException communicationException = (CommunicationException)exception;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                AdminToolHelper.printErrorMessage(managementTextTextFormatter.getFailedConnect(string) + " [" + communicationException.getRootCause().getMessage() + "]", CONTINUE);
            }
            throw exception;
        }
    }

    public static MBeanHome getMBeanHome(String string, String string2, String string3, boolean bl) throws Exception {
        MBeanHome mBeanHome = null;
        try {
            Environment environment = new Environment();
            Context context = null;
            if (params.isIIOP()) {
                if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                    System.setProperty("weblogic.system.iiop.enableClient", "false");
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                hashtable.put("java.naming.provider.url", string);
                hashtable.put("java.naming.security.principal", string2);
                hashtable.put("java.naming.security.credentials", string3);
                context = new InitialContext(hashtable);
            } else {
                if (!Kernel.isServer()) {
                    environment.setProviderUrl(string);
                    environment.setSecurityPrincipal(string2);
                    environment.setSecurityCredentials(string3);
                }
                context = environment.getInitialContext();
            }
            mBeanHome = bl ? (MBeanHome)context.lookup("weblogic.management.home.localhome") : (params.getAdminUrl() != null ? (MBeanHome)context.lookup("weblogic.management.adminhome") : (MBeanHome)context.lookup("weblogic.management.home.localhome"));
        }
        catch (AuthenticationException authenticationException) {
            Throwable throwable = authenticationException.getRootCause();
            if (throwable != null) {
                throw (Exception)throwable;
            }
            throw authenticationException;
        }
        catch (CommunicationException communicationException) {
            Throwable throwable = communicationException.getRootCause();
            if (throwable != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                String string4 = throwable.getMessage();
                if (string4 != null && string4.length() > 0) {
                    System.out.println("\n" + managementTextTextFormatter.getFailtedToConnect2(string4));
                    printDone = true;
                }
                throw (Exception)throwable;
            }
            throw communicationException;
        }
        catch (NamingException namingException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getJndiException() + namingException);
        }
        return mBeanHome;
    }

    public static MBeanHome getLocalMBeanHome(CommandLineArgs commandLineArgs) throws Exception {
        MBeanHome mBeanHome = null;
        try {
            Environment environment = new Environment();
            Context context = null;
            String string = commandLineArgs.getURL();
            String string2 = commandLineArgs.getUsername();
            String string3 = commandLineArgs.getPassword();
            if (commandLineArgs.isIIOP()) {
                if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                    System.setProperty("weblogic.system.iiop.enableClient", "false");
                }
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                hashtable.put("java.naming.provider.url", string);
                hashtable.put("java.naming.security.principal", string2);
                hashtable.put("java.naming.security.credentials", string3);
                long l = AdminToolHelper.getTimeout(commandLineArgs);
                if (l > 0L) {
                    hashtable.put("weblogic.jndi.requestTimeout", l);
                    hashtable.put("weblogic.rmi.clientTimeout", l);
                }
                context = new InitialContext(hashtable);
            } else {
                if (!Kernel.isServer()) {
                    environment.setProviderUrl(string);
                    environment.setSecurityPrincipal(string2);
                    environment.setSecurityCredentials(string3);
                    long l = AdminToolHelper.getTimeout(commandLineArgs);
                    if (l > 0L) {
                        environment.setRequestTimeout(l);
                        environment.setRMIClientTimeout(l);
                    }
                }
                context = environment.getInitialContext();
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
        }
        catch (AuthenticationException authenticationException) {
            Throwable throwable = authenticationException.getRootCause();
            if (throwable != null) {
                throw (Exception)throwable;
            }
            throw authenticationException;
        }
        catch (CommunicationException communicationException) {
            Throwable throwable = communicationException.getRootCause();
            if (throwable != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                String string = throwable.getMessage();
                if (string != null && string.length() > 0) {
                    System.out.println("\n" + managementTextTextFormatter.getFailtedToConnect2(string));
                    printDone = true;
                }
                throw (Exception)throwable;
            }
            throw communicationException;
        }
        catch (NamingException namingException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getJndiException() + namingException);
        }
        return mBeanHome;
    }

    public static MBeanHome getMBeanHome(CommandLineArgs commandLineArgs) throws Exception {
        MBeanHome mBeanHome = null;
        try {
            Environment environment = new Environment();
            Context context = null;
            String string = commandLineArgs.getURL();
            if (commandLineArgs.isIIOP()) {
                if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                    System.setProperty("weblogic.system.iiop.enableClient", "false");
                }
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                hashtable.put("java.naming.provider.url", string);
                hashtable.put("java.naming.security.principal", commandLineArgs.getUsername());
                hashtable.put("java.naming.security.credentials", commandLineArgs.getPassword());
                long l = AdminToolHelper.getTimeout(commandLineArgs);
                if (l > 0L) {
                    hashtable.put("weblogic.jndi.requestTimeout", l);
                    hashtable.put("weblogic.rmi.clientTimeout", l);
                }
                context = new InitialContext(hashtable);
            } else {
                if (!Kernel.isServer()) {
                    environment.setProviderUrl(string);
                    environment.setSecurityPrincipal(commandLineArgs.getUsername());
                    environment.setSecurityCredentials(commandLineArgs.getPassword());
                    long l = AdminToolHelper.getTimeout(commandLineArgs);
                    if (l > 0L) {
                        environment.setRequestTimeout(l);
                        environment.setRMIClientTimeout(l);
                    }
                }
                context = environment.getInitialContext();
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
        }
        catch (AuthenticationException authenticationException) {
            Throwable throwable = authenticationException.getRootCause();
            if (throwable != null) {
                throw (Exception)throwable;
            }
            throw authenticationException;
        }
        catch (CommunicationException communicationException) {
            Throwable throwable = communicationException.getRootCause();
            if (throwable != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                String string = throwable.getMessage();
                if (string != null && string.length() > 0) {
                    System.out.println("\n" + managementTextTextFormatter.getFailtedToConnect2(string));
                    printDone = true;
                }
                throw (Exception)throwable;
            }
            throw communicationException;
        }
        catch (NamingException namingException) {
            Throwable throwable = namingException.getCause();
            if (throwable != null && throwable instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)throwable;
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println("\nFailed to connect: " + throwable.getMessage());
                printDone = true;
                throw namingException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getJndiException() + namingException);
        }
        return mBeanHome;
    }

    public static MBeanHome getAdminMBeanHome(CommandLineArgs commandLineArgs) throws Exception {
        MBeanHome mBeanHome = null;
        try {
            Object object;
            Environment environment = new Environment();
            Context context = null;
            String string = commandLineArgs.getAdminUrl();
            String string2 = null;
            string2 = string != null ? string : commandLineArgs.getURL();
            if (commandLineArgs.isIIOP()) {
                if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
                    System.setProperty("weblogic.system.iiop.enableClient", "false");
                }
                object = new Hashtable<String, String>();
                ((Hashtable)object).put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                ((Hashtable)object).put("java.naming.provider.url", string2);
                ((Hashtable)object).put("java.naming.security.principal", commandLineArgs.getUsername());
                ((Hashtable)object).put("java.naming.security.credentials", commandLineArgs.getPassword());
                long l = AdminToolHelper.getTimeout(commandLineArgs);
                if (l > 0L) {
                    ((Hashtable)object).put("weblogic.jndi.requestTimeout", l);
                    ((Hashtable)object).put("weblogic.rmi.clientTimeout", l);
                }
                context = new InitialContext((Hashtable<?, ?>)object);
            } else {
                if (!Kernel.isServer()) {
                    environment.setProviderUrl(string2);
                    environment.setSecurityPrincipal(commandLineArgs.getUsername());
                    environment.setSecurityCredentials(commandLineArgs.getPassword());
                    long l = AdminToolHelper.getTimeout(commandLineArgs);
                    if (l > 0L) {
                        environment.setRequestTimeout(l);
                        environment.setRMIClientTimeout(l);
                    }
                }
                context = environment.getInitialContext();
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            object = mBeanHome.getMBeansByType("ServerRuntime").iterator();
            ServerRuntimeMBean serverRuntimeMBean = (ServerRuntimeMBean)object.next();
            if (!serverRuntimeMBean.isAdminServer()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println("\n" + managementTextTextFormatter.getInvalidadminurl(string2));
                throw new Exception();
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
        }
        catch (AuthenticationException authenticationException) {
            Throwable throwable = authenticationException.getRootCause();
            if (throwable != null) {
                throw (Exception)throwable;
            }
            throw authenticationException;
        }
        catch (CommunicationException communicationException) {
            Throwable throwable = communicationException.getRootCause();
            if (throwable != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                String string = throwable.getMessage();
                if (string != null && string.length() > 0) {
                    System.out.println("\n" + managementTextTextFormatter.getFailtedToConnect2(string));
                    printDone = true;
                }
                throw (Exception)throwable;
            }
            throw communicationException;
        }
        catch (NamingException namingException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getJndiException() + namingException);
        }
        return mBeanHome;
    }

    public static MBeanHome getAdminMBeanHome(String string, String string2, String string3) throws Exception {
        MBeanHome mBeanHome = null;
        try {
            Context context;
            Iterator iterator;
            ServerRuntimeMBean serverRuntimeMBean;
            Environment environment = new Environment();
            if (!Kernel.isServer()) {
                environment.setProviderUrl(string);
                environment.setSecurityPrincipal(string2);
                environment.setSecurityCredentials(string3);
            }
            if (!(serverRuntimeMBean = (ServerRuntimeMBean)(iterator = (mBeanHome = (MBeanHome)(context = environment.getInitialContext()).lookup("weblogic.management.home.localhome")).getMBeansByType("ServerRuntime").iterator()).next()).isAdminServer()) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println("\n" + managementTextTextFormatter.getInvalidadminurl(string));
                throw new Exception();
            }
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
        }
        catch (AuthenticationException authenticationException) {
            Throwable throwable = authenticationException.getRootCause();
            if (throwable != null) {
                throw (Exception)throwable;
            }
            throw authenticationException;
        }
        catch (CommunicationException communicationException) {
            Throwable throwable = communicationException.getRootCause();
            if (throwable != null) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                String string4 = throwable.getMessage();
                if (string4 != null && string4.length() > 0) {
                    System.out.println("\n" + managementTextTextFormatter.getFailtedToConnect2(string4));
                    printDone = true;
                }
                throw (Exception)throwable;
            }
            throw communicationException;
        }
        catch (NamingException namingException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            throw new IllegalArgumentException(managementTextTextFormatter.getJndiException() + namingException);
        }
        return mBeanHome;
    }

    public boolean isNextArgInt(int n) {
        try {
            int n2 = Integer.parseInt(this.nextArg("", n));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static long getTimeout(CommandLineArgs commandLineArgs) {
        long l = 0L;
        try {
            switch (commandLineArgs.getOperation()) {
                case 2: {
                    l = commandLineArgs.isTimeoutSet() ? (long)commandLineArgs.getTimeout() : 30L;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l * 1000L;
    }
}

