/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.cluster.singleton.ServerMigrationCoordinator;
import weblogic.cluster.singleton.ServerMigrationException;
import weblogic.common.T3Client;
import weblogic.management.MBeanHome;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.commandline.tools.ClusterValidatorInvoker;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JTAMigratableTargetMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.runtime.MigratableServiceCoordinatorRuntimeMBean;
import weblogic.management.runtime.MigrationException;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;

public final class ClusterAdminCommandLineInvoker {
    static final String OK_STRING = "Ok";
    static CommandLineArgs params = null;
    static PrintWriter printLog = null;
    static T3Client t3 = null;
    static AdminToolHelper toolHelper = null;
    MBeanHome adminHome = null;
    Context ctx = null;
    OutputFormatter out = null;
    private static PrintStream printStream = System.out;

    public ClusterAdminCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream) throws Exception {
        try {
            params = commandLineArgs;
            if (printStream != null) {
                ClusterAdminCommandLineInvoker.printStream = printStream;
            }
            toolHelper = new AdminToolHelper(commandLineArgs);
            this.doCommandline();
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    public ClusterAdminCommandLineInvoker(String[] stringArray, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = new CommandLineArgs(stringArray);
        if (printStream != null) {
            ClusterAdminCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        toolHelper = new AdminToolHelper(params);
        this.doCommandline();
    }

    public ClusterAdminCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = commandLineArgs;
        if (printStream != null) {
            ClusterAdminCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        toolHelper = new AdminToolHelper(params);
        this.doCommandline();
    }

    public ClusterAdminCommandLineInvoker(String[] stringArray, PrintStream printStream) throws Exception {
        this(new CommandLineArgs(stringArray), printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        ClusterAdminCommandLineInvoker clusterAdminCommandLineInvoker = new ClusterAdminCommandLineInvoker(stringArray, System.out);
    }

    static void executeClusterStart(CommandLineArgs commandLineArgs) throws Exception {
        int n;
        int n2;
        ServerMBean[] serverMBeanArray;
        Context context = null;
        MBeanHome mBeanHome = null;
        ClusterMBean clusterMBean = null;
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string = commandLineArgs.getClusterName();
        try {
            context = ClusterAdminCommandLineInvoker.getInitialContext(commandLineArgs);
        }
        catch (Exception exception) {
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
            }
            throw exception;
        }
        mBeanHome = AdminToolHelper.getAdminMBeanHome(commandLineArgs);
        Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
        ServerRuntimeMBean serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
        if (!serverRuntimeMBean.isAdminServer()) {
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getAdminServerUrlRequired(commandLineArgs.getURL()));
            }
            throw new Exception();
        }
        Set set = mBeanHome.getMBeansByType("Cluster");
        boolean bl = false;
        if (string != null) {
            try {
                clusterMBean = (ClusterMBean)mBeanHome.getAdminMBean(string, "Cluster");
                bl = true;
            }
            catch (Exception exception) {
                System.out.println(managementTextTextFormatter.getNoclusterDefined(string));
                AdminToolHelper.printDone = true;
                throw exception;
            }
        } else {
            System.out.println("\n" + managementTextTextFormatter.getSpecCN());
            System.out.println(commandLineArgs.getUsageString());
            AdminToolHelper.printDone = true;
            throw new Exception();
        }
        if (set.size() == 0) {
            System.out.println(managementTextTextFormatter.getNoClustersDefined());
            throw new Exception();
        }
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> hashMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>();
        if (bl) {
            serverMBeanArray = clusterMBean.getServers();
            try {
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    ServerMBean serverMBean = serverMBeanArray[i];
                    hashMap.put(serverMBean.getName(), ((ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(serverMBean.getName(), "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName())).start());
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception);
                throw new RuntimeOperationsException(runtimeException);
            }
        }
        serverMBeanArray = clusterMBean.getServers();
        String[] stringArray = new String[serverMBeanArray.length];
        for (n2 = 0; n2 < serverMBeanArray.length; ++n2) {
            stringArray[n2] = serverMBeanArray[n2].getName();
        }
        System.out.println("\n" + managementTextTextFormatter.getstartingServersInCluster() + " " + string + ": " + StringUtils.join((String[])stringArray, (String)","));
        n2 = 0;
        for (n = 0; n < serverMBeanArray.length; ++n) {
            ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = (ServerLifeCycleTaskRuntimeMBean)hashMap.get(serverMBeanArray[n].getName());
            if (serverLifeCycleTaskRuntimeMBean == null || !serverLifeCycleTaskRuntimeMBean.isRunning()) continue;
            do {
                Thread.sleep(1000L);
            } while (serverLifeCycleTaskRuntimeMBean.isRunning());
            n2 = 1;
        }
        if (n2 != 0) {
            n = 1;
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                try {
                    if (((ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(stringArray[i], "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName())).getState().equals("RUNNING")) continue;
                    System.out.println("Unable to start Managed server " + stringArray[i]);
                    n = 0;
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Unable to start Managed server " + stringArray[i]);
                    n = 0;
                }
            }
            if (n == 0) {
                System.out.println("\nUnable to start some of the servers in the cluster " + string + ". Please check if the Node Manager is up and running.");
                AdminToolHelper.printDone = true;
                throw new Exception("Cluster could not be started");
            }
        } else {
            System.out.println("\nNone of the servers in the cluster " + string + " could be started. Please check if the Node Manager is up and running.");
            AdminToolHelper.printDone = true;
            throw new Exception("Cluster could not be started");
        }
        System.out.println("\nAll servers in the cluster " + string + " are started successfully.");
    }

    static void executeClusterStop(CommandLineArgs commandLineArgs) throws Exception {
        int n;
        ServerMBean[] serverMBeanArray;
        Context context = null;
        MBeanHome mBeanHome = commandLineArgs.getAdminHome();
        ClusterMBean clusterMBean = null;
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string = commandLineArgs.getClusterName();
        try {
            context = ClusterAdminCommandLineInvoker.getInitialContext(commandLineArgs);
        }
        catch (Exception exception) {
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
            }
            throw exception;
        }
        mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
        Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
        ServerRuntimeMBean serverRuntimeMBean = (ServerRuntimeMBean)iterator.next();
        if (!serverRuntimeMBean.isAdminServer()) {
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getAdminServerUrlRequired(commandLineArgs.getURL()));
            }
            throw new Exception();
        }
        Set set = mBeanHome.getMBeansByType("Cluster");
        boolean bl = false;
        if (string != null) {
            try {
                clusterMBean = (ClusterMBean)mBeanHome.getAdminMBean(string, "Cluster");
                bl = true;
            }
            catch (Exception exception) {
                System.out.println(managementTextTextFormatter.getNoclusterDefined(string));
                AdminToolHelper.printDone = true;
                throw exception;
            }
        } else {
            System.out.println("\n" + managementTextTextFormatter.getspecCNS());
            System.out.println(commandLineArgs.getUsageString());
            AdminToolHelper.printDone = true;
            throw new Exception();
        }
        if (set.size() == 0) {
            System.out.println(managementTextTextFormatter.getNoClustersDefined());
            throw new Exception();
        }
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> hashMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>();
        if (bl) {
            serverMBeanArray = clusterMBean.getServers();
            try {
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    ServerMBean serverMBean = serverMBeanArray[i];
                    hashMap.put(serverMBean.getName(), ((ServerLifeCycleRuntimeMBean)mBeanHome.getMBean(serverMBean.getName(), "ServerLifeCycleRuntime", mBeanHome.getActiveDomain().getName())).forceShutdown());
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception);
                throw new RuntimeOperationsException(runtimeException);
            }
        }
        serverMBeanArray = clusterMBean.getServers();
        String[] stringArray = new String[serverMBeanArray.length];
        for (n = 0; n < serverMBeanArray.length; ++n) {
            stringArray[n] = serverMBeanArray[n].getName();
        }
        System.out.println("\n" + managementTextTextFormatter.getSDC() + " " + string + ": " + StringUtils.join((String[])stringArray, (String)","));
        for (n = 0; n < serverMBeanArray.length; ++n) {
            ServerLifeCycleTaskRuntimeMBean serverLifeCycleTaskRuntimeMBean = (ServerLifeCycleTaskRuntimeMBean)hashMap.get(serverMBeanArray[n].getName());
            if (serverLifeCycleTaskRuntimeMBean == null || !serverLifeCycleTaskRuntimeMBean.isRunning()) continue;
            do {
                Thread.sleep(1000L);
            } while (serverLifeCycleTaskRuntimeMBean.isRunning());
        }
        System.out.println("\n" + managementTextTextFormatter.getSDCS(string));
    }

    static void executeClusterPing(CommandLineArgs commandLineArgs) throws Exception {
        Context context = null;
        MBeanHome mBeanHome = null;
        ClusterMBean clusterMBean = null;
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string = commandLineArgs.getClusterName();
        try {
            context = ClusterAdminCommandLineInvoker.getInitialContext(commandLineArgs);
            mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
        }
        catch (Exception exception) {
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + exception + "]");
            }
            throw exception;
        }
        if (string != null) {
            try {
                clusterMBean = (ClusterMBean)mBeanHome.getAdminMBean(string, "Cluster");
            }
            catch (Exception exception) {
                System.out.println(managementTextTextFormatter.getNoclusterDefined(string));
                AdminToolHelper.printDone = true;
                throw exception;
            }
        }
        try {
            if (clusterMBean != null) {
                ClusterAdminCommandLineInvoker.getClusterInfo(mBeanHome, clusterMBean);
            } else {
                Set set = mBeanHome.getMBeansByType("Cluster");
                Iterator iterator = set.iterator();
                if (set.size() == 0) {
                    System.out.println(managementTextTextFormatter.getNoClustersDefined());
                } else {
                    while (iterator.hasNext()) {
                        clusterMBean = (ClusterMBean)iterator.next();
                        ClusterAdminCommandLineInvoker.getClusterInfo(mBeanHome, clusterMBean);
                    }
                }
            }
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + (Object)((Object)remoteRuntimeException) + "]");
            }
            throw remoteRuntimeException;
        }
    }

    static void getClusterInfo(MBeanHome mBeanHome, ClusterMBean clusterMBean) {
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        String string = clusterMBean.getName();
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        String[] stringArray = new String[serverMBeanArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        System.out.println("\nThere are " + clusterMBean.getServers().length + " server(s) in cluster: " + string);
        Set set = mBeanHome.getMBeansByType("ServerLifeCycleRuntime");
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            stringArray[i] = serverMBeanArray[i].getName();
            arrayList.add(serverMBeanArray[i].getName());
            for (ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean : set) {
                String string2 = serverLifeCycleRuntimeMBean.getName();
                String string3 = "";
                if (!string2.equals(stringArray[i])) continue;
                string3 = serverLifeCycleRuntimeMBean.getState();
                hashMap.put(stringArray[i], string3);
                arrayList2.add(stringArray[i]);
                arrayList.remove(stringArray[i]);
            }
        }
        String[] stringArray2 = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringArray2[i] = (String)arrayList2.get(i);
        }
        if (stringArray2.length != 0) {
            System.out.println("\n" + managementTextTextFormatter.getaliveServersStates());
            String[] stringArray3 = new String[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                stringArray3[i] = (String)arrayList2.get(i);
                System.out.println(stringArray3[i] + "---" + hashMap.get(stringArray3[i]));
            }
        }
        if (!arrayList.isEmpty()) {
            String string4 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                string4 = string4 + "\n" + (String)arrayList.get(i);
            }
            System.out.println("\nThe other server(s) in the cluster that are not active are: \n" + string4);
        }
    }

    private void doMigrate() throws Exception {
        block34: {
            ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
            try {
                int n;
                int n2;
                Object object;
                MBeanServerConnection mBeanServerConnection = this.getRuntimeMBeanServerConnection(params);
                MigratableServiceCoordinatorRuntimeMBean migratableServiceCoordinatorRuntimeMBean = null;
                DomainRuntimeServiceMBean domainRuntimeServiceMBean = null;
                DomainMBean domainMBean = null;
                try {
                    domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
                    migratableServiceCoordinatorRuntimeMBean = domainRuntimeServiceMBean.getDomainRuntime().getMigratableServiceCoordinatorRuntime();
                    domainMBean = domainRuntimeServiceMBean.getDomainConfiguration();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (domainRuntimeServiceMBean == null) {
                    throw new AssertionError((Object)"Failed to locate domain runtime service");
                }
                if (migratableServiceCoordinatorRuntimeMBean == null) {
                    throw new AssertionError((Object)"coordinator must not be null");
                }
                MigratableTargetMBean migratableTargetMBean = null;
                SingletonServiceMBean singletonServiceMBean = null;
                String string = params.getMigratableTargetName();
                String string2 = params.getSingletonServiceName();
                if (string != null) {
                    if (params.getMigrateJTA()) {
                        object = domainMBean.getServers();
                        for (n2 = 0; n2 < ((ServerMBean[])object).length; ++n2) {
                            if (!object[n2].getName().equals(string)) continue;
                            migratableTargetMBean = object[n2].getJTAMigratableTarget();
                        }
                    } else {
                        migratableTargetMBean = ClusterAdminCommandLineInvoker.getMigratableTarget(domainMBean, string);
                    }
                    singletonServiceMBean = ClusterAdminCommandLineInvoker.getSingletonService(domainMBean, string);
                } else if (string2 != null) {
                    singletonServiceMBean = ClusterAdminCommandLineInvoker.getSingletonService(domainMBean, string2);
                }
                object = ClusterAdminCommandLineInvoker.getServer(domainMBean, params.getDestinationServerName());
                if (migratableTargetMBean == null && singletonServiceMBean == null && !params.showNoMessages() && !AdminToolHelper.printDone) {
                    printStream.println(managementTextTextFormatter.getMigrationUnknownMigratableTarget(params.getMigratableTargetName()));
                    AdminToolHelper.printDone = true;
                    return;
                }
                if (object == null && !params.showNoMessages() && !AdminToolHelper.printDone) {
                    printStream.println(managementTextTextFormatter.getMigrationUnknownDestinationServer(params.getDestinationServerName()));
                    AdminToolHelper.printDone = true;
                    return;
                }
                n2 = 0;
                String string3 = null;
                if (migratableTargetMBean != null) {
                    for (n = 0; n < migratableTargetMBean.getAllCandidateServers().length && n2 == 0; ++n) {
                        n2 = migratableTargetMBean.getAllCandidateServers()[n].getName().equals(object.getName()) ? 1 : 0;
                    }
                    string3 = migratableTargetMBean.getName();
                } else {
                    for (n = 0; n < singletonServiceMBean.getAllCandidateServers().length && n2 == 0; ++n) {
                        n2 = singletonServiceMBean.getAllCandidateServers()[n].getName().equals(object.getName()) ? 1 : 0;
                    }
                    string3 = singletonServiceMBean.getName();
                }
                if (n2 == 0) {
                    if (migratableTargetMBean != null && migratableTargetMBean.getConstrainedCandidateServers().length > 0) {
                        if (!params.showNoMessages()) {
                            printStream.println(managementTextTextFormatter.getMigrationErrorDestinationNotAmongCandidateServers(params.getDestinationServerName(), params.getMigratableTargetName()));
                        }
                    } else if (!params.showNoMessages()) {
                        printStream.println(managementTextTextFormatter.getMigrationErrorDestinationNotAmongClusterMembers(params.getDestinationServerName(), params.getMigratableTargetName()));
                    }
                    break block34;
                }
                try {
                    if (!params.showNoMessages()) {
                        printStream.println(managementTextTextFormatter.getMigrationStarted(params.getMigrateJTA() ? managementTextTextFormatter.getMigrationJTAPrefix() : "", string3, params.getDestinationServerName()));
                    }
                    if (singletonServiceMBean != null) {
                        migratableServiceCoordinatorRuntimeMBean.migrateSingleton(singletonServiceMBean, (ServerMBean)object);
                    } else if (params.getMigrateJTA()) {
                        migratableServiceCoordinatorRuntimeMBean.migrateJTA(migratableTargetMBean, (ServerMBean)object, !params.getSourceDown(), !params.getDestinationDown());
                    } else {
                        migratableServiceCoordinatorRuntimeMBean.migrate(migratableTargetMBean, (ServerMBean)object, !params.getSourceDown(), !params.getDestinationDown());
                    }
                    if (!params.showNoMessages()) {
                        printStream.println(managementTextTextFormatter.getMigrationSucceeded(params.getMigrateJTA() ? managementTextTextFormatter.getMigrationJTAPrefix() : ""));
                    }
                    if (!params.showNoMessages()) {
                        this.out.println(OK_STRING);
                    }
                }
                catch (MigrationException migrationException) {
                    if (!AdminToolHelper.printDone) {
                        printStream.println(managementTextTextFormatter.getMigrationFailed(params.getMigrateJTA() ? managementTextTextFormatter.getMigrationJTAPrefix() : "", migrationException.getMessage()));
                        AdminToolHelper.printDone = true;
                    }
                    throw migrationException;
                }
            }
            catch (Exception exception) {
                if (!params.showNoMessages() && !AdminToolHelper.printDone) {
                    printStream.println("Internal problem: " + exception);
                    printStream.println(StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    AdminToolHelper.printDone = true;
                }
                throw exception;
            }
        }
    }

    private void doMigrateAll() throws Exception {
        int n;
        ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
        MBeanServerConnection mBeanServerConnection = this.getRuntimeMBeanServerConnection(params);
        MigratableServiceCoordinatorRuntimeMBean migratableServiceCoordinatorRuntimeMBean = null;
        DomainRuntimeServiceMBean domainRuntimeServiceMBean = null;
        DomainMBean domainMBean = null;
        try {
            domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
            migratableServiceCoordinatorRuntimeMBean = domainRuntimeServiceMBean.getDomainRuntime().getMigratableServiceCoordinatorRuntime();
            domainMBean = domainRuntimeServiceMBean.getDomainConfiguration();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (migratableServiceCoordinatorRuntimeMBean == null) {
            throw new AssertionError((Object)"coordinator must not be null");
        }
        ServerMBean serverMBean = domainMBean.lookupServer(params.getSourceServerName());
        if (serverMBean == null && !params.showNoMessages() && !AdminToolHelper.printDone) {
            printStream.println("Couldn't locate '" + params.getSourceServerName() + "' server in the domain");
            AdminToolHelper.printDone = true;
            return;
        }
        if (serverMBean.getCluster() == null && !params.showNoMessages() && !AdminToolHelper.printDone) {
            printStream.println("Server '" + params.getSourceServerName() + "' does not belong to a cluster. To migrate servers should" + " be part of a cluster");
            AdminToolHelper.printDone = true;
            return;
        }
        String string = params.getDestinationServerName();
        ServerMBean serverMBean2 = ClusterAdminCommandLineInvoker.getServer(domainMBean, string);
        if (serverMBean2 == null && !params.showNoMessages() && !AdminToolHelper.printDone) {
            printStream.println(managementTextTextFormatter.getMigrationUnknownDestinationServer(params.getDestinationServerName()));
            AdminToolHelper.printDone = true;
            return;
        }
        JTAMigratableTargetMBean jTAMigratableTargetMBean = serverMBean.getJTAMigratableTarget();
        if (!this.verifyServiceMigration(jTAMigratableTargetMBean, serverMBean2, managementTextTextFormatter)) {
            return;
        }
        MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
        ArrayList<MigratableTargetMBean> arrayList = new ArrayList<MigratableTargetMBean>();
        String string2 = params.getSourceServerName();
        for (n = 0; n < migratableTargetMBeanArray.length; ++n) {
            if (!migratableTargetMBeanArray[n].getUserPreferredServer().getName().equals(string2)) continue;
            if (!this.verifyServiceMigration(migratableTargetMBeanArray[n], serverMBean2, managementTextTextFormatter)) {
                return;
            }
            arrayList.add(migratableTargetMBeanArray[n]);
        }
        n = arrayList.size();
        try {
            migratableServiceCoordinatorRuntimeMBean.migrateJTA(jTAMigratableTargetMBean, serverMBean2, !params.getSourceDown(), !params.getDestinationDown());
            for (int i = 0; i < n; ++i) {
                migratableServiceCoordinatorRuntimeMBean.migrate((MigratableTargetMBean)arrayList.get(i), serverMBean2, !params.getSourceDown(), !params.getDestinationDown());
            }
        }
        catch (MigrationException migrationException) {
            if (!AdminToolHelper.printDone) {
                printStream.println(managementTextTextFormatter.getMigrationFailed(params.getMigrateJTA() ? managementTextTextFormatter.getMigrationJTAPrefix() : "", migrationException.getMessage()));
                AdminToolHelper.printDone = true;
            }
            throw migrationException;
        }
    }

    private boolean verifyServiceMigration(MigratableTargetMBean migratableTargetMBean, ServerMBean serverMBean, ManagementTextTextFormatter managementTextTextFormatter) {
        boolean bl = false;
        for (int i = 0; i < migratableTargetMBean.getAllCandidateServers().length && !bl; ++i) {
            bl = migratableTargetMBean.getAllCandidateServers()[i].getName().equals(serverMBean.getName());
        }
        if (!bl) {
            if (migratableTargetMBean.getConstrainedCandidateServers().length > 0) {
                if (!params.showNoMessages()) {
                    printStream.println(managementTextTextFormatter.getMigrationErrorDestinationNotAmongCandidateServers(params.getDestinationServerName(), migratableTargetMBean.getName()));
                }
            } else if (!params.showNoMessages()) {
                printStream.println(managementTextTextFormatter.getMigrationErrorDestinationNotAmongClusterMembers(params.getDestinationServerName(), migratableTargetMBean.getName()));
            }
        }
        return true;
    }

    private static MigratableTargetMBean getMigratableTarget(DomainMBean domainMBean, String string) {
        MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
        if (migratableTargetMBeanArray != null) {
            for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
                if (!migratableTargetMBeanArray[i].getName().equals(string)) continue;
                return migratableTargetMBeanArray[i];
            }
        }
        return null;
    }

    private static SingletonServiceMBean getSingletonService(DomainMBean domainMBean, String string) {
        SingletonServiceMBean[] singletonServiceMBeanArray = domainMBean.getSingletonServices();
        if (singletonServiceMBeanArray != null) {
            for (int i = 0; i < singletonServiceMBeanArray.length; ++i) {
                if (!singletonServiceMBeanArray[i].getName().equals(string)) continue;
                return singletonServiceMBeanArray[i];
            }
        }
        return null;
    }

    private static ServerMBean getServer(DomainMBean domainMBean, String string) {
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!serverMBeanArray[i].getName().equals(string)) continue;
            return serverMBeanArray[i];
        }
        return null;
    }

    static void executeValidateCluster(CommandLineArgs commandLineArgs) throws Exception {
        String string = commandLineArgs.getConfigPath();
        if (string == null) {
            System.out.println("Please specify a valid path.");
            System.out.println(commandLineArgs.getUsageString());
            throw new Exception();
        }
        ClusterValidatorInvoker clusterValidatorInvoker = new ClusterValidatorInvoker();
        String[] stringArray = new String[]{string};
        ClusterValidatorInvoker.main(stringArray);
    }

    void doOperation() throws Exception {
        String string = "";
        switch (params.getOperation()) {
            case 39: {
                ClusterAdminCommandLineInvoker.executeClusterStart(params);
                break;
            }
            case 40: {
                ClusterAdminCommandLineInvoker.executeClusterStop(params);
                break;
            }
            case 50: {
                this.doMigrate();
                break;
            }
            case 53: {
                this.doMigrateAll();
                break;
            }
            case 52: {
                this.doManualMigration(params);
                break;
            }
            case 41: {
                ClusterAdminCommandLineInvoker.executeValidateCluster(params);
                break;
            }
            case 37: {
                ClusterAdminCommandLineInvoker.executeClusterPing(params);
            }
        }
        System.out.println(string);
    }

    private void doCommandline() throws Exception {
        try {
            if (params.getOperation() != 41) {
                if (this.adminHome == null) {
                    if (params.getAdminUrl() != null) {
                        params.setUrl(params.getAdminUrl());
                        this.adminHome = AdminToolHelper.getAdminMBeanHome(params);
                    } else {
                        this.adminHome = AdminToolHelper.getMBeanHome(params);
                    }
                } else {
                    this.adminHome = AdminToolHelper.getMBeanHome(params);
                }
            }
            this.out = new OutputFormatter(printStream, params.isPretty());
            this.doOperation();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(illegalArgumentException);
                AdminToolHelper.printDone = true;
            }
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(malformedObjectNameException, true);
                AdminToolHelper.printDone = true;
            }
            printStream.println("Usage:\n" + CommandLineArgs.getUsageString());
            throw malformedObjectNameException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                printStream.println(managementTextTextFormatter.getCouldNotFindInstance(params.getMBeanObjName()));
                AdminToolHelper.printDone = true;
            }
            throw instanceNotFoundException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            Throwable throwable = remoteRuntimeException.getNestedException();
            if (throwable instanceof PeerGoneException) {
                System.out.println("Lost connectivity to the adminstration server");
                return;
            }
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException((Exception)((Object)remoteRuntimeException), true);
                AdminToolHelper.printDone = true;
            }
            throw remoteRuntimeException;
        }
        catch (ConnectException connectException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException("java.net.ConnectException", connectException);
                AdminToolHelper.printDone = true;
            }
            throw connectException;
        }
        catch (IOException iOException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(managementTextTextFormatter.getErrorWriting(), iOException);
                AdminToolHelper.printDone = true;
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeOperationsException) {
                RuntimeOperationsException runtimeOperationsException = (RuntimeOperationsException)exception;
                if (runtimeOperationsException.getTargetException() instanceof RemoteRuntimeException) {
                    System.out.println("Lost connectivity to the adminstration server.");
                }
            }
            if (exception instanceof ClassCastException) {
                System.out.println("Lost connectivity to the adminstration server..");
                return;
            }
            if (!params.showNoMessages() && !AdminToolHelper.printDone) {
                AdminToolHelper.printException(exception);
                AdminToolHelper.printDone = true;
            }
            throw exception;
        }
    }

    private static Context getInitialContext(CommandLineArgs commandLineArgs) throws Exception {
        return AdminToolHelper.getInitialContext(commandLineArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManualMigration(CommandLineArgs commandLineArgs) throws Exception {
        Object object;
        Object object2;
        String string = commandLineArgs.getMigratableServerName();
        String string2 = commandLineArgs.getDestinationMachineName();
        DomainMBean domainMBean = null;
        Object var5_5 = null;
        Context context = null;
        ServerMigrationCoordinator serverMigrationCoordinator = null;
        try {
            object2 = this.getRuntimeMBeanServerConnection(commandLineArgs);
            object = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)object2, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME));
            domainMBean = object.getDomainConfiguration();
            context = ClusterAdminCommandLineInvoker.getInitialContext(commandLineArgs);
            serverMigrationCoordinator = (ServerMigrationCoordinator)context.lookup("weblogic/cluster/singleton/ServerMigrationCoordinator");
        }
        catch (NamingException namingException) {
            ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.err.println(managementTextTextFormatter.getFailedConnect(commandLineArgs.getURL()) + "[" + namingException + "]");
            }
            throw namingException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        object2 = domainMBean.lookupServer(string);
        if (object2 == null || !object2.isAutoMigrationEnabled()) {
            object = ManagementTextTextFormatter.getInstance();
            if (!commandLineArgs.showNoMessages()) {
                printStream.println(object.IncorrectMigratableServerName(string));
                return;
            }
        }
        if (object2.getCluster() == null && !commandLineArgs.showNoMessages()) {
            object = ManagementTextTextFormatter.getInstance();
            printStream.println(object.MigratableServerIsNotInCluster(string));
            return;
        }
        object = domainMBean.lookupMachine(string2);
        if (object == null && !commandLineArgs.showNoMessages()) {
            ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
            printStream.println(managementTextTextFormatter.IncorrectDestinationMachine(string2));
            return;
        }
        try {
            serverMigrationCoordinator.migrate(object2.getName(), object2.getMachine().getName(), object.getName(), commandLineArgs.getSourceDown(), commandLineArgs.getDestinationDown());
        }
        catch (ServerMigrationException serverMigrationException) {
            this.migrationFailed(object2.getMachine().getName(), string2, string, serverMigrationException);
            return;
        }
        this.migrationSucceeded(string);
    }

    private void migrationSucceeded(String string) {
        ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
        printStream.println(managementTextTextFormatter.getMigrationSucceeded(string));
    }

    private void migrationFailed(String string, String string2, String string3, ServerMigrationException serverMigrationException) {
        ManagementTextTextFormatter managementTextTextFormatter = ManagementTextTextFormatter.getInstance();
        switch (serverMigrationException.getStatus()) {
            case -2: {
                printStream.println(managementTextTextFormatter.getMigrationInProgress(string3));
                break;
            }
            case 1: {
                printStream.println(managementTextTextFormatter.getSourceMachineDown(string, string3));
                break;
            }
            case 2: {
                printStream.println(managementTextTextFormatter.getDestinationMachineDown(string2));
                break;
            }
            default: {
                printStream.println(managementTextTextFormatter.getMigrationFailed(string3, serverMigrationException.toString()));
            }
        }
    }

    private MBeanServerConnection getRuntimeMBeanServerConnection(CommandLineArgs commandLineArgs) throws IOException {
        String string = commandLineArgs.getUsername();
        String string2 = commandLineArgs.getPassword();
        JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:" + commandLineArgs.getURL() + "/jndi/" + "weblogic.management.mbeanservers.domainruntime");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("java.naming.security.principal", string);
        hashMap.put("java.naming.security.credentials", string2);
        hashMap.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
        return jMXConnector.getMBeanServerConnection();
    }

    private ConfigurationManagerMBean lookupMBeanServerConnection(CommandLineArgs commandLineArgs) throws Throwable {
        String string = commandLineArgs.getUsername();
        String string2 = commandLineArgs.getPassword();
        JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:" + commandLineArgs.getURL() + "/jndi/" + "weblogic.management.mbeanservers.edit");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("java.naming.security.principal", string);
        hashMap.put("java.naming.security.credentials", string2);
        hashMap.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
        ObjectName objectName = new ObjectName(EditServiceMBean.OBJECT_NAME);
        EditServiceMBean editServiceMBean = (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)jMXConnector.getMBeanServerConnection(), (ObjectName)objectName);
        return editServiceMBean.getConfigurationManager();
    }
}

