/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClusterValidatorInvoker {
    private static final boolean debug = false;
    private static final boolean verbose = true;
    private Document configXML = null;
    private HashMap clusterAddresses = new HashMap();
    private boolean noError = true;
    private static String domainName = null;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            ClusterValidatorInvoker.usage();
            return;
        }
        if (stringArray[0].equalsIgnoreCase("help")) {
            ClusterValidatorInvoker.usage();
            return;
        }
        String string = stringArray[0];
        ClusterValidatorInvoker clusterValidatorInvoker = new ClusterValidatorInvoker();
        ClusterValidatorInvoker.log("before XML parsing");
        Document document = null;
        try {
            document = clusterValidatorInvoker.getDOM(string);
        }
        catch (SAXException sAXException) {
            clusterValidatorInvoker.error("Could not parse config.xml file.");
            return;
        }
        catch (Exception exception) {
            clusterValidatorInvoker.error("Could not read the xml file. Make sure that the pathto the config file is correct");
            return;
        }
        Element element = document.getDocumentElement();
        domainName = element.getAttribute("Name");
        System.out.println("DomainName=" + domainName);
        HashMap hashMap = clusterValidatorInvoker.getMap(element, "Cluster");
        HashMap hashMap2 = clusterValidatorInvoker.getMap(element, "Server");
        clusterValidatorInvoker.validateMulticastAddress(hashMap);
        clusterValidatorInvoker.validateClusterAddressForServers(hashMap2, hashMap);
        if (clusterValidatorInvoker.noError) {
            System.out.println("Cluster configuration in " + string + " is valid.");
        }
    }

    public static void usage() {
        System.out.println("Usage: java ClusterValidator config.xml");
    }

    public static void log(String string) {
    }

    public static void warn(String string) {
        System.err.println("WARNING:" + string);
    }

    public void error(String string) {
        this.noError = false;
        System.err.println("ERROR:" + string);
    }

    private HashMap getMap(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string2 = ClusterValidatorInvoker.getAttribute(node, "Name");
            if (string.equals("Cluster") && string2.equals(domainName)) {
                ClusterValidatorInvoker.warn("Cluster found with  same name as Domain. Recommend changing the name in config.xml");
            }
            hashMap.put(string2, node);
        }
        return hashMap;
    }

    private Document getDOM(String string) throws SAXException, Exception {
        if (this.configXML != null) {
            return this.configXML;
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.configXML = documentBuilder.parse(new InputSource(fileInputStream));
        return this.configXML;
    }

    private boolean validateClusterAddressForServers(HashMap hashMap, HashMap hashMap2) {
        if (hashMap == null) {
            return true;
        }
        boolean bl = true;
        Node node3 = null;
        Node node2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (Node node3 : hashMap.values()) {
            string = ClusterValidatorInvoker.getAttribute(node3, "Name");
            string2 = ClusterValidatorInvoker.getAttribute(node3, "Cluster");
            if (string2 == null || string2.length() == 0) continue;
            node2 = (Node)hashMap2.get(string2);
            if (node2 == null) {
                this.error(": Server:" + string + " refers to a non-existent Cluster:" + string2);
                bl = false;
                continue;
            }
            string3 = ClusterValidatorInvoker.getAttribute(node2, "ClusterAddress");
            if (this.checkListenAddressInClusterAddress(string3, string4 = ClusterValidatorInvoker.getAttribute(node3, "ListenAddress"), string5 = ClusterValidatorInvoker.getAttribute(node3, "ListenPort"), string, string2)) continue;
            this.error(": Server server:" + string + "'s address host:" + string4 + " port:" + string5 + " is not in clusterAddress:" + string3 + " for cluster:" + string2);
            bl = false;
        }
        return bl;
    }

    private boolean checkListenAddressInClusterAddress(String string, String string2, String string3, String string4, String string5) {
        int n;
        int n2;
        Object object;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            this.error(": Server:" + string4 + " from cluster:" + string5 + " is listening on Unknown Host listenAddress=" + string2);
        }
        boolean bl = false;
        ClusterAddressComponent[] clusterAddressComponentArray = (ClusterAddressComponent[])this.clusterAddresses.get(string5);
        if (clusterAddressComponentArray == null) {
            if (string.indexOf(",") != -1) {
                ClusterValidatorInvoker.warn(" Comma Separated Lists for cluster:" + string5 + "Address:" + string + " is not a recommended configuration");
                object = new StringTokenizer(string, ",");
                n2 = ((StringTokenizer)object).countTokens();
                clusterAddressComponentArray = new ClusterAddressComponent[n2];
                for (n = 0; n < n2; ++n) {
                    String string6 = ((StringTokenizer)object).nextToken();
                    int n3 = string6.indexOf(58);
                    clusterAddressComponentArray[n] = n3 == -1 ? new ClusterAddressComponent(string6, "-1") : new ClusterAddressComponent(string6.substring(0, n3), string6.substring(n3 + 1));
                }
            } else {
                int n4 = string.indexOf(58);
                clusterAddressComponentArray = new ClusterAddressComponent[]{n4 == -1 ? new ClusterAddressComponent(string, "-1") : new ClusterAddressComponent(string.substring(0, n4), string.substring(n4 + 1))};
            }
            this.clusterAddresses.put(string5, clusterAddressComponentArray);
        }
        bl = false;
        object = null;
        n2 = -1;
        for (n = 0; n < clusterAddressComponentArray.length; ++n) {
            try {
                object = InetAddress.getAllByName(clusterAddressComponentArray[n].host);
            }
            catch (UnknownHostException unknownHostException) {
                this.error(": Cluster Address:" + clusterAddressComponentArray[n].host + " is an unknown host");
            }
            try {
                n2 = Integer.parseInt(clusterAddressComponentArray[n].port);
            }
            catch (NumberFormatException numberFormatException) {
                this.error(": Port for cluster:" + string5 + " is not a valid port number");
            }
            if (object == null) continue;
            for (int i = 0; i < ((Object)object).length; ++i) {
                ClusterValidatorInvoker.log("Comparing clusterHost:" + object[i] + " listenAddress" + inetAddress + "clusterPort:" + n2 + "listenPort:" + string3);
                if (!((InetAddress)object[i]).equals(inetAddress) || n2 != -1 && n2 != Integer.parseInt(string3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateMulticastAddress(HashMap hashMap) {
        if (hashMap == null) {
            return true;
        }
        boolean bl = true;
        Object var3_3 = null;
        String string = null;
        Node node2 = null;
        for (Node node2 : hashMap.values()) {
            String string2 = ClusterValidatorInvoker.getAttribute(node2, "MulticastAddress");
            if (string2 == null) continue;
            string = ClusterValidatorInvoker.getAttribute(node2, "Name");
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                if (inetAddress.isMulticastAddress()) continue;
                bl = false;
                this.error("Cluster name:" + string + " has an INVALID Multicast address:" + string2 + " Please pick an address between (224.0.0.1 and 255.255.255.255)");
            }
            catch (UnknownHostException unknownHostException) {
                bl = false;
                this.error(": Cluster name:" + string + " refers to an UNKNOWN Multicast Address:" + string2 + " Please pick an address between (224.0.0.1 and 255.255.255.255)");
            }
        }
        return bl;
    }

    private static String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    class ClusterAddressComponent {
        public String host;
        public String port;

        public ClusterAddressComponent(String string, String string2) {
            ClusterValidatorInvoker.log("Building ClusterComponent host:" + string + " port:" + string2);
            this.host = string;
            this.port = string2;
        }
    }
}

