/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.commandline.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.RuntimeOperationsException;
import javax.naming.Context;
import weblogic.common.ResourceException;
import weblogic.common.T3ExecuteException;
import weblogic.management.MBeanHome;
import weblogic.management.commandline.CommandLineArgs;
import weblogic.management.commandline.OutputFormatter;
import weblogic.management.commandline.tools.AdminToolHelper;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.runtime.JDBCConnectionPoolRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.rjvm.PeerGoneException;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.TypeConversionUtils;

public final class JDBCCommandLineInvoker {
    static final String OK_STRING = "Ok";
    private static final boolean debug = false;
    static CommandLineArgs params = null;
    MBeanHome adminHome = null;
    Context ctx = null;
    Set matchedMBeans = null;
    OutputFormatter out = null;
    private static boolean CONTINUE = true;
    private static PrintStream printStream = System.out;
    private boolean EXIT = false;
    private boolean batchMode = false;

    public JDBCCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream) throws Exception {
        try {
            params = commandLineArgs;
            if (printStream != null) {
                JDBCCommandLineInvoker.printStream = printStream;
            }
            this.doCommandline();
        }
        catch (Exception exception) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                AdminToolHelper.printException(exception);
            }
            throw exception;
        }
    }

    public JDBCCommandLineInvoker(String[] stringArray, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = new CommandLineArgs(stringArray);
        if (printStream != null) {
            JDBCCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        this.doCommandline();
    }

    public JDBCCommandLineInvoker(CommandLineArgs commandLineArgs, PrintStream printStream, MBeanHome mBeanHome) throws Exception {
        params = commandLineArgs;
        if (printStream != null) {
            JDBCCommandLineInvoker.printStream = printStream;
        }
        this.adminHome = mBeanHome;
        this.doCommandline();
    }

    public JDBCCommandLineInvoker(String[] stringArray, PrintStream printStream) throws Exception {
        this(new CommandLineArgs(stringArray), printStream);
    }

    public static void main(String[] stringArray) throws Exception {
        JDBCCommandLineInvoker jDBCCommandLineInvoker = new JDBCCommandLineInvoker(stringArray, System.out);
    }

    static void executeResetPoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        string = adminToolHelper.nextArg("", 0);
        try {
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            boolean bl = false;
            Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
            for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean : set) {
                if (!string.equals(jDBCConnectionPoolRuntimeMBean.getName())) continue;
                bl = true;
                jDBCConnectionPoolRuntimeMBean.reset();
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                System.out.println(managementTextTextFormatter.getResetSuccess(string));
            }
            if (!bl) {
                JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean;
                jDBCConnectionPoolRuntimeMBean = new ManagementTextTextFormatter();
                throw new Exception(jDBCConnectionPoolRuntimeMBean.getNoSuchPool(string));
            }
            System.out.println(OK_STRING);
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getResetPoolSecException(string));
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailResetPool(string) + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void executeEnablePoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        block6: {
            String string = null;
            AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
            string = adminToolHelper.nextArg("", 0);
            try {
                Context context = AdminToolHelper.getInitialContext(commandLineArgs);
                MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
                boolean bl = false;
                Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
                for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean : set) {
                    if (!string.equals(jDBCConnectionPoolRuntimeMBean.getName())) continue;
                    bl = true;
                    jDBCConnectionPoolRuntimeMBean.enable();
                }
                if (!bl) {
                    JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean;
                    jDBCConnectionPoolRuntimeMBean = new ManagementTextTextFormatter();
                    throw new Exception(jDBCConnectionPoolRuntimeMBean.getNoSuchPool(string));
                }
            }
            catch (T3ExecuteException t3ExecuteException) {
                if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    if (!AdminToolHelper.printDone) {
                        AdminToolHelper.printDone = true;
                        System.out.println(managementTextTextFormatter.getEnablePoolSecException(string));
                    }
                    throw t3ExecuteException;
                }
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (AdminToolHelper.printDone) break block6;
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailEnablePool(string) + t3ExecuteException.getNestedException().toString());
            }
        }
    }

    static void executeResumePoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        block6: {
            String string = null;
            AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
            string = commandLineArgs.getPoolName();
            try {
                Context context = AdminToolHelper.getInitialContext(commandLineArgs);
                MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
                boolean bl = false;
                Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
                for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean : set) {
                    if (!string.equals(jDBCConnectionPoolRuntimeMBean.getName())) continue;
                    bl = true;
                    jDBCConnectionPoolRuntimeMBean.resume();
                }
                if (!bl) {
                    JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean;
                    jDBCConnectionPoolRuntimeMBean = new ManagementTextTextFormatter();
                    throw new Exception(jDBCConnectionPoolRuntimeMBean.getNoSuchPool(string));
                }
                System.out.println("\nConnection pool " + string + " is resumed successfully.");
            }
            catch (T3ExecuteException t3ExecuteException) {
                if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    if (!AdminToolHelper.printDone) {
                        AdminToolHelper.printDone = true;
                        System.out.println(managementTextTextFormatter.getEnablePoolSecException(string));
                    }
                    throw t3ExecuteException;
                }
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (AdminToolHelper.printDone) break block6;
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailEnablePool(string) + t3ExecuteException.getNestedException().toString());
            }
        }
    }

    static void executeDisablePoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        boolean bl = false;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        string = adminToolHelper.nextArg("", 0);
        bl = adminToolHelper.nextArg(true, 1);
        try {
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            boolean bl2 = false;
            Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
            for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean : set) {
                if (!string.equals(jDBCConnectionPoolRuntimeMBean.getName())) continue;
                bl2 = true;
                if (bl) {
                    jDBCConnectionPoolRuntimeMBean.disableDroppingUsers();
                    continue;
                }
                jDBCConnectionPoolRuntimeMBean.disableFreezingUsers();
            }
            if (!bl2) {
                JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean;
                jDBCConnectionPoolRuntimeMBean = new ManagementTextTextFormatter();
                throw new Exception(jDBCConnectionPoolRuntimeMBean.getNoSuchPool(string));
            }
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getDisablePoolSecException(string));
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailDisablePool(string) + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void executeSuspendPoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        string = commandLineArgs.getPoolName();
        try {
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            boolean bl = false;
            Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
            for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean : set) {
                if (!string.equals(jDBCConnectionPoolRuntimeMBean.getName())) continue;
                bl = true;
                jDBCConnectionPoolRuntimeMBean.suspend();
            }
            if (!bl) {
                JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean;
                jDBCConnectionPoolRuntimeMBean = new ManagementTextTextFormatter();
                throw new Exception(jDBCConnectionPoolRuntimeMBean.getNoSuchPool(string));
            }
            System.out.println("\nConnection pool " + string + " is suspended successfully.");
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getDisablePoolSecException(string));
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailDisablePool(string) + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void executeShutdownPoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        string = commandLineArgs.getPoolName();
        try {
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            boolean bl = false;
            Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
            for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean : set) {
                if (!string.equals(jDBCConnectionPoolRuntimeMBean.getName())) continue;
                bl = true;
                jDBCConnectionPoolRuntimeMBean.shutdown();
            }
            if (!bl) {
                JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean;
                jDBCConnectionPoolRuntimeMBean = new ManagementTextTextFormatter();
                throw new Exception(jDBCConnectionPoolRuntimeMBean.getNoSuchPool(string));
            }
            System.out.println("\nConnection pool " + string + " is shutdown successfully.");
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getDisablePoolSecException(string));
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailDisablePool(string) + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void executeExistsPoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        block9: {
            String string = null;
            AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
            string = adminToolHelper.nextArg("", 0);
            try {
                JDBCConnectionPoolMBean jDBCConnectionPoolMBean2;
                Context context = AdminToolHelper.getInitialContext(commandLineArgs);
                MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
                boolean bl = false;
                Set set = mBeanHome.getMBeansByType("JDBCConnectionPool");
                for (JDBCConnectionPoolMBean jDBCConnectionPoolMBean2 : set) {
                    if (!jDBCConnectionPoolMBean2.getName().equals(string)) continue;
                    bl = true;
                }
                if (bl) {
                    jDBCConnectionPoolMBean2 = new ManagementTextTextFormatter();
                    if (!AdminToolHelper.printDone) {
                        AdminToolHelper.printDone = true;
                        System.out.println(jDBCConnectionPoolMBean2.getPoolExists(string));
                    }
                    break block9;
                }
                jDBCConnectionPoolMBean2 = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(jDBCConnectionPoolMBean2.getPoolNotExists(string));
                }
                throw new Exception(jDBCConnectionPoolMBean2.getNoSuchPool(string));
            }
            catch (T3ExecuteException t3ExecuteException) {
                if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                    ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                    if (!AdminToolHelper.printDone) {
                        AdminToolHelper.printDone = true;
                        System.out.println(managementTextTextFormatter.getCheckExistSecException(string));
                    }
                    throw t3ExecuteException;
                }
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getFailCheckExists(string) + t3ExecuteException.getNestedException().toString());
                }
                throw t3ExecuteException;
            }
        }
    }

    static void executeTestPoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean2 = null;
        string = adminToolHelper.nextArg("", 0);
        String string2 = "";
        try {
            ManagementTextTextFormatter managementTextTextFormatter;
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.home.localhome");
            boolean bl = false;
            Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
            for (JDBCConnectionPoolRuntimeMBean jDBCConnectionPoolRuntimeMBean2 : set) {
                if (!string.equals(jDBCConnectionPoolRuntimeMBean2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) {
                managementTextTextFormatter = new ManagementTextTextFormatter();
                string2 = jDBCConnectionPoolRuntimeMBean2.testPool();
                if (string2 != null) {
                    System.out.println("\n" + managementTextTextFormatter.getjdbcTestUnsuc(string) + " : " + string2);
                    AdminToolHelper.printDone = true;
                    throw new Exception(managementTextTextFormatter.getjdbcTestUnsuc(string));
                }
            } else {
                ManagementTextTextFormatter managementTextTextFormatter2 = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter2.getPoolNotExists(string));
                }
                throw new Exception(managementTextTextFormatter2.getNoSuchPool(string));
            }
            System.out.println("\n" + managementTextTextFormatter.getjdbcConTestSuc(string));
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter.getCheckExistSecException(string));
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter.getFailCheckExists(string) + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void executeCreatePoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        string = adminToolHelper.nextArg("", 0);
        String string2 = adminToolHelper.nextArg("", 1);
        String string3 = "poolName";
        String string4 = "aclName";
        String string5 = "props";
        String string6 = "maxCapacity";
        String string7 = "initialCapacity";
        String string8 = "capacityIncrement";
        String string9 = "allowShrinking";
        String string10 = "shrinkPeriodMins";
        String string11 = "driver";
        String string12 = "url";
        String string13 = "refreshPeriod";
        String string14 = "testConnsOnReserve";
        String string15 = "testConnsOnRelease";
        String string16 = "testTableName";
        String string17 = "loginDelaySecs";
        String string18 = "secondsToTrustAnIdlePoolConnection";
        String string19 = "password";
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        if (string2.equals("")) {
            ManagementTextTextFormatter managementTextTextFormatter2 = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter2.getCRPool());
            }
            throw new Exception();
        }
        try {
            Object object3;
            Object object2;
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            Iterator iterator = mBeanHome.getMBeansByType("ServerRuntime").iterator();
            String string20 = null;
            while (iterator.hasNext()) {
                object2 = (ServerRuntimeMBean)iterator.next();
                if (!object2.isAdminServer()) continue;
                string20 = object2.getName();
                break;
            }
            if (string20 == null) {
                throw new Exception("Could not find the admin server for creating connection pool" + string);
            }
            object2 = (ServerMBean)mBeanHome.getAdminMBean(string20, "Server");
            boolean bl = false;
            Set set = mBeanHome.getMBeansByType("JDBCConnectionPoolRuntime");
            for (Object object3 : set) {
                if (!string.equals(object3.getName())) continue;
                bl = true;
            }
            if (bl) {
                object3 = new ManagementTextTextFormatter();
                throw new Exception(object3.getPoolExists(string));
            }
            object3 = new Properties();
            TypeConversionUtils.stringToDictionary((String)string2, (Dictionary)object3);
            if (string == null || string.equals("")) {
                throw new ResourceException(managementTextTextFormatter.getMissPool());
            }
            String string21 = ((Properties)object3).getProperty(string4);
            String string22 = null;
            string22 = ((Properties)object3).getProperty(string5);
            if (string22 == null) {
                throw new ResourceException(managementTextTextFormatter.getmissStartupValue(string5, string));
            }
            Properties properties = new Properties();
            TypeConversionUtils.stringToDictionary((String)string22, (Dictionary)properties, (String)";");
            int n = 1;
            if (((Properties)object3).getProperty(string6) != null && (n = Integer.parseInt(((Properties)object3).getProperty(string6))) < 1) {
                throw new ResourceException(managementTextTextFormatter.getPoolLessThanOne(string));
            }
            int n2 = 0;
            if (((Properties)object3).getProperty(string7) != null) {
                n2 = Integer.parseInt(((Properties)object3).getProperty(string7));
                if (n2 < 0) {
                    throw new ResourceException(managementTextTextFormatter.getPoolInLessThanZero(string, n2));
                }
                if (n2 > n) {
                    throw new ResourceException("Connection pool " + string + ": initial size (" + n2 + ") is greater than maximum size (" + n + ")");
                }
            }
            int n3 = 0;
            if (((Properties)object3).getProperty(string8) != null && (n3 = Integer.parseInt(((Properties)object3).getProperty(string8))) > n) {
                throw new ResourceException("Connection pool " + string + ": increment size (" + n3 + ") is greater than maximum size (" + n + ")");
            }
            boolean bl2 = true;
            int n4 = 0;
            bl2 = ((Properties)object3).getProperty(string9) == null || !((Properties)object3).getProperty(string9).equalsIgnoreCase("false");
            if (((Properties)object3).getProperty(string10) != null && (n4 = Integer.parseInt(((Properties)object3).getProperty(string10))) < 1) {
                throw new ResourceException("Connection pool " + string + ": shrink period is less than 1 minute");
            }
            if (bl2 && n4 == 0) {
                n4 = 15;
            }
            if (n3 < 1) {
                n3 = 1;
            }
            String string23 = null;
            String string24 = "weblogic.jdbc.oci.xa.XADataSource";
            string23 = ((Properties)object3).getProperty(string12);
            if (string23 == null) {
                throw new ResourceException("Missing startup value \"" + string12 + "\" in JDBC Connection Pool " + string);
            }
            String string25 = null;
            string25 = ((Properties)object3).getProperty(string11);
            if (string25 == null) {
                throw new ResourceException("Missing startup value \"" + string11 + "\" in JDBC Connection Pool " + string);
            }
            String string26 = null;
            string26 = ((Properties)object3).getProperty(string16);
            boolean bl3 = false;
            boolean bl4 = false;
            if (((Properties)object3).getProperty(string14) != null) {
                bl3 = true;
            }
            if (((Properties)object3).getProperty(string15) != null) {
                bl4 = true;
            }
            int n5 = 0;
            String string27 = null;
            string27 = ((Properties)object3).getProperty(string13);
            if (string27 != null && (n5 = Integer.parseInt(string27)) < 1) {
                throw new ResourceException("The refresh period must be one minute or more");
            }
            if ((bl4 || bl3) && string26 == null) {
                throw new ResourceException("Missing startup value \"" + string16 + "\" in JDBC Connection Pool " + string);
            }
            if (n5 > 0 && string26 == null) {
                throw new ResourceException("Missing startup value \"" + string16 + "\" in JDBC Connection Pool " + string);
            }
            int n6 = 0;
            if (((Properties)object3).getProperty(string17) != null && (n6 = Integer.parseInt(((Properties)object3).getProperty(string17))) < 0) {
                throw new ResourceException("Connection pool " + string + " : loginDelaySecs must be positive");
            }
            int n7 = 0;
            if (((Properties)object3).getProperty(string18) != null && (n7 = Integer.parseInt(((Properties)object3).getProperty(string18))) < 0) {
                throw new ResourceException("Connection pool " + string + " : secondsToTrustAnIdlePoolConnection must be positive");
            }
            boolean bl5 = false;
            String string28 = null;
            if (((Properties)object3).getProperty(string19) != null) {
                string28 = ((Properties)object3).getProperty(string19);
                bl5 = true;
            }
            JDBCConnectionPoolMBean jDBCConnectionPoolMBean = (JDBCConnectionPoolMBean)mBeanHome.createAdminMBean(string, "JDBCConnectionPool", mBeanHome.getDomainName());
            if (string21 != null) {
                jDBCConnectionPoolMBean.setACLName(string21);
            }
            jDBCConnectionPoolMBean.setURL(string23);
            jDBCConnectionPoolMBean.setDriverName(string25);
            jDBCConnectionPoolMBean.setProperties(properties);
            jDBCConnectionPoolMBean.setLoginDelaySeconds(n6);
            jDBCConnectionPoolMBean.setSecondsToTrustAnIdlePoolConnection(n7);
            jDBCConnectionPoolMBean.setInitialCapacity(n2);
            jDBCConnectionPoolMBean.setMaxCapacity(n);
            jDBCConnectionPoolMBean.setCapacityIncrement(n3);
            jDBCConnectionPoolMBean.setShrinkingEnabled(bl2);
            if (n4 != 0) {
                jDBCConnectionPoolMBean.setShrinkFrequencySeconds(n4 * 60);
            }
            jDBCConnectionPoolMBean.setTestFrequencySeconds(n5 * 60);
            jDBCConnectionPoolMBean.setTestTableName(string26);
            jDBCConnectionPoolMBean.setTestConnectionsOnReserve(bl3);
            jDBCConnectionPoolMBean.setTestConnectionsOnRelease(bl4);
            if (bl5) {
                jDBCConnectionPoolMBean.setPassword(string28);
                bl5 = true;
            }
            jDBCConnectionPoolMBean.addTarget((TargetMBean)object2);
            System.out.println(managementTextTextFormatter.getconnPoolSuc(string));
        }
        catch (T3ExecuteException t3ExecuteException) {
            if (t3ExecuteException.getNestedException().toString().indexOf("SecurityException") != -1) {
                ManagementTextTextFormatter managementTextTextFormatter3 = new ManagementTextTextFormatter();
                if (!AdminToolHelper.printDone) {
                    AdminToolHelper.printDone = true;
                    System.out.println(managementTextTextFormatter3.getCreatePoolSecException(string));
                }
                throw t3ExecuteException;
            }
            ManagementTextTextFormatter managementTextTextFormatter4 = new ManagementTextTextFormatter();
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printDone = true;
                System.out.println(managementTextTextFormatter4.getFailCreatePool(string) + t3ExecuteException.getNestedException().toString());
            }
            throw t3ExecuteException;
        }
    }

    static void executeDeletePoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        String string = null;
        AdminToolHelper adminToolHelper = new AdminToolHelper(commandLineArgs);
        string = adminToolHelper.nextArg("", 0);
        ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
        try {
            Context context = AdminToolHelper.getInitialContext(commandLineArgs);
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            JDBCConnectionPoolMBean jDBCConnectionPoolMBean = (JDBCConnectionPoolMBean)mBeanHome.getAdminMBean(string, "JDBCConnectionPool", mBeanHome.getDomainName());
            try {
                jDBCConnectionPoolMBean.setTargets(new TargetMBean[0]);
            }
            catch (Exception exception) {
                System.out.println(managementTextTextFormatter.getErrorUndeployingPool(string, exception));
            }
            mBeanHome.deleteMBean(jDBCConnectionPoolMBean);
            System.out.println(managementTextTextFormatter.getPoolDeleted(string));
        }
        catch (Exception exception) {
            System.out.println(managementTextTextFormatter.getErrorDeletingPool(string, exception));
        }
    }

    static void executeDestroyPoolCommand(CommandLineArgs commandLineArgs) throws Exception {
        try {
            JDBCCommandLineInvoker.executeDisablePoolCommand(commandLineArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDBCCommandLineInvoker.executeDeletePoolCommand(commandLineArgs);
    }

    void doOperation() throws Exception {
        switch (params.getOperation()) {
            case 12: {
                JDBCCommandLineInvoker.executeResetPoolCommand(params);
                break;
            }
            case 13: {
                JDBCCommandLineInvoker.executeCreatePoolCommand(params);
                break;
            }
            case 15: {
                JDBCCommandLineInvoker.executeEnablePoolCommand(params);
                break;
            }
            case 16: {
                JDBCCommandLineInvoker.executeDisablePoolCommand(params);
                break;
            }
            case 17: {
                JDBCCommandLineInvoker.executeExistsPoolCommand(params);
                break;
            }
            case 38: {
                JDBCCommandLineInvoker.executeTestPoolCommand(params);
                break;
            }
            case 14: {
                JDBCCommandLineInvoker.executeDisablePoolCommand(params);
                break;
            }
            case 44: {
                JDBCCommandLineInvoker.executeSuspendPoolCommand(params);
                break;
            }
            case 45: {
                JDBCCommandLineInvoker.executeShutdownPoolCommand(params);
                break;
            }
            case 46: {
                JDBCCommandLineInvoker.executeResumePoolCommand(params);
                break;
            }
            case 47: {
                JDBCCommandLineInvoker.executeDeletePoolCommand(params);
                break;
            }
            case 48: {
                JDBCCommandLineInvoker.executeDestroyPoolCommand(params);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCommandline() throws Exception {
        try {
            if (this.adminHome == null) {
                if (params.getAdminUrl() != null) {
                    params.setUrl(params.getAdminUrl());
                    this.adminHome = AdminToolHelper.getAdminMBeanHome(params);
                } else {
                    this.adminHome = AdminToolHelper.getMBeanHome(params);
                }
            }
            this.out = new OutputFormatter(printStream, params.isPretty());
            this.doOperation();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (AdminToolHelper.printDone) throw illegalArgumentException;
            AdminToolHelper.printException(illegalArgumentException);
            AdminToolHelper.printDone = true;
            throw illegalArgumentException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (!AdminToolHelper.printDone) {
                AdminToolHelper.printException(malformedObjectNameException, true);
                AdminToolHelper.printDone = true;
            }
            printStream.println("Usage:\n" + CommandLineArgs.getUsageString());
            throw malformedObjectNameException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw instanceNotFoundException;
            printStream.println(managementTextTextFormatter.getCouldNotFindInstance(params.getMBeanObjName()));
            AdminToolHelper.printDone = true;
            throw instanceNotFoundException;
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            Throwable throwable = remoteRuntimeException.getNestedException();
            if (throwable instanceof PeerGoneException) {
                return;
            }
            if (AdminToolHelper.printDone) throw remoteRuntimeException;
            AdminToolHelper.printException((Exception)((Object)remoteRuntimeException), true);
            AdminToolHelper.printDone = true;
            throw remoteRuntimeException;
        }
        catch (ConnectException connectException) {
            if (AdminToolHelper.printDone) throw connectException;
            AdminToolHelper.printException("java.net.ConnectException", connectException);
            AdminToolHelper.printDone = true;
            throw connectException;
        }
        catch (IOException iOException) {
            ManagementTextTextFormatter managementTextTextFormatter = new ManagementTextTextFormatter();
            if (AdminToolHelper.printDone) throw iOException;
            AdminToolHelper.printException(managementTextTextFormatter.getErrorWriting(), iOException);
            AdminToolHelper.printDone = true;
            throw iOException;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeOperationsException) {
                RuntimeOperationsException runtimeOperationsException = (RuntimeOperationsException)exception;
                if (!(runtimeOperationsException.getTargetException() instanceof RemoteRuntimeException)) return;
            }
            if (params.showNoMessages() || AdminToolHelper.printDone) throw exception;
            AdminToolHelper.printException(exception);
            AdminToolHelper.printDone = true;
            throw exception;
        }
    }
}

